/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import io.skylite.common.collect.Tuple;
import io.skylite.core.http.HttpRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.opensearch.http.HttpPipelinedRequest;
import org.opensearch.http.HttpPipelinedResponse;

public class HttpPipeliningAggregator<Listener> {
    private final int maxEventsHeld;
    private final PriorityQueue<Tuple<HttpPipelinedResponse, Listener>> outboundHoldingQueue;
    private int readSequence;
    private int writeSequence;

    public HttpPipeliningAggregator(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.outboundHoldingQueue = new PriorityQueue<Tuple>(1, Comparator.comparing(Tuple::v1));
    }

    public HttpPipelinedRequest read(HttpRequest request) {
        return new HttpPipelinedRequest(this.readSequence++, request);
    }

    public List<Tuple<HttpPipelinedResponse, Listener>> write(HttpPipelinedResponse response, Listener listener) {
        if (this.outboundHoldingQueue.size() < this.maxEventsHeld) {
            Tuple<HttpPipelinedResponse, Listener> top;
            ArrayList<Tuple<HttpPipelinedResponse, Listener>> readyResponses = new ArrayList<Tuple<HttpPipelinedResponse, Listener>>();
            this.outboundHoldingQueue.add(new Tuple((Object)response, listener));
            while (!this.outboundHoldingQueue.isEmpty() && ((HttpPipelinedResponse)(top = this.outboundHoldingQueue.peek()).v1()).getSequence() == this.writeSequence) {
                this.outboundHoldingQueue.poll();
                readyResponses.add(top);
                ++this.writeSequence;
            }
            return readyResponses;
        }
        int eventCount = this.outboundHoldingQueue.size() + 1;
        throw new IllegalStateException("Too many pipelined events [" + eventCount + "]. Max events allowed [" + this.maxEventsHeld + "].");
    }

    public List<Tuple<HttpPipelinedResponse, Listener>> removeAllInflightResponses() {
        ArrayList<Tuple<HttpPipelinedResponse, Listener>> responses = new ArrayList<Tuple<HttpPipelinedResponse, Listener>>(this.outboundHoldingQueue);
        this.outboundHoldingQueue.clear();
        return responses;
    }
}

