/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import io.skylite.common.Nullable;
import io.skylite.core.common.Strings;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpChunk;
import io.skylite.core.http.HttpTransportSettings;
import io.skylite.core.http.StreamingHttpChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

class HttpTracer {
    private final Logger logger = LogManager.getLogger(HttpTracer.class);
    private volatile String[] tracerLogInclude;
    private volatile String[] tracerLogExclude;

    HttpTracer(Settings settings, ClusterSettings clusterSettings) {
        this.setTracerLogInclude((List)HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE.get(settings));
        this.setTracerLogExclude((List)HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE, this::setTracerLogInclude);
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE, this::setTracerLogExclude);
    }

    @Nullable
    HttpTracer maybeTraceRequest(RestRequest restRequest, @Nullable Exception e) {
        if (this.logger.isTraceEnabled() && TransportService.shouldTraceAction((String)restRequest.uri(), (String[])this.tracerLogInclude, (String[])this.tracerLogExclude)) {
            this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}][{}] received request from [{}]", new Object[]{restRequest.getRequestId(), restRequest.header("X-Opaque-Id"), restRequest.method(), restRequest.uri(), restRequest.getHttpChannel()}), (Throwable)e);
            return this;
        }
        return null;
    }

    void traceResponse(RestResponse restResponse, HttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}][{}][{}] sent response to [{}] success [{}]", new Object[]{requestId, opaqueHeader, restResponse.status(), restResponse.contentType(), contentLength, httpChannel, success}));
    }

    private void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    private void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }

    void traceChunk(HttpChunk chunk, StreamingHttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}] sent next chunk to [{}] success [{}]", new Object[]{requestId, opaqueHeader, contentLength, httpChannel, success}));
    }
}

