/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.common.Assertions;
import io.skylite.common.CheckedFunction;
import io.skylite.common.Nullable;
import io.skylite.common.collect.MapBuilder;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.WriteStateException;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.AbstractAsyncTask;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.env.ShardLock;
import io.skylite.core.env.ShardLockObtainFailedException;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.cache.IndexCache;
import io.skylite.core.index.cache.query.QueryCache;
import io.skylite.core.index.engine.BaseEngine;
import io.skylite.core.index.remote.RemoteMigrationIndexMetadataUpdater;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotInPrimaryModeException;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectoryFactory;
import io.skylite.core.index.translog.TranslogFactory;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.fielddata.cache.IndicesFieldDataCache;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MetadataStateFormat;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public class IndexService
extends BaseIndexService {
    private final IndexEventListener eventListener;
    private final NodeEnvironment nodeEnv;
    private final ShardStoreDeleter shardStoreDeleter;
    private final IndexStorePlugin.DirectoryFactory directoryFactory;
    private final IndexStorePlugin.DirectoryFactory remoteDirectoryFactory;
    private final IndexStorePlugin.RecoveryStateFactory recoveryStateFactory;
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final EngineFactory engineFactory;
    private final EngineConfigFactory engineConfigFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final List<SearchOperationListener> searchOperationListeners;
    private final List<IndexingOperationListener> indexingOperationListeners;
    private volatile AsyncRefreshTask refreshTask;
    private volatile AsyncTranslogFSync fsyncTask;
    private volatile AsyncGlobalCheckpointTask globalCheckpointTask;
    private volatile AsyncRetentionLeaseSyncTask retentionLeaseSyncTask;
    private final String INDEX_TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING = "index.translog.retention.check_interval";
    private final AsyncTrimTranslogTask trimTranslogTask;
    private final BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier;
    private final Supplier<TimeValue> clusterDefaultRefreshIntervalSupplier;
    private final RecoverySettings recoverySettings;
    private final RemoteStoreSettings remoteStoreSettings;
    private final CopyOnWriteArrayList<Consumer<IndexMetadata>> metadataListeners = new CopyOnWriteArrayList();
    public static final Setting<TimeValue> GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING = Setting.timeSetting((String)"index.global_checkpoint_sync.interval", (TimeValue)new TimeValue(30L, TimeUnit.SECONDS), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<TimeValue> RETENTION_LEASE_SYNC_INTERVAL_SETTING = Setting.timeSetting((String)"index.soft_deletes.retention_lease.sync_interval", (TimeValue)new TimeValue(30L, TimeUnit.SECONDS), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});

    public IndexService(IndexSettings indexSettings, BaseIndexService.IndexCreationContext indexCreationContext, NodeEnvironment nodeEnv, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, ShardStoreDeleter shardStoreDeleter, IndexAnalyzers indexAnalyzers, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, ClusterService clusterService, Client client, QueryCache queryCache, IndexStorePlugin.DirectoryFactory directoryFactory, IndexStorePlugin.DirectoryFactory remoteDirectoryFactory, IndexEventListener eventListener, Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> wrapperFactory, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, List<SearchOperationListener> searchOperationListeners, List<IndexingOperationListener> indexingOperationListeners, NamedWriteableRegistry namedWriteableRegistry, BooleanSupplier idFieldDataEnabled, BooleanSupplier allowExpensiveQueries, IndexNameExpressionResolver expressionResolver, AggregationRegistry aggregationRegistry, IndexStorePlugin.RecoveryStateFactory recoveryStateFactory, BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier, Supplier<TimeValue> clusterDefaultRefreshIntervalSupplier, RecoverySettings recoverySettings, RemoteStoreSettings remoteStoreSettings) {
        super(indexSettings, indexCreationContext, xContentRegistry, similarityService, indexAnalyzers, circuitBreakerService, bigArrays, threadPool, scriptService, clusterService, client, queryCache, mapperRegistry, indicesFieldDataCache, idFieldDataEnabled, allowExpensiveQueries, namedWriteableRegistry, expressionResolver, aggregationRegistry);
        this.shardStoreDeleter = shardStoreDeleter;
        this.eventListener = eventListener;
        this.nodeEnv = nodeEnv;
        this.directoryFactory = directoryFactory;
        this.remoteDirectoryFactory = remoteDirectoryFactory;
        this.recoveryStateFactory = recoveryStateFactory;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.engineConfigFactory = Objects.requireNonNull(engineConfigFactory);
        this.readerWrapper = wrapperFactory.apply(this);
        this.searchOperationListeners = Collections.unmodifiableList(searchOperationListeners);
        this.indexingOperationListeners = Collections.unmodifiableList(indexingOperationListeners);
        this.clusterDefaultRefreshIntervalSupplier = clusterDefaultRefreshIntervalSupplier;
        this.refreshTask = new AsyncRefreshTask(this, this);
        this.trimTranslogTask = new AsyncTrimTranslogTask(this, this);
        this.globalCheckpointTask = new AsyncGlobalCheckpointTask(this, this);
        this.retentionLeaseSyncTask = new AsyncRetentionLeaseSyncTask(this, this);
        this.translogFactorySupplier = translogFactorySupplier;
        this.recoverySettings = recoverySettings;
        this.remoteStoreSettings = remoteStoreSettings;
        this.updateFsyncTaskIfNecessary();
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public IndexEventListener getIndexEventListener() {
        return this.eventListener;
    }

    public Iterator<BaseIndexShard> iterator() {
        return this.shards.values().iterator();
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public NamedXContentRegistry xContentRegistry() {
        return this.xContentRegistry;
    }

    public SimilarityService similarityService() {
        return this.similarityService;
    }

    public Supplier<Sort> getIndexSortSupplier() {
        return this.indexSortSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String reason, boolean delete) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            try {
                Set<Integer> shardIds = this.shardIds();
                for (int shardId : shardIds) {
                    try {
                        this.removeShard(shardId, reason);
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to close shard", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{this.bitsetFilterCache, this.indexCache, this.indexFieldData, this.mapperService, this.refreshTask, this.fsyncTask, this.trimTranslogTask, this.globalCheckpointTask, this.retentionLeaseSyncTask});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{this.bitsetFilterCache, this.indexCache, this.indexFieldData, this.mapperService, this.refreshTask, this.fsyncTask, this.trimTranslogTask, this.globalCheckpointTask, this.retentionLeaseSyncTask});
        }
    }

    public synchronized void writeDanglingIndicesInfo() {
        if (this.closed.get()) {
            return;
        }
        try {
            MetadataStateFormat.INDEX_METADATA_FORMAT.writeAndCleanup((Object)this.getMetadata(), this.nodeEnv.indexPaths(this.index()));
        }
        catch (WriteStateException e) {
            this.logger.warn(() -> new ParameterizedMessage("failed to write dangling indices state for index {}", (Object)this.index()), (Throwable)e);
        }
    }

    public synchronized void deleteDanglingIndicesInfo() {
        if (this.closed.get()) {
            return;
        }
        try {
            MetadataStateFormat.deleteMetaState((Path[])this.nodeEnv.indexPaths(this.index()));
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("failed to delete dangling indices state for index {}", (Object)this.index()), (Throwable)e);
        }
    }

    public String indexUUID() {
        return this.indexSettings.getUUID();
    }

    private long getAvgShardSizeInBytes() throws IOException {
        long sum = 0L;
        int count = 0;
        Iterator<BaseIndexShard> iterator = this.iterator();
        while (iterator.hasNext()) {
            BaseIndexShard indexShard = iterator.next();
            sum += indexShard.store().stats(0L).sizeInBytes();
            ++count;
        }
        if (count == 0) {
            return -1L;
        }
        return sum / (long)count;
    }

    public synchronized IndexShard createShard(ShardRouting routing, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, SegmentReplicationCheckpointPublisher checkpointPublisher, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, RepositoriesService repositoriesService, DiscoveryNode targetNode, @Nullable DiscoveryNode sourceNode, DiscoveryNodes discoveryNodes) throws IOException {
        IndexShard indexShard;
        block14: {
            IndexShard indexShard2;
            Store store;
            ShardId shardId;
            block15: {
                Objects.requireNonNull(retentionLeaseSyncer);
                if (this.closed.get()) {
                    throw new IllegalStateException("Can't create shard " + String.valueOf(routing.shardId()) + ", closed");
                }
                Settings indexSettings = this.indexSettings.getSettings();
                shardId = routing.shardId();
                boolean success = false;
                store = null;
                indexShard2 = null;
                ShardLock lock = null;
                try {
                    lock = this.nodeEnv.shardLock(shardId, "starting shard", TimeUnit.SECONDS.toMillis(5L));
                    this.eventListener.beforeIndexShardCreated(shardId, indexSettings);
                    ShardPath path = this.getShardPath(routing, shardId, lock);
                    this.logger.debug("creating shard_id {}", (Object)shardId);
                    BaseEngine.Warmer engineWarmer = reader -> {
                        IndexShard baseShard = this.getShardOrNull(shardId.getId());
                        IndexShard shard = baseShard;
                        if (shard != null) {
                            this.warmer.warm(reader, shard.indexSettings().getIndex(), shard.state(), shard.shardId(), shard.warmerService(), shard.mapperService(), this.indexSettings);
                        }
                    };
                    Store remoteStore = null;
                    boolean seedRemote = false;
                    if (targetNode.isRemoteStoreNode()) {
                        Directory remoteDirectory;
                        if (this.indexSettings.isRemoteStoreEnabled()) {
                            remoteDirectory = this.remoteDirectoryFactory.newDirectory(this.indexSettings, path);
                        } else {
                            if (sourceNode == null || !sourceNode.isRemoteStoreNode()) {
                                if (!routing.primary()) {
                                    throw new IllegalStateException("Can't migrate a remote shard to replica before primary " + String.valueOf(routing.shardId()));
                                }
                                this.logger.info("DocRep shard {} is migrating to remote", (Object)shardId);
                                seedRemote = true;
                            }
                            remoteDirectory = ((RemoteSegmentStoreDirectoryFactory)this.remoteDirectoryFactory).newDirectory(RemoteStoreNodeAttribute.getRemoteStoreSegmentRepo((Settings)this.indexSettings.getNodeSettings()), this.indexSettings.getUUID(), shardId, this.indexSettings.getRemoteStorePathStrategy());
                        }
                        remoteStore = new Store(shardId, this.indexSettings, remoteDirectory, lock, Store.OnClose.EMPTY, path);
                    } else if (RemoteMigrationIndexMetadataUpdater.indexHasRemoteStoreSettings((Settings)indexSettings)) {
                        throw new IllegalStateException("[{" + String.valueOf(routing.shardId()) + "}] Cannot initialize shards with remote store index settings on non-remote store nodes");
                    }
                    Directory directory = this.directoryFactory.newDirectory(this.indexSettings, path);
                    store = new Store(shardId, this.indexSettings, directory, lock, (Store.OnClose)new StoreCloseListener(shardId, () -> this.eventListener.onStoreClosed(shardId)), path);
                    this.eventListener.onStoreCreated(shardId);
                    indexShard2 = new IndexShard(routing, this.indexSettings, path, store, this.indexSortSupplier, this.indexCache, this.mapperService, this.similarityService, this.engineFactory, this.engineConfigFactory, this.eventListener, this.readerWrapper, this.threadPool, this.bigArrays, engineWarmer, this.searchOperationListeners, this.indexingOperationListeners, () -> globalCheckpointSyncer.accept(shardId), retentionLeaseSyncer, this.circuitBreakerService, this.translogFactorySupplier, this.indexSettings.isSegRepEnabledOrRemoteNode() ? checkpointPublisher : null, remoteStore, remoteStoreStatsTrackerFactory, this.nodeEnv.nodeId(), this.recoverySettings, this.remoteStoreSettings, seedRemote, discoveryNodes);
                    this.eventListener.indexShardStateChanged((BaseIndexShard)indexShard2, null, indexShard2.state(), "shard created");
                    this.eventListener.afterIndexShardCreated((BaseIndexShard)indexShard2);
                    this.shards = MapBuilder.newMapBuilder((Map)this.shards).put((Object)shardId.id(), (Object)indexShard2).immutableMap();
                    success = true;
                    indexShard = indexShard2;
                    if (success) break block14;
                    if (lock == null) break block15;
                }
                catch (ShardLockObtainFailedException e) {
                    try {
                        throw new IOException("failed to obtain in-memory shard lock", e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            if (lock != null) {
                                IOUtils.closeWhileHandlingException(lock);
                            }
                            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeWhileHandlingException((Closeable)lock);
            }
            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
        }
        return indexShard;
    }

    private ShardPath getShardPath(ShardRouting routing, ShardId shardId, ShardLock lock) throws IOException {
        ShardPath path;
        if (this.indexSettings.isRemoteSnapshot()) {
            path = ShardPath.loadFileCachePath((NodeEnvironment)this.nodeEnv, (ShardId)shardId);
        } else {
            try {
                path = ShardPath.loadShardPath((Logger)this.logger, (NodeEnvironment)this.nodeEnv, (ShardId)shardId, (String)this.indexSettings.customDataPath());
            }
            catch (IllegalStateException ex) {
                this.logger.warn("{} failed to load shard path, trying to remove leftover", (Object)shardId);
                try {
                    ShardPath.deleteLeftoverShardDirectory((Logger)this.logger, (NodeEnvironment)this.nodeEnv, (ShardLock)lock, (IndexSettings)this.indexSettings);
                    path = ShardPath.loadShardPath((Logger)this.logger, (NodeEnvironment)this.nodeEnv, (ShardId)shardId, (String)this.indexSettings.customDataPath());
                }
                catch (Exception inner) {
                    ex.addSuppressed(inner);
                    throw ex;
                }
            }
            if (path == null) {
                HashMap<Path, Integer> dataPathToShardCount = new HashMap<Path, Integer>();
                Iterator<BaseIndexShard> iterator = this.iterator();
                while (iterator.hasNext()) {
                    BaseIndexShard shard = iterator.next();
                    Path dataPath = shard.shardPath().getRootStatePath();
                    Integer curCount = (Integer)dataPathToShardCount.get(dataPath);
                    if (curCount == null) {
                        curCount = 0;
                    }
                    dataPathToShardCount.put(dataPath, curCount + 1);
                }
                path = ShardPath.selectNewPathForShard((NodeEnvironment)this.nodeEnv, (ShardId)shardId, (IndexSettings)this.indexSettings, (long)(routing.getExpectedShardSize() == -1L ? this.getAvgShardSizeInBytes() : routing.getExpectedShardSize()), dataPathToShardCount);
                this.logger.debug("{} creating using a new path [{}]", (Object)shardId, (Object)path);
            } else {
                this.logger.debug("{} creating using an existing path [{}]", (Object)shardId, (Object)path);
            }
        }
        if (this.shards.containsKey(shardId.id())) {
            throw new IllegalStateException(String.valueOf(shardId) + " already exists");
        }
        return path;
    }

    @Nullable
    public IndexShard getShardOrNull(int shardId) {
        return (IndexShard)super.getShardOrNull(shardId);
    }

    public IndexShard getShard(int shardId) {
        return (IndexShard)super.getShard(shardId);
    }

    public synchronized void removeShard(int shardId, String reason) {
        ShardId sId = new ShardId(this.index(), shardId);
        if (!this.shards.containsKey(shardId)) {
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", (Object)shardId, (Object)reason);
        HashMap newShards = new HashMap(this.shards);
        BaseIndexShard indexShard = (BaseIndexShard)newShards.remove(shardId);
        this.shards = Collections.unmodifiableMap(newShards);
        this.closeShard(reason, sId, indexShard, indexShard.store(), indexShard.getIndexEventListener());
        this.logger.debug("[{}] closed (reason: [{}])", (Object)shardId, (Object)reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShard(String reason, ShardId sId, BaseIndexShard baseIndexShard, Store store, IndexEventListener listener) {
        IndexShard indexShard = (IndexShard)baseIndexShard;
        int shardId = sId.id();
        Settings indexSettings = this.getIndexSettings().getSettings();
        Store remoteStore = null;
        if (indexShard != null) {
            remoteStore = indexShard.remoteStore();
        }
        if (store != null) {
            store.beforeClose();
        }
        try {
            block19: {
                try {
                    listener.beforeIndexShardClosed(sId, (BaseIndexShard)indexShard, indexSettings);
                    if (indexShard == null) break block19;
                }
                catch (Throwable throwable) {
                    if (indexShard != null) {
                        try {
                            boolean flushEngine = !this.deleted.get() && this.closed.get();
                            indexShard.close(reason, flushEngine, this.deleted.get());
                        }
                        catch (Exception e) {
                            this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                        }
                    }
                    listener.afterIndexShardClosed(sId, (BaseIndexShard)indexShard, indexSettings);
                    throw throwable;
                }
                try {
                    boolean flushEngine = !this.deleted.get() && this.closed.get();
                    indexShard.close(reason, flushEngine, this.deleted.get());
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                }
            }
            listener.afterIndexShardClosed(sId, (BaseIndexShard)indexShard, indexSettings);
        }
        finally {
            try {
                if (store != null) {
                    store.close();
                } else {
                    this.logger.trace("[{}] store not initialized prior to closing shard, nothing to close", (Object)shardId);
                }
                if (remoteStore != null && indexShard.isPrimaryMode() && this.deleted.get()) {
                    remoteStore.close();
                }
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to close store on shard removal (reason: [{}])", (Object)shardId, (Object)reason), (Throwable)e);
            }
        }
    }

    private void onShardClose(ShardLock lock) {
        if (this.deleted.get()) {
            try {
                try {
                    this.eventListener.beforeIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
                finally {
                    this.shardStoreDeleter.deleteShardStore("delete index", lock, this.indexSettings);
                    this.eventListener.afterIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
            }
            catch (IOException e) {
                this.shardStoreDeleter.addPendingDelete(lock.getShardId(), this.indexSettings);
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to delete shard content - scheduled a retry", (Object)lock.getShardId().id()), (Throwable)e);
            }
        }
    }

    public RecoveryState createRecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, DiscoveryNode sourceNode) {
        return this.recoveryStateFactory.newRecoveryState(shardRouting, targetNode, sourceNode);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    List<IndexingOperationListener> getIndexOperationListeners() {
        return this.indexingOperationListeners;
    }

    List<SearchOperationListener> getSearchOperationListener() {
        return this.searchOperationListeners;
    }

    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        if (this.mapperService == null) {
            return false;
        }
        return this.mapperService.updateMapping(currentIndexMetadata, newIndexMetadata);
    }

    public IndexMetadata getMetadata() {
        return this.indexSettings.getIndexMetadata();
    }

    public void addMetadataListener(Consumer<IndexMetadata> listener) {
        this.metadataListeners.add(listener);
    }

    public synchronized void updateMetadata(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        boolean updateIndexSettings = this.indexSettings.updateIndexMetadata(newIndexMetadata);
        if (Assertions.ENABLED && currentIndexMetadata != null) {
            long newSettingsVersion;
            long currentSettingsVersion = currentIndexMetadata.getSettingsVersion();
            if (currentSettingsVersion == (newSettingsVersion = newIndexMetadata.getSettingsVersion())) {
                assert (!updateIndexSettings);
            } else {
                assert (updateIndexSettings);
                assert (currentSettingsVersion < newSettingsVersion) : "expected current settings version [" + currentSettingsVersion + "] to be less than new settings version [" + newSettingsVersion + "]";
            }
        }
        if (updateIndexSettings) {
            for (BaseIndexShard shard : this.shards.values()) {
                try {
                    ((IndexShard)shard).onSettingsChanged();
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("[{}] failed to notify shard about setting change", (Object)shard.shardId().id()), (Throwable)e);
                }
            }
            this.onRefreshIntervalChange();
            this.updateFsyncTaskIfNecessary();
        }
        this.metadataListeners.forEach((Consumer<Consumer<IndexMetadata>>)((Consumer<Consumer>)c -> c.accept(newIndexMetadata)));
    }

    public void onRefreshIntervalChange() {
        if (this.refreshTask.getInterval().equals((Object)this.getRefreshInterval())) {
            return;
        }
        this.threadPool.executor("refresh").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                IndexService.this.logger.warn("forced refresh failed after interval change", (Throwable)e);
            }

            public void doRun() throws Exception {
                IndexService.this.maybeRefreshEngine(true);
            }

            public boolean isForceExecution() {
                return true;
            }
        });
        this.rescheduleRefreshTasks();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFsyncTaskIfNecessary() {
        if (this.indexSettings.getTranslogDurability() == TranslogSettings.Durability.REQUEST) {
            try {
                if (this.fsyncTask == null) return;
                this.fsyncTask.close();
                return;
            }
            finally {
                this.fsyncTask = null;
            }
        } else if (this.fsyncTask == null) {
            this.fsyncTask = new AsyncTranslogFSync(this);
            return;
        } else {
            this.fsyncTask.updateIfNeeded();
        }
    }

    private void rescheduleRefreshTasks() {
        try {
            this.refreshTask.close();
        }
        finally {
            this.refreshTask = new AsyncRefreshTask(this, this);
        }
    }

    public final EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    final CheckedFunction<DirectoryReader, DirectoryReader, IOException> getReaderWrapper() {
        return this.readerWrapper;
    }

    final IndexStorePlugin.DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    private void maybeFSyncTranslogs() {
        if (this.indexSettings.getTranslogDurability() == TranslogSettings.Durability.ASYNC) {
            for (BaseIndexShard baseShard : this.shards.values()) {
                try {
                    IndexShard shard = (IndexShard)baseShard;
                    if (!shard.isSyncNeeded()) continue;
                    shard.sync();
                }
                catch (AlreadyClosedException shard) {
                }
                catch (IOException e) {
                    this.logger.warn("failed to sync translog", (Throwable)e);
                }
            }
        }
    }

    private void maybeRefreshEngine(boolean force) {
        if (this.getRefreshInterval().millis() > 0L || force) {
            for (BaseIndexShard shard : this.shards.values()) {
                try {
                    ((IndexShard)shard).scheduledRefresh();
                }
                catch (IndexShardClosedException | AlreadyClosedException throwable) {}
            }
        }
    }

    private void maybeTrimTranslog() {
        block6: for (BaseIndexShard shard : this.shards.values()) {
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block6;
                }
                case POST_RECOVERY: 
                case STARTED: {
                    try {
                        ((IndexShard)shard).trimTranslog();
                    }
                    catch (IndexShardClosedException | AlreadyClosedException throwable) {}
                    continue block6;
                }
            }
            throw new IllegalStateException("unknown state: " + String.valueOf(shard.state()));
        }
    }

    private void maybeSyncGlobalCheckpoints() {
        this.sync(is -> is.maybeSyncGlobalCheckpoint("background"), "global checkpoint");
    }

    private void syncRetentionLeases() {
        this.sync(IndexShard::syncRetentionLeases, "retention lease");
    }

    private void sync(Consumer<IndexShard> sync, String source) {
        block7: for (BaseIndexShard baseShard : this.shards.values()) {
            IndexShard shard = (IndexShard)baseShard;
            if (!shard.routingEntry().active() || !shard.routingEntry().primary()) continue;
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block7;
                }
                case POST_RECOVERY: {
                    assert (false) : "shard " + String.valueOf(shard.shardId()) + " is in post-recovery but marked as active";
                    continue block7;
                }
                case STARTED: {
                    try {
                        shard.runUnderPrimaryPermit(() -> sync.accept(shard), e -> {
                            if (!(e instanceof AlreadyClosedException || e instanceof IndexShardClosedException || e instanceof ShardNotInPrimaryModeException)) {
                                this.logger.warn((Message)new ParameterizedMessage("{} failed to execute {} sync", (Object)shard.shardId(), (Object)source), (Throwable)e);
                            }
                        }, "same", source + " sync");
                    }
                    catch (IndexShardClosedException | AlreadyClosedException throwable) {}
                    continue block7;
                }
            }
            throw new IllegalStateException("unknown state [" + String.valueOf(shard.state()) + "]");
        }
    }

    private TimeValue getRefreshInterval() {
        if (this.getIndexSettings().isExplicitRefresh()) {
            return this.getIndexSettings().getRefreshInterval();
        }
        return this.clusterDefaultRefreshIntervalSupplier.get();
    }

    AsyncRefreshTask getRefreshTask() {
        return this.refreshTask;
    }

    public TimeValue getRefreshTaskInterval() {
        return this.refreshTask.getInterval();
    }

    AsyncTranslogFSync getFsyncTask() {
        return this.fsyncTask;
    }

    public AsyncTrimTranslogTask getTrimTranslogTask() {
        return this.trimTranslogTask;
    }

    public boolean clearCaches(boolean queryCache, boolean fieldDataCache, String ... fields) {
        boolean clearedAtLeastOne = false;
        if (queryCache) {
            clearedAtLeastOne = true;
            this.indexCache.query().clear("api");
        }
        if (fieldDataCache) {
            clearedAtLeastOne = true;
            if (fields.length == 0) {
                this.indexFieldData.clear();
            } else {
                for (String field : fields) {
                    this.indexFieldData.clearField(field);
                }
            }
        }
        if (!clearedAtLeastOne) {
            if (fields.length == 0) {
                this.indexCache.clear("api");
                this.indexFieldData.clear();
            } else {
                for (String field : fields) {
                    this.indexFieldData.clearField(field);
                }
            }
        }
        return clearedAtLeastOne;
    }

    public static interface ShardStoreDeleter {
        public void deleteShardStore(String var1, ShardLock var2, IndexSettings var3) throws IOException;

        public void addPendingDelete(ShardId var1, IndexSettings var2);
    }

    final class AsyncRefreshTask
    extends BaseAsyncTask {
        AsyncRefreshTask(IndexService this$0, IndexService indexService) {
            super(indexService, indexService.getRefreshInterval());
        }

        protected void runInternal() {
            this.indexService.maybeRefreshEngine(false);
        }

        protected String getThreadPool() {
            return "refresh";
        }

        public String toString() {
            return "refresh";
        }
    }

    final class AsyncTrimTranslogTask
    extends BaseAsyncTask {
        AsyncTrimTranslogTask(IndexService this$0, IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getSettings().getAsTime("index.translog.retention.check_interval", TimeValue.timeValueMinutes((long)10L)));
        }

        @Override
        protected boolean mustReschedule() {
            return !this.indexService.closed.get();
        }

        protected void runInternal() {
            this.indexService.maybeTrimTranslog();
        }

        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "trim_translog";
        }
    }

    final class AsyncGlobalCheckpointTask
    extends BaseAsyncTask {
        AsyncGlobalCheckpointTask(IndexService this$0, IndexService indexService) {
            super(indexService, (TimeValue)GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        protected void runInternal() {
            this.indexService.maybeSyncGlobalCheckpoints();
        }

        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "global_checkpoint_sync";
        }
    }

    final class AsyncRetentionLeaseSyncTask
    extends BaseAsyncTask {
        AsyncRetentionLeaseSyncTask(IndexService this$0, IndexService indexService) {
            super(indexService, (TimeValue)RETENTION_LEASE_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        protected void runInternal() {
            this.indexService.syncRetentionLeases();
        }

        protected String getThreadPool() {
            return "management";
        }

        public String toString() {
            return "retention_lease_sync";
        }
    }

    static final class AsyncTranslogFSync
    extends BaseAsyncTask {
        AsyncTranslogFSync(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getTranslogSyncInterval());
        }

        protected String getThreadPool() {
            return "flush";
        }

        protected void runInternal() {
            this.indexService.maybeFSyncTranslogs();
        }

        void updateIfNeeded() {
            TimeValue newInterval = this.indexService.getIndexSettings().getTranslogSyncInterval();
            if (!newInterval.equals((Object)this.getInterval())) {
                this.setInterval(newInterval);
            }
        }

        public String toString() {
            return "translog_sync";
        }
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final Closeable[] toClose;

        StoreCloseListener(ShardId shardId, Closeable ... toClose) {
            this.shardId = shardId;
            this.toClose = toClose;
        }

        public void accept(ShardLock lock) {
            try {
                assert (lock.getShardId().equals((Object)this.shardId)) : "shard id mismatch, expected: " + String.valueOf(this.shardId) + " but got: " + String.valueOf(lock.getShardId());
                IndexService.this.onShardClose(lock);
            }
            finally {
                try {
                    IOUtils.close((Closeable[])this.toClose);
                }
                catch (IOException ex) {
                    IndexService.this.logger.debug("failed to close resource", (Throwable)ex);
                }
            }
        }
    }

    static abstract class BaseAsyncTask
    extends AbstractAsyncTask {
        protected final IndexService indexService;

        BaseAsyncTask(IndexService indexService, TimeValue interval) {
            super(indexService.logger, indexService.threadPool, interval, true);
            this.indexService = indexService;
            this.rescheduleIfNecessary();
        }

        protected boolean mustReschedule() {
            return !this.indexService.closed.get() && this.indexService.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN;
        }
    }
}

