/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.common.Booleans;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.common.logging.SkyliteLogMessage;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.mapper.ParsedDocument;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilders;
import org.opensearch.index.SlowLogLevel;

public final class IndexingSlowLog
implements IndexingOperationListener {
    public static final String INDEX_INDEXING_SLOWLOG_PREFIX = "index.indexing.slowlog";
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING = Setting.timeSetting((String)"index.indexing.slowlog.threshold.index.warn", (TimeValue)TimeValue.timeValueNanos((long)-1L), (TimeValue)TimeValue.timeValueMillis((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING = Setting.timeSetting((String)"index.indexing.slowlog.threshold.index.info", (TimeValue)TimeValue.timeValueNanos((long)-1L), (TimeValue)TimeValue.timeValueMillis((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING = Setting.timeSetting((String)"index.indexing.slowlog.threshold.index.debug", (TimeValue)TimeValue.timeValueNanos((long)-1L), (TimeValue)TimeValue.timeValueMillis((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING = Setting.timeSetting((String)"index.indexing.slowlog.threshold.index.trace", (TimeValue)TimeValue.timeValueNanos((long)-1L), (TimeValue)TimeValue.timeValueMillis((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<Boolean> INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING = Setting.boolSetting((String)"index.indexing.slowlog.reformat", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<SlowLogLevel> INDEX_INDEXING_SLOWLOG_LEVEL_SETTING = new Setting("index.indexing.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private final Logger indexLogger = LogManager.getLogger((String)"index.indexing.slowlog.index");
    private final Index index;
    private boolean reformat;
    private long indexWarnThreshold;
    private long indexInfoThreshold;
    private long indexDebugThreshold;
    private long indexTraceThreshold;
    private int maxSourceCharsToLog;
    private SlowLogLevel level;
    public static final Setting<Integer> INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING = new Setting("index.indexing.slowlog.source", "1000", value -> {
        try {
            return Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            return Booleans.parseBoolean((String)value, (boolean)true) ? Integer.MAX_VALUE : 0;
        }
    }, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});

    IndexingSlowLog(IndexSettings indexSettings) {
        Loggers.setLevel((Logger)this.indexLogger, (String)SlowLogLevel.TRACE.name());
        this.index = indexSettings.getIndex();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING, this::setReformat);
        this.reformat = (Boolean)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING);
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING, this::setWarnThreshold);
        this.indexWarnThreshold = ((TimeValue)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING)).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING, this::setInfoThreshold);
        this.indexInfoThreshold = ((TimeValue)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING)).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING, this::setDebugThreshold);
        this.indexDebugThreshold = ((TimeValue)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING)).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING, this::setTraceThreshold);
        this.indexTraceThreshold = ((TimeValue)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING)).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_LEVEL_SETTING, this::setLevel);
        this.setLevel((SlowLogLevel)((Object)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_LEVEL_SETTING)));
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING, this::setMaxSourceCharsToLog);
        this.maxSourceCharsToLog = (Integer)indexSettings.getValue(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING);
    }

    private void setMaxSourceCharsToLog(int maxSourceCharsToLog) {
        this.maxSourceCharsToLog = maxSourceCharsToLog;
    }

    private void setLevel(SlowLogLevel level) {
        this.level = level;
    }

    private void setWarnThreshold(TimeValue warnThreshold) {
        this.indexWarnThreshold = warnThreshold.nanos();
    }

    private void setInfoThreshold(TimeValue infoThreshold) {
        this.indexInfoThreshold = infoThreshold.nanos();
    }

    private void setDebugThreshold(TimeValue debugThreshold) {
        this.indexDebugThreshold = debugThreshold.nanos();
    }

    private void setTraceThreshold(TimeValue traceThreshold) {
        this.indexTraceThreshold = traceThreshold.nanos();
    }

    private void setReformat(boolean reformat) {
        this.reformat = reformat;
    }

    public void postIndex(ShardId shardId, EngineOperation.Index indexOperation, EngineResult.IndexResult result) {
        if (result.getResultType() == EngineResult.Type.SUCCESS) {
            ParsedDocument doc = indexOperation.parsedDoc();
            long tookInNanos = result.getTook();
            if (this.indexWarnThreshold >= 0L && tookInNanos > this.indexWarnThreshold && this.level.isLevelEnabledFor(SlowLogLevel.WARN)) {
                this.indexLogger.warn((Message)new IndexingSlowLogMessage(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexInfoThreshold >= 0L && tookInNanos > this.indexInfoThreshold && this.level.isLevelEnabledFor(SlowLogLevel.INFO)) {
                this.indexLogger.info((Message)new IndexingSlowLogMessage(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexDebugThreshold >= 0L && tookInNanos > this.indexDebugThreshold && this.level.isLevelEnabledFor(SlowLogLevel.DEBUG)) {
                this.indexLogger.debug((Message)new IndexingSlowLogMessage(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexTraceThreshold >= 0L && tookInNanos > this.indexTraceThreshold && this.level.isLevelEnabledFor(SlowLogLevel.TRACE)) {
                this.indexLogger.trace((Message)new IndexingSlowLogMessage(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            }
        }
    }

    boolean isReformat() {
        return this.reformat;
    }

    long getIndexWarnThreshold() {
        return this.indexWarnThreshold;
    }

    long getIndexInfoThreshold() {
        return this.indexInfoThreshold;
    }

    long getIndexTraceThreshold() {
        return this.indexTraceThreshold;
    }

    long getIndexDebugThreshold() {
        return this.indexDebugThreshold;
    }

    int getMaxSourceCharsToLog() {
        return this.maxSourceCharsToLog;
    }

    SlowLogLevel getLevel() {
        return this.level;
    }

    static final class IndexingSlowLogMessage
    extends SkyliteLogMessage {
        IndexingSlowLogMessage(Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            super(IndexingSlowLogMessage.prepareMap(index, doc, tookInNanos, reformat, maxSourceCharsToLog), IndexingSlowLogMessage.message(index, doc, tookInNanos, reformat, maxSourceCharsToLog), new Object[0]);
        }

        private static Map<String, Object> prepareMap(Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", index);
            map.put("took", TimeValue.timeValueNanos((long)tookInNanos));
            map.put("took_millis", "" + TimeUnit.NANOSECONDS.toMillis(tookInNanos));
            map.put("id", doc.id());
            map.put("routing", doc.routing());
            if (maxSourceCharsToLog == 0 || doc.source() == null || doc.source().length() == 0) {
                return map;
            }
            try {
                String source = XContentHelper.convertToJson((BytesReference)doc.source(), (boolean)reformat, (MediaType)doc.getMediaType());
                String trim = Strings.cleanTruncate((String)source, (int)maxSourceCharsToLog).trim();
                StringBuilder sb = new StringBuilder(trim);
                StringBuilders.escapeJson((StringBuilder)sb, (int)0);
                map.put("source", sb.toString());
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("_failed_to_convert_[" + e.getMessage() + "]");
                StringBuilders.escapeJson((StringBuilder)sb, (int)0);
                map.put("source", sb.toString());
                String message = String.format(Locale.ROOT, "failed to convert source for slow log entry [%s]", ((Object)map).toString());
                throw new UncheckedIOException(message, e);
            }
            return map;
        }

        private static String message(Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            StringBuilder sb = new StringBuilder();
            sb.append(index).append(" ");
            sb.append("took[").append(TimeValue.timeValueNanos((long)tookInNanos)).append("], ");
            sb.append("took_millis[").append(TimeUnit.NANOSECONDS.toMillis(tookInNanos)).append("], ");
            sb.append("id[").append(doc.id()).append("], ");
            if (doc.routing() == null) {
                sb.append("routing[]");
            } else {
                sb.append("routing[").append(doc.routing()).append("]");
            }
            if (maxSourceCharsToLog == 0 || doc.source() == null || doc.source().length() == 0) {
                return sb.toString();
            }
            try {
                String source = XContentHelper.convertToJson((BytesReference)doc.source(), (boolean)reformat, (MediaType)doc.getMediaType());
                sb.append(", source[").append(Strings.cleanTruncate((String)source, (int)maxSourceCharsToLog).trim()).append("]");
            }
            catch (IOException e) {
                sb.append(", source[_failed_to_convert_[").append(e.getMessage()).append("]]");
                String message = String.format(Locale.ROOT, "failed to convert source for slow log entry [%s]", sb.toString());
                throw new UncheckedIOException(message, e);
            }
            return sb.toString();
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING, INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING, INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING, INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING, INDEX_INDEXING_SLOWLOG_LEVEL_SETTING, INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING, INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING);
        }
    }
}

