/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.SegmentReplicationPerGroupStats;
import io.skylite.core.index.SegmentReplicationRejectionStats;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.index.SegmentReplicationStats;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class SegmentReplicationStatsTracker {
    private final IndicesService indicesService;
    private final Map<ShardId, AtomicInteger> rejectionCount;

    public SegmentReplicationStatsTracker(IndicesService indicesService) {
        this.indicesService = indicesService;
        this.rejectionCount = ConcurrentCollections.newConcurrentMap();
    }

    public SegmentReplicationRejectionStats getTotalRejectionStats() {
        return new SegmentReplicationRejectionStats((long)this.rejectionCount.values().stream().mapToInt(AtomicInteger::get).sum());
    }

    protected Map<ShardId, AtomicInteger> getRejectionCount() {
        return this.rejectionCount;
    }

    public SegmentReplicationStats getStats() {
        HashMap<ShardId, SegmentReplicationPerGroupStats> stats = new HashMap<ShardId, SegmentReplicationPerGroupStats>();
        Iterator<BaseIndexService> iterator = this.indicesService.iterator();
        while (iterator.hasNext()) {
            BaseIndexService indexService = iterator.next();
            for (BaseIndexShard indexShard : indexService) {
                if (!indexShard.indexSettings().isSegRepEnabledOrRemoteNode() || !indexShard.routingEntry().primary()) continue;
                stats.putIfAbsent(indexShard.shardId(), this.getStatsForShard((IndexShard)indexShard));
            }
        }
        return new SegmentReplicationStats(stats);
    }

    public void incrementRejectionCount(ShardId shardId) {
        this.rejectionCount.compute(shardId, (k, v) -> {
            if (v == null) {
                return new AtomicInteger(1);
            }
            v.incrementAndGet();
            return v;
        });
    }

    public SegmentReplicationPerGroupStats getStatsForShard(IndexShard indexShard) {
        return new SegmentReplicationPerGroupStats(indexShard.shardId(), indexShard.getReplicationStatsForTrackedReplicas(), (long)Optional.ofNullable(this.rejectionCount.get(indexShard.shardId())).map(AtomicInteger::get).orElse(0).intValue());
    }
}

