/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.translog.DefaultTranslogDeletionPolicy;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogException;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.lucene.Lucene;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.opensearch.index.engine.ReadOnlyEngine;
import org.opensearch.index.translog.NoOpTranslogManager;

public final class NoOpEngine
extends ReadOnlyEngine {
    private final SegmentsStats segmentsStats = new SegmentsStats();
    private final DocsStats docsStats;

    public NoOpEngine(EngineConfig config) {
        super(config, null, null, true, Function.identity(), true);
        Directory directory = this.store.directory();
        try (DirectoryReader reader = NoOpEngine.openDirectory(directory, config.getIndexSettings().isSoftDeleteEnabled());){
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader((LeafReader)ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.segmentsStats);
            }
            this.docsStats = this.docsStats((IndexReader)reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected DirectoryReader open(IndexCommit commit) throws IOException {
        Directory directory = commit.getDirectory();
        List indexCommits = DirectoryReader.listCommits((Directory)directory);
        final IndexCommit indexCommit = (IndexCommit)indexCommits.get(indexCommits.size() - 1);
        return new DirectoryReader(this, directory, new LeafReader[0], null){

            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            public long getVersion() {
                return 0L;
            }

            public boolean isCurrent() {
                return true;
            }

            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            protected void doClose() {
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.segmentsStats);
            if (!includeSegmentFileSizes) {
                stats.clearFileSizes();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }

    public DocsStats docStats() {
        return this.docsStats;
    }

    @Override
    public TranslogManager translogManager() {
        try {
            return new NoOpTranslogManager(this.shardId, this.readLock, () -> ((NoOpEngine)this).ensureOpen(), this.translogStats, new TranslogSnapshotIterator(this){

                public void close() {
                }

                public int totalOperations() {
                    return 0;
                }

                public TranslogOperation next() {
                    return null;
                }
            }){

                @Override
                public void trimUnreferencedTranslogFiles() throws TranslogException {
                    block21: {
                        Store store = NoOpEngine.this.engineConfig.getStore();
                        store.incRef();
                        try (ReleasableLock ignored = NoOpEngine.this.readLock.acquire();){
                            NoOpEngine.this.ensureOpen();
                            List commits = DirectoryReader.listCommits((Directory)store.directory());
                            if (commits.size() != 1 || NoOpEngine.this.translogStats.getTranslogSizeInBytes() <= NoOpEngine.this.translogStats.getUncommittedSizeInBytes()) break block21;
                            Map commitUserData = NoOpEngine.this.getLastCommittedSegmentInfos().getUserData();
                            String translogUuid = (String)commitUserData.get("translog_uuid");
                            if (translogUuid == null) {
                                throw new IllegalStateException("commit doesn't contain translog unique id");
                            }
                            TranslogConfig translogConfig = NoOpEngine.this.engineConfig.getTranslogConfig();
                            long localCheckpoint = Long.parseLong((String)commitUserData.get("local_checkpoint"));
                            DefaultTranslogDeletionPolicy translogDeletionPolicy = new DefaultTranslogDeletionPolicy(-1L, -1L, 0);
                            translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
                            try (Translog translog = NoOpEngine.this.engineConfig.getTranslogFactory().newTranslog(translogConfig, translogUuid, (TranslogDeletionPolicy)translogDeletionPolicy, NoOpEngine.this.engineConfig.getGlobalCheckpointSupplier(), NoOpEngine.this.engineConfig.getPrimaryTermSupplier(), seqNo -> {}, NoOpEngine.this.engineConfig.getStartedPrimarySupplier());){
                                translog.trimUnreferencedReaders();
                                NoOpEngine.this.translogStats = translog.stats();
                                assert (NoOpEngine.this.engineConfig.getIndexSettings().isRemoteTranslogStoreEnabled() || translog.currentFileGeneration() == translog.getMinFileGeneration()) : "translog was not trimmed  current gen " + translog.currentFileGeneration() + " != min gen " + translog.getMinFileGeneration();
                            }
                        }
                        catch (Exception e) {
                            try {
                                NoOpEngine.this.failEngine("translog trimming failed", e);
                            }
                            catch (Exception inner) {
                                e.addSuppressed(inner);
                            }
                            throw new EngineException(NoOpEngine.this.shardId, "failed to trim translog", (Throwable)e, new Object[0]);
                        }
                        finally {
                            store.decRef();
                        }
                    }
                }

                @Override
                public void setMinSeqNoToKeep(long seqNo) {
                }
            };
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

