/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.common.CheckedConsumer;
import io.skylite.common.Explicit;
import io.skylite.common.SetOnce;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.ArraySourceValueFetcher;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public abstract class AbstractGeometryFieldMapper<T>
extends FieldMapper {
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> ignoreZValue;
    private final Parser<T> parser;

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformedParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean ignoreMalformedByDefault) {
        return FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, initializer, (boolean)ignoreMalformedByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreZValueParam(Function<FieldMapper, Explicit<Boolean>> initializer) {
        return FieldMapper.Parameter.explicitBoolParam((String)"ignore_z_value", (boolean)true, initializer, (boolean)true);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser) {
        super(simpleName, mappedFieldType, indexAnalyzers, multiFields, copyTo);
        this.parser = parser;
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
    }

    public AbstractGeometryFieldType fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void index(ParseContext var1, T var2) throws IOException;

    public final void parse(ParseContext context) throws IOException {
        this.parser.parse(context.parser(), v -> this.index(context, v), e -> {
            if (!this.ignoreMalformed()) {
                throw new MapperParsingException("Failed to parse field [" + this.fieldType().name() + "] of type [" + this.contentType() + "]", (Throwable)e);
            }
            context.addIgnoredField(this.fieldType().name());
        });
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    public boolean ignoreZValue() {
        return (Boolean)this.ignoreZValue.value();
    }

    public static abstract class Parser<T> {
        public abstract void parse(XContentParser var1, CheckedConsumer<T, IOException> var2, Consumer<Exception> var3) throws IOException;

        public abstract Object format(T var1, String var2);

        private void fetchFromSource(Object sourceMap, Consumer<Object> consumer, String format) {
            try (XContentParser parser = MapXContentParser.wrapObject((Object)sourceMap);){
                this.parse(parser, v -> consumer.accept(this.format(v, format)), e -> {});
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    public static abstract class AbstractGeometryFieldType
    extends MappedFieldType {
        protected Parser<?> geometryParser;
        protected final boolean parsesArrayValue;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, boolean parsesArrayValue, Parser<?> geometryParser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.parsesArrayValue = parsesArrayValue;
            this.geometryParser = geometryParser;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]", new Object[0]);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            String geoFormat;
            String string = geoFormat = format != null ? format : "geojson";
            if (this.parsesArrayValue) {
                return new ArraySourceValueFetcher(this.name(), context){

                    protected Object parseSourceValue(Object value) {
                        ArrayList values = new ArrayList();
                        geometryParser.fetchFromSource(value, values::add, geoFormat);
                        return values;
                    }
                };
            }
            return new SourceValueFetcher(this.name(), context){

                protected Object parseSourceValue(Object value) {
                    SetOnce holder = new SetOnce();
                    geometryParser.fetchFromSource(value, arg_0 -> ((SetOnce)holder).set(arg_0), geoFormat);
                    return holder.get();
                }
            };
        }
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }
}

