/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FormattedDocValuesLoader;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;

public final class DocValueFetcher
implements ValueFetcher {
    private final DocValueFormat format;
    private final BaseIndexFieldData<?> ifd;
    private FormattedDocValuesLoader leaf;

    public DocValueFetcher(DocValueFormat format, BaseIndexFieldData<?> ifd) {
        this.format = format;
        this.ifd = ifd;
    }

    public void setNextReader(LeafReaderContext context) {
        this.leaf = this.ifd.load(context).loadFormattedDocValues(this.format);
    }

    public List<Object> fetchValues(SourceLookup lookup) throws IOException {
        if (!this.leaf.advanceExact(lookup.docId())) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.leaf.docValueCount());
        int count = this.leaf.docValueCount();
        for (int i = 0; i < count; ++i) {
            result.add(this.leaf.nextValue());
        }
        return result;
    }
}

