/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.common.Explicit;
import io.skylite.common.TriFunction;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Point;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.geo.AbstractLatLonPointIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.opensearch.index.mapper.ShapeQueryable;
import org.opensearch.index.query.VectorGeoPointShapeQueryProcessor;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<ParsedGeoPoint> {
    public static final String CONTENT_TYPE = "geo_point";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((GeoPointFieldMapper)in).builder;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<ParsedGeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, (Explicit<Boolean>)((Explicit)builder.ignoreMalformed.get()), (Explicit<Boolean>)((Explicit)builder.ignoreZValue.get()), (AbstractPointGeometryFieldMapper.ParsedPoint)builder.nullValue.get(), copyTo, parser);
        this.builder = builder;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value()).init(this);
    }

    @Override
    protected void index(ParseContext context, ParsedGeoPoint geometry) throws IOException {
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new LatLonPoint(this.fieldType().name(), geometry.lat(), geometry.lon()));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), geometry.lat(), geometry.lon()));
        } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
        if (this.fieldType().isStored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), geometry.toString()));
        }
        this.multiFields.parse((FieldMapper)this, context.createExternalValueContext((Object)geometry.geohash()));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)GeoPointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<AbstractPointGeometryFieldMapper.ParsedPoint> nullValue;
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)GeoPointFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> (Boolean)GeoPointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> (Boolean)GeoPointFieldMapper.builder((FieldMapper)m).stored.get(), (boolean)false);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)GeoPointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> (AbstractPointGeometryFieldMapper.ParsedPoint)GeoPointFieldMapper.builder((FieldMapper)m).nullValue.get(), (TriFunction<String, MappingParserContext, Object, AbstractPointGeometryFieldMapper.ParsedPoint>)((TriFunction)(n, c, o) -> Builder.parseNullValue(o, (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value())), () -> null).acceptsNull();
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.hasDocValues, this.indexed, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.meta);
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue((Object)hasDocValues);
            return this;
        }

        private static ParsedGeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            if (nullValue == null) {
                return null;
            }
            ParsedGeoPoint point = new ParsedGeoPoint();
            GeoUtils.parseGeoPoint((Object)nullValue, (GeoPoint)point, (boolean)ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoPoint.normalizePoint((GeoPoint)point);
            }
            return point;
        }

        public FieldMapper build(ContentPath contentPath) {
            AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint> geoParser = new AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint>(this.name, ParsedGeoPoint::new, (parser, point) -> {
                GeoUtils.parseGeoPoint((XContentParser)parser, (GeoPoint)point, (boolean)((Boolean)((Explicit)this.ignoreZValue.get()).value()));
                return point;
            }, (ParsedGeoPoint)this.nullValue.get(), (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value());
            GeoPointFieldType ft = new GeoPointFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), geoParser, (Map)this.meta.get());
            return new GeoPointFieldMapper(this.name, ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), geoParser, this);
        }
    }

    protected static class ParsedGeoPoint
    extends GeoPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedGeoPoint() {
        }

        @Override
        public void validate(String fieldName) {
            if (this.lat() > 90.0 || this.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + this.lat() + "] for " + fieldName);
            }
            if (this.lon() > 180.0 || this.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + this.lon() + "] for " + fieldName);
            }
        }

        @Override
        public void normalize(String name) {
            if (!this.isNormalizable(this.lat()) || !this.isNormalizable(this.lon())) {
                throw new SkyliteParseException("cannot normalize the point - not a number", new Object[0]);
            }
            GeoPoint.normalizePoint((GeoPoint)this);
        }

        @Override
        public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        public void resetCoords(double x, double y) {
            this.reset(y, x);
        }

        @Override
        public Point asGeometry() {
            return new Point(this.lon(), this.lat());
        }

        public boolean equals(Object other) {
            if (!(other instanceof GeoPoint)) {
                return false;
            }
            GeoPoint o = (GeoPoint)other;
            double oLat = o.lat();
            double oLon = o.lon();
            if (Double.compare(oLat, this.lat) != 0) {
                return false;
            }
            return Double.compare(oLon, this.lon) == 0;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class GeoPointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType
    implements ShapeQueryable {
        private final VectorGeoPointShapeQueryProcessor queryProcessor = new VectorGeoPointShapeQueryProcessor();

        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<?> parser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, true, parser, meta);
        }

        public GeoPointFieldType(String name) {
            this(name, true, false, true, null, Collections.emptyMap());
        }

        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, relation, context);
        }

        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(this.name(), (ValuesSourceType)GeoValuesSourceType.GEOPOINT);
        }

        public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
            GeoPoint originGeoPoint;
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)((String)origin));
            } else {
                throw new IllegalArgumentException("Illegal type [" + String.valueOf(origin.getClass()) + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery((String)this.name(), (float)boost, (double)originGeoPoint.lat(), (double)originGeoPoint.lon(), (double)pivotDouble);
        }
    }
}

