/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;

public class GeoShapeParser
extends AbstractGeometryFieldMapper.Parser<Geometry> {
    private final GeometryParser geometryParser;

    public GeoShapeParser(GeometryParser geometryParser) {
        this.geometryParser = geometryParser;
    }

    @Override
    public void parse(XContentParser parser, CheckedConsumer<Geometry, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
        try {
            consumer.accept((Object)this.geometryParser.parse(parser));
        }
        catch (SkyliteParseException | IllegalArgumentException | ParseException e) {
            onMalformed.accept((Exception)e);
        }
    }

    @Override
    public Object format(Geometry value, String format) {
        return this.geometryParser.geometryFormat(format).toXContentAsObject((Object)value);
    }
}

