/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.common.network.InetAddresses;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SimpleMappedFieldType;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class IpFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = (String)builder.nullValue.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    protected String contentType() {
        return this.fieldType().typeName();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.nullValue;
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString((String)addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.fieldType().name());
                    return;
                }
                throw e;
            }
        }
        if (this.indexed) {
            context.doc().add((IndexableField)new InetAddressPoint(this.fieldType().name(), address));
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.stored || this.indexed) {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> IpFieldMapper.toType((FieldMapper)m).indexed, (boolean)true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> IpFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam((String)ParseField.CommonFields.NULL_VALUE.getPreferredName(), (boolean)false, m -> IpFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final boolean ignoreMalformedByDefault;
        private final Version indexCreatedVersion;

        public Builder(String name, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = FieldMapper.Parameter.boolParam((String)"ignore_malformed", (boolean)true, m -> IpFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = (String)this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString((String)nullValueAsString);
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate("ip_mapper_null_field", "Error parsing [" + (String)this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.meta);
        }

        public IpFieldMapper build(ContentPath contentPath) {
            return new IpFieldMapper(this.name, (MappedFieldType)new IpFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.getValue(), (Boolean)this.stored.getValue(), (Boolean)this.hasDocValues.getValue(), this.parseNullValue(), (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), this);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;

        public IpFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, InetAddress nullValue, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.nullValue = nullValue;
        }

        public IpFieldType(String name) {
            this(name, true, false, true, null, Collections.emptyMap());
        }

        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString((String)value.toString());
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, this.nullValue){

                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString((String)value.toString());
                    return InetAddresses.toAddrString((InetAddress)address);
                }
            };
        }

        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple cidr = InetAddresses.parseCidr((String)term);
                return InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
            }
            InetAddress address = InetAddresses.forString((String)term);
            return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
        }

        public Query termsQuery(List<?> values, QueryShardContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString((String)value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper));
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), IpScriptDocValues::new, (ValuesSourceType)CoreValuesSourceType.IP);
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    for (int i = 0; i < this.in.docValueCount(); ++i) {
                        long ord = this.in.nextOrd();
                        this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                        this.ords[this.count++] = ord;
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode((byte[])Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString((InetAddress)address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public int size() {
                return this.count;
            }
        }
    }
}

