/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.SkyliteParseException;
import io.skylite.common.Numbers;
import io.skylite.common.QueryValidationException;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.utils.Geohash;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.geo.GeoValidationMethod;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.SpatialStrategy;
import org.opensearch.index.mapper.ShapeQueryable;
import org.opensearch.index.query.GeoExecType;

public class GeoBoundingBoxQueryBuilder
extends AbstractQueryBuilder<GeoBoundingBoxQueryBuilder> {
    public static final String NAME = "geo_bounding_box";
    public static final GeoExecType DEFAULT_TYPE = GeoExecType.MEMORY;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private GeoExecType type = DEFAULT_TYPE;
    private boolean ignoreUnmapped = false;

    public GeoBoundingBoxQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoBoundingBoxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.geoBoundingBox = new GeoBoundingBox(in);
        this.type = GeoExecType.readFromStream(in);
        this.validationMethod = GeoValidationMethod.readFromStream((StreamInput)in);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        this.geoBoundingBox.writeTo(out);
        this.type.writeTo(out);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoBoundingBoxQueryBuilder setCorners(double top, double left, double bottom, double right) {
        if (!GeoValidationMethod.isIgnoreMalformed((GeoValidationMethod)this.validationMethod)) {
            if (!Numbers.isValidDouble((double)top)) {
                throw new IllegalArgumentException("top latitude is invalid: " + top);
            }
            if (!Numbers.isValidDouble((double)left)) {
                throw new IllegalArgumentException("left longitude is invalid: " + left);
            }
            if (!Numbers.isValidDouble((double)bottom)) {
                throw new IllegalArgumentException("bottom latitude is invalid: " + bottom);
            }
            if (!Numbers.isValidDouble((double)right)) {
                throw new IllegalArgumentException("right longitude is invalid: " + right);
            }
            if (top < bottom) {
                throw new IllegalArgumentException("top is below bottom corner: " + top + " vs. " + bottom);
            }
            if (top == bottom) {
                throw new IllegalArgumentException("top cannot be the same as bottom: " + top + " == " + bottom);
            }
            if (left == right) {
                throw new IllegalArgumentException("left cannot be the same as right: " + left + " == " + right);
            }
        }
        this.geoBoundingBox.topLeft().reset(top, left);
        this.geoBoundingBox.bottomRight().reset(bottom, right);
        return this;
    }

    public GeoBoundingBoxQueryBuilder setCorners(GeoPoint topLeft, GeoPoint bottomRight) {
        return this.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCorners(String geohash) {
        Rectangle ghBBox = Geohash.toBoundingBox((String)geohash);
        return this.setCorners(new GeoPoint(ghBBox.getMaxY(), ghBBox.getMinX()), new GeoPoint(ghBBox.getMinY(), ghBBox.getMaxX()));
    }

    public GeoBoundingBoxQueryBuilder setCorners(String topLeft, String bottomRight) {
        return this.setCorners(GeoPoint.fromGeohash((String)topLeft), GeoPoint.fromGeohash((String)bottomRight));
    }

    public GeoPoint topLeft() {
        return this.geoBoundingBox.topLeft();
    }

    public GeoPoint bottomRight() {
        return this.geoBoundingBox.bottomRight();
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(GeoPoint bottomLeft, GeoPoint topRight) {
        return this.setCorners(topRight.getLat(), bottomLeft.getLon(), bottomLeft.getLat(), topRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(String bottomLeft, String topRight) {
        return this.setCornersOGC(GeoPoint.fromGeohash((String)bottomLeft), GeoPoint.fromGeohash((String)topRight));
    }

    public GeoBoundingBoxQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoBoundingBoxQueryBuilder type(GeoExecType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is not allowed to be null.");
        }
        this.type = type;
        return this;
    }

    public GeoBoundingBoxQueryBuilder type(String type) {
        this.type = GeoExecType.fromString(type);
        return this;
    }

    public GeoExecType type() {
        return this.type;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoBoundingBoxQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed((GeoValidationMethod)this.validationMethod)) {
            return null;
        }
        GeoPoint topLeft = this.geoBoundingBox.topLeft();
        GeoPoint bottomRight = this.geoBoundingBox.bottomRight();
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude((double)topLeft.getLat())) {
            validationException = this.addValidationError("top latitude is invalid: " + topLeft.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude((double)topLeft.getLon())) {
            validationException = this.addValidationError("left longitude is invalid: " + topLeft.getLon(), validationException);
        }
        if (!GeoUtils.isValidLatitude((double)bottomRight.getLat())) {
            validationException = this.addValidationError("bottom latitude is invalid: " + bottomRight.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude((double)bottomRight.getLon())) {
            validationException = this.addValidationError("right longitude is invalid: " + bottomRight.getLon(), validationException);
        }
        return validationException;
    }

    public Query doToQuery(QueryShardContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context.getFullyQualifiedIndex(), "failed to find geo field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof ShapeQueryable)) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "type [" + String.valueOf(fieldType) + "] for field [" + this.fieldName + "] is not supported for [geo_bounding_box] queries. Must be one of [geo_point] or [geo_shape]", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "couldn't validate latitude/ longitude values", (Throwable)exception, new Object[0]);
        }
        GeoPoint luceneTopLeft = new GeoPoint(this.geoBoundingBox.topLeft());
        GeoPoint luceneBottomRight = new GeoPoint(this.geoBoundingBox.bottomRight());
        if (GeoValidationMethod.isCoerce((GeoValidationMethod)this.validationMethod)) {
            double left;
            double right = luceneBottomRight.getLon();
            boolean completeLonRange = (right - (left = luceneTopLeft.getLon())) % 360.0 == 0.0 && right > left;
            GeoPoint.normalizePoint((GeoPoint)luceneTopLeft, (boolean)true, (!completeLonRange ? 1 : 0) != 0);
            GeoPoint.normalizePoint((GeoPoint)luceneBottomRight, (boolean)true, (!completeLonRange ? 1 : 0) != 0);
            if (completeLonRange) {
                luceneTopLeft.resetLon(-180.0);
                luceneBottomRight.resetLon(180.0);
            }
        }
        ShapeQueryable shapeQueryable = (ShapeQueryable)fieldType;
        Rectangle rectangle = new Rectangle(luceneTopLeft.getLon(), luceneBottomRight.getLon(), luceneTopLeft.getLat(), luceneBottomRight.getLat());
        return shapeQueryable.shapeQuery((Geometry)rectangle, fieldType.name(), SpatialStrategy.RECURSIVE, ShapeRelation.INTERSECTS, context);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        this.geoBoundingBox.toXContentFragment(builder, false);
        builder.endObject();
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), (Object)this.validationMethod);
        builder.field(TYPE_FIELD.getPreferredName(), (Object)this.type);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoBoundingBoxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        GeoBoundingBox bbox = null;
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                try {
                    bbox = GeoBoundingBox.parseBoundingBox((XContentParser)parser);
                    fieldName = currentFieldName;
                    continue;
                }
                catch (Exception e) {
                    throw new SkyliteParseException("failed to parse [{}] query. [{}]", new Object[]{NAME, e.getMessage()});
                }
            }
            if (!token.isValue()) continue;
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString((String)parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                type = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, currentFieldName});
        }
        if (bbox == null) {
            throw new SkyliteParseException("failed to parse [{}] query. bounding box not provided", new Object[]{NAME});
        }
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(bbox.topLeft(), bbox.bottomRight());
        builder.queryName(queryName);
        builder.boost(boost);
        builder.type(GeoExecType.fromString(type));
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        return builder;
    }

    protected boolean doEquals(GeoBoundingBoxQueryBuilder other) {
        return Objects.equals(this.geoBoundingBox, other.geoBoundingBox) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(new Object[]{this.geoBoundingBox, this.type, this.validationMethod, this.fieldName, this.ignoreUnmapped});
    }

    public String getWriteableName() {
        return NAME;
    }
}

