/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.common.QueryValidationException;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.GeoDistance;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.geo.GeoValidationMethod;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.SpatialStrategy;
import org.opensearch.index.mapper.ShapeQueryable;

public class GeoDistanceQueryBuilder
extends AbstractQueryBuilder<GeoDistanceQueryBuilder> {
    public static final String NAME = "geo_distance";
    public static final DistanceUnit DEFAULT_DISTANCE_UNIT = DistanceUnit.DEFAULT;
    public static final GeoDistance DEFAULT_GEO_DISTANCE = GeoDistance.ARC;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_FIELD = new ParseField("distance", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private double distance;
    private GeoPoint center = new GeoPoint(Double.NaN, Double.NaN);
    private GeoDistance geoDistance = GeoDistance.ARC;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoDistanceQueryBuilder(String fieldName) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null or empty");
        }
        this.fieldName = fieldName;
    }

    public GeoDistanceQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.distance = in.readDouble();
        this.validationMethod = GeoValidationMethod.readFromStream((StreamInput)in);
        this.center = new GeoPoint(in);
        this.geoDistance = GeoDistance.readFromStream((StreamInput)in);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeDouble(this.distance);
        this.validationMethod.writeTo(out);
        this.center.writeTo(out);
        this.geoDistance.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoDistanceQueryBuilder point(GeoPoint point) {
        if (point == null) {
            throw new IllegalArgumentException("center point must not be null");
        }
        this.center = point;
        return this;
    }

    public GeoDistanceQueryBuilder point(double lat, double lon) {
        this.center = new GeoPoint(lat, lon);
        return this;
    }

    public GeoPoint point() {
        return this.center;
    }

    public GeoDistanceQueryBuilder distance(String distance) {
        return this.distance(distance, DistanceUnit.DEFAULT);
    }

    public GeoDistanceQueryBuilder distance(String distance, DistanceUnit unit) {
        if (Strings.isEmpty((CharSequence)distance)) {
            throw new IllegalArgumentException("distance must not be null or empty");
        }
        if (unit == null) {
            throw new IllegalArgumentException("distance unit must not be null");
        }
        double newDistance = DistanceUnit.parse((String)distance, (DistanceUnit)unit, (DistanceUnit)DistanceUnit.DEFAULT);
        if (newDistance <= 0.0) {
            throw new IllegalArgumentException("distance must be greater than zero");
        }
        this.distance = newDistance;
        return this;
    }

    public GeoDistanceQueryBuilder distance(double distance, DistanceUnit unit) {
        return this.distance(Double.toString(distance), unit);
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistanceQueryBuilder geohash(String geohash) {
        if (Strings.isEmpty((CharSequence)geohash)) {
            throw new IllegalArgumentException("geohash must not be null or empty");
        }
        this.center.resetFromGeoHash(geohash);
        return this;
    }

    public GeoDistanceQueryBuilder geoDistance(GeoDistance geoDistance) {
        if (geoDistance == null) {
            throw new IllegalArgumentException("geoDistance must not be null");
        }
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public void setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoDistanceQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected Query doToQuery(QueryShardContext shardContext) throws IOException {
        MappedFieldType fieldType = shardContext.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(shardContext.getFullyQualifiedIndex(), "failed to find geo field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof ShapeQueryable)) {
            throw new QueryShardException(shardContext.getFullyQualifiedIndex(), "type [" + String.valueOf(fieldType) + "] for field [" + this.fieldName + "] is not supported for [geo_distance] queries. Must be one of [geo_point] or [geo_shape]", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException(shardContext.getFullyQualifiedIndex(), "couldn't validate latitude/ longitude values", (Throwable)exception, new Object[0]);
        }
        if (GeoValidationMethod.isCoerce((GeoValidationMethod)this.validationMethod)) {
            GeoPoint.normalizePoint((GeoPoint)this.center, (boolean)true, (boolean)true);
        }
        ShapeQueryable shapeQueryable = (ShapeQueryable)fieldType;
        Circle circle = new Circle(this.center.lon(), this.center.lat(), this.distance);
        return shapeQueryable.shapeQuery((Geometry)circle, fieldType.name(), SpatialStrategy.RECURSIVE, ShapeRelation.INTERSECTS, shardContext);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(this.fieldName).value(this.center.lon()).value(this.center.lat()).endArray();
        builder.field(DISTANCE_FIELD.getPreferredName(), this.distance);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), (Object)this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoDistanceQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
        String fieldName = null;
        Object vDistance = null;
        DistanceUnit unit = DEFAULT_DISTANCE_UNIT;
        GeoDistance geoDistance = DEFAULT_GEO_DISTANCE;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                fieldName = currentFieldName;
                GeoUtils.parseGeoPoint((XContentParser)parser, (GeoPoint)point);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                GeoDistanceQueryBuilder.throwParsingExceptionOnMultipleFields((String)NAME, (XContentLocation)parser.getTokenLocation(), (String)fieldName, (String)currentFieldName);
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        point.resetLat(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        point.resetLon(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("geohash")) {
                        point.resetFromGeoHash(parser.text());
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geo_distance] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (DISTANCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    vDistance = parser.text();
                    continue;
                }
                vDistance = parser.numberValue();
                continue;
            }
            if (UNIT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                unit = DistanceUnit.fromString((String)parser.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                geoDistance = GeoDistance.fromString((String)parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString((String)parser.text());
                continue;
            }
            if (fieldName == null) {
                point.resetFromString(parser.text());
                fieldName = currentFieldName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, currentFieldName});
        }
        if (vDistance == null) {
            throw new ParsingException(parser.getTokenLocation(), "geo_distance requires 'distance' to be specified", new Object[0]);
        }
        GeoDistanceQueryBuilder qb = new GeoDistanceQueryBuilder(fieldName);
        if (vDistance instanceof Number) {
            qb.distance(((Number)vDistance).doubleValue(), unit);
        } else {
            qb.distance((String)vDistance, unit);
        }
        qb.point(point);
        if (validationMethod != null) {
            qb.setValidationMethod(validationMethod);
        }
        qb.geoDistance(geoDistance);
        qb.boost(boost);
        qb.queryName(queryName);
        qb.ignoreUnmapped(ignoreUnmapped);
        return qb;
    }

    protected int doHashCode() {
        return Objects.hash(this.center, this.geoDistance, this.distance, this.validationMethod, this.ignoreUnmapped);
    }

    protected boolean doEquals(GeoDistanceQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && this.distance == other.distance && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.center, other.center) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    private QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed((GeoValidationMethod)this.validationMethod)) {
            return null;
        }
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude((double)this.center.getLat())) {
            validationException = this.addValidationError("center point latitude is invalid: " + this.center.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude((double)this.center.getLon())) {
            validationException = this.addValidationError("center point longitude is invalid: " + this.center.getLon(), validationException);
        }
        return validationException;
    }

    public String getWriteableName() {
        return NAME;
    }
}

