/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.OpenSearchVersion;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.ParseField;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.termvectors.MultiTermVectorsItemResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsRequest;
import io.skylite.core.action.termvectors.MultiTermVectorsResponse;
import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.client.Client;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.search.MoreLikeThisQuery;
import io.skylite.core.mapper.KeywordFieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.TextFieldMapper;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class MoreLikeThisQueryBuilder
extends AbstractQueryBuilder<MoreLikeThisQueryBuilder> {
    public static final String NAME = "more_like_this";
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [more_like_this] queries. The type should no longer be specified in the [like] and [unlike] sections.";
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    public static final int DEFAULT_MIN_TERM_FREQ = 2;
    public static final int DEFAULT_MIN_DOC_FREQ = 5;
    public static final int DEFAULT_MAX_DOC_FREQ = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    public static final String DEFAULT_MINIMUM_SHOULD_MATCH = "30%";
    public static final float DEFAULT_BOOST_TERMS = 0.0f;
    public static final boolean DEFAULT_INCLUDE = false;
    public static final boolean DEFAULT_FAIL_ON_UNSUPPORTED_FIELDS = true;
    private static final Set<Class<? extends MappedFieldType>> SUPPORTED_FIELD_TYPES = new HashSet<Class>(Arrays.asList(TextFieldMapper.TextFieldType.class, KeywordFieldMapper.KeywordFieldType.class));
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final ParseField LIKE = new ParseField("like", new String[0]);
    private static final ParseField UNLIKE = new ParseField("unlike", new String[0]);
    private static final ParseField MAX_QUERY_TERMS = new ParseField("max_query_terms", new String[0]);
    private static final ParseField MIN_TERM_FREQ = new ParseField("min_term_freq", new String[0]);
    private static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
    private static final ParseField MAX_DOC_FREQ = new ParseField("max_doc_freq", new String[0]);
    private static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", new String[0]);
    private static final ParseField MAX_WORD_LENGTH = new ParseField("max_word_length", new String[0]);
    private static final ParseField STOP_WORDS = new ParseField("stop_words", new String[0]);
    private static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField BOOST_TERMS = new ParseField("boost_terms", new String[0]);
    private static final ParseField INCLUDE = new ParseField("include", new String[0]);
    private static final ParseField FAIL_ON_UNSUPPORTED_FIELD = new ParseField("fail_on_unsupported_field", new String[0]);
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    public static final ParseField DOC = new ParseField("doc", new String[0]);
    private static final ParseField PER_FIELD_ANALYZER = new ParseField("per_field_analyzer", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private final String[] fields;
    private final String[] likeTexts;
    private String[] unlikeTexts = Strings.EMPTY_ARRAY;
    private final Item[] likeItems;
    private Item[] unlikeItems = new Item[0];
    private int maxQueryTerms = 25;
    private int minTermFreq = 2;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLength = 0;
    private int maxWordLength = 0;
    private String[] stopWords;
    private String analyzer;
    private String minimumShouldMatch = "30%";
    private float boostTerms = 0.0f;
    private boolean include = false;
    private boolean failOnUnsupportedField = true;

    public MoreLikeThisQueryBuilder(String[] likeTexts, Item[] likeItems) {
        this(null, likeTexts, likeItems);
    }

    public MoreLikeThisQueryBuilder(@Nullable String[] fields, @Nullable String[] likeTexts, @Nullable Item[] likeItems) {
        if (fields != null && fields.length == 0) {
            throw new IllegalArgumentException("more_like_this query requires 'fields' to be specified");
        }
        if (!(likeTexts != null && likeTexts.length != 0 || likeItems != null && likeItems.length != 0)) {
            throw new IllegalArgumentException("more_like_this query requires either 'like' texts or items to be specified.");
        }
        this.fields = fields;
        this.likeTexts = Optional.ofNullable(likeTexts).orElse(Strings.EMPTY_ARRAY);
        this.likeItems = Optional.ofNullable(likeItems).orElse(new Item[0]);
    }

    public MoreLikeThisQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readOptionalStringArray();
        this.likeTexts = in.readStringArray();
        this.likeItems = in.readList(Item::new).toArray(new Item[0]);
        this.unlikeTexts = in.readStringArray();
        this.unlikeItems = in.readList(Item::new).toArray(new Item[0]);
        this.maxQueryTerms = in.readVInt();
        this.minTermFreq = in.readVInt();
        this.minDocFreq = in.readVInt();
        this.maxDocFreq = in.readVInt();
        this.minWordLength = in.readVInt();
        this.maxWordLength = in.readVInt();
        this.stopWords = in.readOptionalStringArray();
        this.analyzer = in.readOptionalString();
        this.minimumShouldMatch = in.readString();
        this.boostTerms = ((Float)in.readGenericValue()).floatValue();
        this.include = in.readBoolean();
        this.failOnUnsupportedField = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.fields);
        out.writeStringArray(this.likeTexts);
        out.writeList(Arrays.asList(this.likeItems));
        out.writeStringArray(this.unlikeTexts);
        out.writeList(Arrays.asList(this.unlikeItems));
        out.writeVInt(this.maxQueryTerms);
        out.writeVInt(this.minTermFreq);
        out.writeVInt(this.minDocFreq);
        out.writeVInt(this.maxDocFreq);
        out.writeVInt(this.minWordLength);
        out.writeVInt(this.maxWordLength);
        out.writeOptionalStringArray(this.stopWords);
        out.writeOptionalString(this.analyzer);
        out.writeString(this.minimumShouldMatch);
        out.writeGenericValue((Object)Float.valueOf(this.boostTerms));
        out.writeBoolean(this.include);
        out.writeBoolean(this.failOnUnsupportedField);
    }

    public String[] fields() {
        return this.fields;
    }

    public String[] likeTexts() {
        return this.likeTexts;
    }

    public Item[] likeItems() {
        return this.likeItems;
    }

    public MoreLikeThisQueryBuilder unlike(String[] unlikeTexts) {
        this.unlikeTexts = Optional.ofNullable(unlikeTexts).orElse(Strings.EMPTY_ARRAY);
        return this;
    }

    public String[] unlikeTexts() {
        return this.unlikeTexts;
    }

    public MoreLikeThisQueryBuilder unlike(Item[] unlikeItems) {
        this.unlikeItems = Optional.ofNullable(unlikeItems).orElse(new Item[0]);
        return this;
    }

    public Item[] unlikeItems() {
        return this.unlikeItems;
    }

    public MoreLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        if (maxQueryTerms <= 0) {
            throw new IllegalArgumentException("requires 'maxQueryTerms' to be greater than 0");
        }
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public int maxQueryTerms() {
        return this.maxQueryTerms;
    }

    public MoreLikeThisQueryBuilder minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public int minTermFreq() {
        return this.minTermFreq;
    }

    public MoreLikeThisQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public MoreLikeThisQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public int maxDocFreq() {
        return this.maxDocFreq;
    }

    public MoreLikeThisQueryBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public int minWordLength() {
        return this.minWordLength;
    }

    public MoreLikeThisQueryBuilder maxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public int maxWordLength() {
        return this.maxWordLength;
    }

    public MoreLikeThisQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisQueryBuilder stopWords(List<String> stopWords) {
        if (stopWords == null) {
            throw new IllegalArgumentException("requires stopwords to be non-null");
        }
        this.stopWords = stopWords.toArray(new String[0]);
        return this;
    }

    public String[] stopWords() {
        return this.stopWords;
    }

    public MoreLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MoreLikeThisQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            throw new IllegalArgumentException("[more_like_this] requires minimum should match to be non-null");
        }
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MoreLikeThisQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public float boostTerms() {
        return this.boostTerms;
    }

    public MoreLikeThisQueryBuilder include(boolean include) {
        this.include = include;
        return this;
    }

    public boolean include() {
        return this.include;
    }

    public MoreLikeThisQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public boolean failOnUnsupportedField() {
        return this.failOnUnsupportedField;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.fields != null) {
            builder.array(FIELDS.getPreferredName(), this.fields);
        }
        MoreLikeThisQueryBuilder.buildLikeField(builder, LIKE.getPreferredName(), this.likeTexts, this.likeItems);
        MoreLikeThisQueryBuilder.buildLikeField(builder, UNLIKE.getPreferredName(), this.unlikeTexts, this.unlikeItems);
        builder.field(MAX_QUERY_TERMS.getPreferredName(), this.maxQueryTerms);
        builder.field(MIN_TERM_FREQ.getPreferredName(), this.minTermFreq);
        builder.field(MIN_DOC_FREQ.getPreferredName(), this.minDocFreq);
        builder.field(MAX_DOC_FREQ.getPreferredName(), this.maxDocFreq);
        builder.field(MIN_WORD_LENGTH.getPreferredName(), this.minWordLength);
        builder.field(MAX_WORD_LENGTH.getPreferredName(), this.maxWordLength);
        if (this.stopWords != null) {
            builder.array(STOP_WORDS.getPreferredName(), this.stopWords);
        }
        if (this.analyzer != null) {
            builder.field(ANALYZER.getPreferredName(), this.analyzer);
        }
        builder.field(MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        builder.field(BOOST_TERMS.getPreferredName(), this.boostTerms);
        builder.field(INCLUDE.getPreferredName(), this.include);
        builder.field(FAIL_ON_UNSUPPORTED_FIELD.getPreferredName(), this.failOnUnsupportedField);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static MoreLikeThisQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<String> fields = null;
        ArrayList<String> likeTexts = new ArrayList<String>();
        ArrayList<String> unlikeTexts = new ArrayList<String>();
        ArrayList<Item> likeItems = new ArrayList<Item>();
        ArrayList<Item> unlikeItems = new ArrayList<Item>();
        int maxQueryTerms = 25;
        int minTermFreq = 2;
        int minDocFreq = 5;
        int maxDocFreq = Integer.MAX_VALUE;
        int minWordLength = 0;
        int maxWordLength = 0;
        ArrayList<String> stopWords = null;
        String analyzer = null;
        String minimumShouldMatch = DEFAULT_MINIMUM_SHOULD_MATCH;
        float boostTerms = 0.0f;
        boolean include = false;
        boolean failOnUnsupportedField = true;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (LIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                    MoreLikeThisQueryBuilder.parseLikeField(parser, likeTexts, likeItems);
                    continue;
                }
                if (UNLIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                    MoreLikeThisQueryBuilder.parseLikeField(parser, unlikeTexts, unlikeItems);
                    continue;
                }
                if (MAX_QUERY_TERMS.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxQueryTerms = parser.intValue();
                    continue;
                }
                if (MIN_TERM_FREQ.match(currentFieldName, parser.getDeprecationHandler())) {
                    minTermFreq = parser.intValue();
                    continue;
                }
                if (MIN_DOC_FREQ.match(currentFieldName, parser.getDeprecationHandler())) {
                    minDocFreq = parser.intValue();
                    continue;
                }
                if (MAX_DOC_FREQ.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxDocFreq = parser.intValue();
                    continue;
                }
                if (MIN_WORD_LENGTH.match(currentFieldName, parser.getDeprecationHandler())) {
                    minWordLength = parser.intValue();
                    continue;
                }
                if (MAX_WORD_LENGTH.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxWordLength = parser.intValue();
                    continue;
                }
                if (ANALYZER.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzer = parser.text();
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatch = parser.text();
                    continue;
                }
                if (BOOST_TERMS.match(currentFieldName, parser.getDeprecationHandler())) {
                    boostTerms = parser.floatValue();
                    continue;
                }
                if (INCLUDE.match(currentFieldName, parser.getDeprecationHandler())) {
                    include = parser.booleanValue();
                    continue;
                }
                if (FAIL_ON_UNSUPPORTED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (ParseField.CommonMetaFields.NAME_FIELD.getPreferredName().equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    fields = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    continue;
                }
                if (LIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryBuilder.parseLikeField(parser, likeTexts, likeItems);
                    }
                    continue;
                }
                if (UNLIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryBuilder.parseLikeField(parser, unlikeTexts, unlikeItems);
                    }
                    continue;
                }
                if (STOP_WORDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    stopWords = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        stopWords.add(parser.text());
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (LIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                MoreLikeThisQueryBuilder.parseLikeField(parser, likeTexts, likeItems);
                continue;
            }
            if (UNLIKE.match(currentFieldName, parser.getDeprecationHandler())) {
                MoreLikeThisQueryBuilder.parseLikeField(parser, unlikeTexts, unlikeItems);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (likeTexts.isEmpty() && likeItems.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "more_like_this requires 'like' to be specified", new Object[0]);
        }
        if (fields != null && fields.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "more_like_this requires 'fields' to be non-empty", new Object[0]);
        }
        String[] fieldsArray = fields == null ? null : fields.toArray(new String[0]);
        String[] likeTextsArray = likeTexts.isEmpty() ? null : likeTexts.toArray(new String[0]);
        String[] unlikeTextsArray = unlikeTexts.isEmpty() ? null : unlikeTexts.toArray(new String[0]);
        Item[] likeItemsArray = likeItems.isEmpty() ? null : likeItems.toArray(new Item[0]);
        Item[] unlikeItemsArray = unlikeItems.isEmpty() ? null : unlikeItems.toArray(new Item[0]);
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = (MoreLikeThisQueryBuilder)((MoreLikeThisQueryBuilder)new MoreLikeThisQueryBuilder(fieldsArray, likeTextsArray, likeItemsArray).unlike(unlikeTextsArray).unlike(unlikeItemsArray).maxQueryTerms(maxQueryTerms).minTermFreq(minTermFreq).minDocFreq(minDocFreq).maxDocFreq(maxDocFreq).minWordLength(minWordLength).maxWordLength(maxWordLength).analyzer(analyzer).minimumShouldMatch(minimumShouldMatch).boostTerms(boostTerms).include(include).failOnUnsupportedField(failOnUnsupportedField).boost(boost)).queryName(queryName);
        if (stopWords != null) {
            moreLikeThisQueryBuilder.stopWords(stopWords);
        }
        return moreLikeThisQueryBuilder;
    }

    private static void parseLikeField(XContentParser parser, List<String> texts, List<Item> items) throws IOException {
        if (parser.currentToken().isValue()) {
            texts.add(parser.text());
        } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            items.add(Item.parse(parser, new Item()));
        } else {
            throw new IllegalArgumentException("Content of 'like' parameter should either be a string or an object");
        }
    }

    private static void buildLikeField(XContentBuilder builder, String fieldName, String[] texts, Item[] items) throws IOException {
        if (texts.length > 0 || items.length > 0) {
            builder.startArray(fieldName);
            for (String text : texts) {
                builder.value(text);
            }
            for (Item item : items) {
                builder.value((Object)item);
            }
            builder.endArray();
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        NamedAnalyzer analyzerObj;
        Item[] likeItems = new Item[this.likeItems.length];
        for (int i = 0; i < likeItems.length; ++i) {
            likeItems[i] = new Item(this.likeItems[i]);
        }
        Item[] unlikeItems = new Item[this.unlikeItems.length];
        for (int i = 0; i < unlikeItems.length; ++i) {
            unlikeItems[i] = new Item(this.unlikeItems[i]);
        }
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(context.getSearchSimilarity());
        mltQuery.setMaxQueryTerms(this.maxQueryTerms);
        mltQuery.setMinTermFrequency(this.minTermFreq);
        mltQuery.setMinDocFreq(this.minDocFreq);
        mltQuery.setMaxDocFreq(this.maxDocFreq);
        mltQuery.setMinWordLen(this.minWordLength);
        mltQuery.setMaxWordLen(this.maxWordLength);
        mltQuery.setMinimumShouldMatch(this.minimumShouldMatch);
        if (this.stopWords != null) {
            mltQuery.setStopWords(new HashSet<String>(Arrays.asList(this.stopWords)));
        }
        if (this.boostTerms != 0.0f) {
            mltQuery.setBoostTerms(true);
            mltQuery.setBoostTermsFactor(this.boostTerms);
        }
        if ((analyzerObj = context.getIndexAnalyzers().get(this.analyzer)) == null) {
            analyzerObj = context.getIndexAnalyzer(f -> {
                throw new UnsupportedOperationException("No analyzer configured for field " + f);
            });
        }
        mltQuery.setAnalyzer(this.analyzer, (Analyzer)analyzerObj);
        boolean useDefaultField = this.fields == null;
        List<String> moreLikeFields = new ArrayList();
        if (useDefaultField) {
            moreLikeFields = context.defaultFields();
            if (moreLikeFields.size() == 1 && ((String)moreLikeFields.get(0)).equals("*") && (this.likeTexts.length > 0 || this.unlikeTexts.length > 0)) {
                throw new IllegalArgumentException("[more_like_this] query cannot infer the field to analyze the free text, you should update the [index.query.default_field] index setting to a field that exists in the mapping or set the [fields] option in the query.");
            }
        } else {
            for (String field : this.fields) {
                MappedFieldType fieldType = context.getFieldType(field);
                if (fieldType != null && !SUPPORTED_FIELD_TYPES.contains(fieldType.getClass())) {
                    if (!this.failOnUnsupportedField) continue;
                    throw new IllegalArgumentException("more_like_this only supports text/keyword fields: [" + field + "]");
                }
                moreLikeFields.add(fieldType == null ? field : fieldType.name());
            }
        }
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(new String[0]));
        if (this.likeTexts.length > 0) {
            mltQuery.setLikeText(this.likeTexts);
        }
        if (this.unlikeTexts.length > 0) {
            mltQuery.setUnlikeText(this.unlikeTexts);
        }
        if (likeItems.length > 0) {
            return this.handleItems(context, mltQuery, likeItems, unlikeItems, this.include, moreLikeFields, useDefaultField);
        }
        return mltQuery;
    }

    private Query handleItems(QueryShardContext context, MoreLikeThisQuery mltQuery, Item[] likeItems, Item[] unlikeItems, boolean include, List<String> moreLikeFields, boolean useDefaultField) throws IOException {
        MultiTermVectorsResponse unlikeItemsResponse;
        Fields[] unlikeFields;
        for (Item item : likeItems) {
            MoreLikeThisQueryBuilder.setDefaultIndexTypeFields(context, item, moreLikeFields, useDefaultField);
        }
        for (Item item : unlikeItems) {
            MoreLikeThisQueryBuilder.setDefaultIndexTypeFields(context, item, moreLikeFields, useDefaultField);
        }
        MultiTermVectorsResponse likeItemsResponse = this.fetchResponse((Client)Client.class.cast(context.getClient()), likeItems);
        mltQuery.setLikeFields(MoreLikeThisQueryBuilder.getFieldsFor(likeItemsResponse));
        if (unlikeItems.length > 0 && (unlikeFields = MoreLikeThisQueryBuilder.getFieldsFor(unlikeItemsResponse = this.fetchResponse((Client)Client.class.cast(context.getClient()), unlikeItems))).length > 0) {
            mltQuery.setUnlikeFields(unlikeFields);
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add((Query)mltQuery, BooleanClause.Occur.SHOULD);
        if (!include) {
            MoreLikeThisQueryBuilder.handleExclude(boolQuery, likeItems, context);
        }
        return boolQuery.build();
    }

    private static void setDefaultIndexTypeFields(QueryShardContext context, Item item, List<String> moreLikeFields, boolean useDefaultField) {
        if (item.index() == null) {
            item.index(context.index().getName());
        }
        if ((item.fields() == null || item.fields().length == 0) && item.doc() == null) {
            if (useDefaultField) {
                item.fields("*");
            } else {
                item.fields(moreLikeFields.toArray(new String[0]));
            }
        }
    }

    private MultiTermVectorsResponse fetchResponse(Client client, Item[] items) throws IOException {
        MultiTermVectorsRequest request = new MultiTermVectorsRequest();
        for (Item item : items) {
            request.add(item.toTermVectorsRequest());
        }
        return (MultiTermVectorsResponse)client.multiTermVectors(request).actionGet();
    }

    private static Fields[] getFieldsFor(MultiTermVectorsResponse responses) throws IOException {
        ArrayList<Fields> likeFields = new ArrayList<Fields>();
        for (MultiTermVectorsItemResponse response : responses) {
            if (response.isFailed()) {
                MoreLikeThisQueryBuilder.checkRoutingMissingException(response);
                continue;
            }
            TermVectorsResponse getResponse = response.getResponse();
            if (!getResponse.isExists()) continue;
            likeFields.add(getResponse.getFields());
        }
        return likeFields.toArray(Fields.EMPTY_ARRAY);
    }

    private static void checkRoutingMissingException(MultiTermVectorsItemResponse response) {
        Throwable cause = SkyliteExceptionsHelper.unwrap((Throwable)response.getFailure().getCause(), (Class[])new Class[]{RoutingMissingException.class});
        if (cause != null) {
            throw (RoutingMissingException)cause;
        }
    }

    private static void handleExclude(BooleanQuery.Builder boolQuery, Item[] likeItems, QueryShardContext context) {
        MappedFieldType idField = context.getFieldType(ParseField.CommonMetaFields.ID_FIELD.getPreferredName());
        if (idField == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (Item item : likeItems) {
            if (item.doc() != null) continue;
            ids.add(item.id());
        }
        if (!ids.isEmpty()) {
            Query query = idField.termsQuery(ids, context);
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
    }

    protected int doHashCode() {
        return Objects.hash(Arrays.hashCode(this.fields), Arrays.hashCode(this.likeTexts), Arrays.hashCode(this.unlikeTexts), Arrays.hashCode(this.likeItems), Arrays.hashCode(this.unlikeItems), this.maxQueryTerms, this.minTermFreq, this.minDocFreq, this.maxDocFreq, this.minWordLength, this.maxWordLength, Arrays.hashCode(this.stopWords), this.analyzer, this.minimumShouldMatch, Float.valueOf(this.boostTerms), this.include, this.failOnUnsupportedField);
    }

    protected boolean doEquals(MoreLikeThisQueryBuilder other) {
        return Arrays.equals(this.fields, other.fields) && Arrays.equals(this.likeTexts, other.likeTexts) && Arrays.equals(this.unlikeTexts, other.unlikeTexts) && Arrays.equals(this.likeItems, other.likeItems) && Arrays.equals(this.unlikeItems, other.unlikeItems) && Objects.equals(this.maxQueryTerms, other.maxQueryTerms) && Objects.equals(this.minTermFreq, other.minTermFreq) && Objects.equals(this.minDocFreq, other.minDocFreq) && Objects.equals(this.maxDocFreq, other.maxDocFreq) && Objects.equals(this.minWordLength, other.minWordLength) && Objects.equals(this.maxWordLength, other.maxWordLength) && Arrays.equals(this.stopWords, other.stopWords) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(Float.valueOf(this.boostTerms), Float.valueOf(other.boostTerms)) && Objects.equals(this.include, other.include) && Objects.equals(this.failOnUnsupportedField, other.failOnUnsupportedField);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        return this;
    }

    public static final class Item
    implements ToXContentObject,
    Writeable {
        public static final Item[] EMPTY_ARRAY = new Item[0];
        private String index;
        private String id;
        private BytesReference doc;
        private MediaType mediaType;
        private String[] fields;
        private Map<String, String> perFieldAnalyzer;
        private String routing;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Item() {
        }

        Item(Item copy) {
            if (copy.id == null && copy.doc == null) {
                throw new IllegalArgumentException("Item requires either id or doc to be non-null");
            }
            this.index = copy.index;
            this.id = copy.id;
            this.routing = copy.routing;
            this.doc = copy.doc;
            this.mediaType = copy.mediaType;
            this.fields = copy.fields;
            this.perFieldAnalyzer = copy.perFieldAnalyzer;
            this.version = copy.version;
            this.versionType = copy.versionType;
        }

        public Item(@Nullable String index, String id) {
            if (id == null) {
                throw new IllegalArgumentException("Item requires id to be non-null");
            }
            this.index = index;
            this.id = id;
        }

        public Item(@Nullable String index, XContentBuilder doc) {
            if (doc == null) {
                throw new IllegalArgumentException("Item requires doc to be non-null");
            }
            this.index = index;
            this.doc = BytesReference.bytes((XContentBuilder)doc);
            this.mediaType = doc.contentType();
        }

        Item(StreamInput in) throws IOException {
            this.index = in.readOptionalString();
            if (in.getVersion().before((Version)OpenSearchVersion.V_2_0_0)) {
                in.readOptionalString();
            }
            if (in.readBoolean()) {
                this.doc = (BytesReference)in.readGenericValue();
                this.mediaType = in.getVersion().onOrAfter((Version)OpenSearchVersion.V_2_10_0) ? in.readMediaType() : (MediaType)in.readEnum(XContentType.class);
            } else {
                this.id = in.readString();
            }
            this.fields = in.readOptionalStringArray();
            this.perFieldAnalyzer = (Map)in.readGenericValue();
            this.routing = in.readOptionalString();
            this.version = in.readLong();
            this.versionType = VersionType.readFromStream((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.index);
            if (out.getVersion().before((Version)OpenSearchVersion.V_2_0_0)) {
                out.writeOptionalString(null);
            }
            out.writeBoolean(this.doc != null);
            if (this.doc != null) {
                out.writeGenericValue((Object)this.doc);
                if (out.getVersion().onOrAfter((Version)OpenSearchVersion.V_2_10_0)) {
                    this.mediaType.writeTo(out);
                } else {
                    out.writeEnum((Enum)((XContentType)this.mediaType));
                }
            } else {
                out.writeString(this.id);
            }
            out.writeOptionalStringArray(this.fields);
            out.writeGenericValue(this.perFieldAnalyzer);
            out.writeOptionalString(this.routing);
            out.writeLong(this.version);
            this.versionType.writeTo(out);
        }

        public String index() {
            return this.index;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String id() {
            return this.id;
        }

        public BytesReference doc() {
            return this.doc;
        }

        public String[] fields() {
            return this.fields;
        }

        public Item fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public Map<String, String> perFieldAnalyzer() {
            return this.perFieldAnalyzer;
        }

        public Item perFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
            this.perFieldAnalyzer = perFieldAnalyzer;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        MediaType mediaType() {
            return this.mediaType;
        }

        TermVectorsRequest toTermVectorsRequest() {
            TermVectorsRequest termVectorsRequest = new TermVectorsRequest(this.index, this.id).selectedFields(this.fields).routing(this.routing).version(this.version).versionType(this.versionType).perFieldAnalyzer(this.perFieldAnalyzer).positions(false).offsets(false).payloads(false).fieldStatistics(false).termStatistics(false);
            if (this.doc != null) {
                termVectorsRequest.doc(this.doc, true, this.mediaType);
                this.id = termVectorsRequest.id();
            }
            return termVectorsRequest;
        }

        public static Item parse(XContentParser parser, Item item) throws IOException {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) continue;
                if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.index = parser.text();
                    continue;
                }
                if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.id = parser.text();
                    continue;
                }
                if (DOC.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.doc = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().copyCurrentStructure(parser));
                    item.mediaType = MediaTypeRegistry.JSON;
                    continue;
                }
                if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        ArrayList<String> fields = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            fields.add(parser.text());
                        }
                        item.fields(fields.toArray(new String[0]));
                        continue;
                    }
                    throw new SkyliteParseException("failed to parse More Like This item. field [fields] must be an array", new Object[0]);
                }
                if (PER_FIELD_ANALYZER.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.perFieldAnalyzer(TermVectorsRequest.readPerFieldAnalyzer((Map)parser.map()));
                    continue;
                }
                if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.routing = parser.text();
                    continue;
                }
                if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.version = parser.longValue();
                    continue;
                }
                if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    item.versionType = VersionType.fromString((String)parser.text());
                    continue;
                }
                throw new SkyliteParseException("failed to parse More Like This item. unknown field [{}]", new Object[]{currentFieldName});
            }
            if (item.id != null && item.doc != null) {
                throw new SkyliteParseException("failed to parse More Like This item. either [id] or [doc] can be specified, but not both!", new Object[0]);
            }
            if (item.id == null && item.doc == null) {
                throw new SkyliteParseException("failed to parse More Like This item. neither [id] nor [doc] is specified!", new Object[0]);
            }
            return item;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field(INDEX.getPreferredName(), this.index);
            }
            if (this.id != null) {
                builder.field(ID.getPreferredName(), this.id);
            }
            if (this.doc != null) {
                try (StreamInput stream = this.doc.streamInput();){
                    builder.rawField(DOC.getPreferredName(), (InputStream)stream, this.mediaType);
                }
            }
            if (this.fields != null) {
                builder.array(FIELDS.getPreferredName(), this.fields);
            }
            if (this.perFieldAnalyzer != null) {
                builder.field(PER_FIELD_ANALYZER.getPreferredName(), this.perFieldAnalyzer);
            }
            if (this.routing != null) {
                builder.field(ROUTING.getPreferredName(), this.routing);
            }
            if (this.version != -3L) {
                builder.field(VERSION.getPreferredName(), this.version);
            }
            if (this.versionType != VersionType.INTERNAL) {
                builder.field(VERSION_TYPE.getPreferredName(), this.versionType.toString().toLowerCase(Locale.ROOT));
            }
            return builder.endObject();
        }

        public String toString() {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.prettyPrint();
                this.toXContent(builder, EMPTY_PARAMS);
                return builder.toString();
            }
            catch (Exception e) {
                return "{ \"error\" : \"" + SkyliteExceptionsHelper.detailedMessage((Throwable)e) + "\"}";
            }
        }

        public int hashCode() {
            return Objects.hash(this.index, this.id, this.doc, Arrays.hashCode(this.fields), this.perFieldAnalyzer, this.routing, this.version, this.versionType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id) && Objects.equals(this.doc, other.doc) && Arrays.equals(this.fields, other.fields) && Objects.equals(this.perFieldAnalyzer, other.perFieldAnalyzer) && Objects.equals(this.routing, other.routing) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
        }
    }
}

