/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.action.search.MaxScoreCollector;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.InnerHitBuilder;
import io.skylite.core.index.query.LuceniaToParentBlockJoinQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.lucene.search.TopDocsAndMaxScore;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ParentChildrenBlockJoinQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.internal.SearchContext;

public class NestedQueryBuilder
extends AbstractQueryBuilder<NestedQueryBuilder> {
    public static final String NAME = "nested";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String path;
    private final ScoreMode scoreMode;
    private final QueryBuilder query;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode) {
        this(path, query, scoreMode, null);
    }

    private NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode, InnerHitBuilder innerHitBuilder) {
        this.path = (String)NestedQueryBuilder.requireValue((Object)path, (String)"[nested] requires 'path' field");
        this.query = (QueryBuilder)NestedQueryBuilder.requireValue((Object)query, (String)"[nested] requires 'query' field");
        this.scoreMode = (ScoreMode)NestedQueryBuilder.requireValue((Object)scoreMode, (String)"[nested] requires 'score_mode' field");
        this.innerHitBuilder = innerHitBuilder;
    }

    public NestedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
        this.scoreMode = ScoreMode.values()[in.readVInt()];
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = (InnerHitBuilder)in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
        out.writeVInt(this.scoreMode.ordinal());
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String path() {
        return this.path;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public NestedQueryBuilder innerHit(InnerHitBuilder innerHitBuilder) {
        this.innerHitBuilder = innerHitBuilder;
        innerHitBuilder.setIgnoreUnmapped(this.ignoreUnmapped);
        return this;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public NestedQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.setIgnoreUnmapped(ignoreUnmapped);
        }
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PATH_FIELD.getPreferredName(), this.path);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        if (this.scoreMode != null) {
            builder.field(SCORE_MODE_FIELD.getPreferredName(), NestedQueryBuilder.scoreModeAsString(this.scoreMode));
        }
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), (ToXContent)this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static NestedQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        QueryBuilder query = null;
        String path = null;
        String currentFieldName = null;
        InnerHitBuilder innerHitBuilder = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    innerHitBuilder = InnerHitBuilder.fromXContent((XContentParser)parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                path = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (SCORE_MODE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                scoreMode = NestedQueryBuilder.parseScoreMode(parser.text());
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        NestedQueryBuilder queryBuilder = (NestedQueryBuilder)((NestedQueryBuilder)new NestedQueryBuilder(path, query, scoreMode, innerHitBuilder).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        return queryBuilder;
    }

    public static ScoreMode parseScoreMode(String scoreModeString) {
        if ("none".equals(scoreModeString)) {
            return ScoreMode.None;
        }
        if ("min".equals(scoreModeString)) {
            return ScoreMode.Min;
        }
        if ("max".equals(scoreModeString)) {
            return ScoreMode.Max;
        }
        if ("avg".equals(scoreModeString)) {
            return ScoreMode.Avg;
        }
        if ("sum".equals(scoreModeString)) {
            return ScoreMode.Total;
        }
        throw new IllegalArgumentException("No score mode for child query [" + scoreModeString + "] found");
    }

    public static String scoreModeAsString(ScoreMode scoreMode) {
        if (scoreMode == ScoreMode.Total) {
            return "sum";
        }
        return scoreMode.name().toLowerCase(Locale.ROOT);
    }

    public final String getWriteableName() {
        return NAME;
    }

    protected boolean doEquals(NestedQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.path, that.path) && Objects.equals(this.scoreMode, that.scoreMode) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.path, this.scoreMode, this.innerHitBuilder, this.ignoreUnmapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerQuery;
        if (!context.allowExpensiveQueries()) {
            throw new SkyliteException("[joining] queries cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        ObjectMapper nestedObjectMapper = context.getObjectMapper(this.path);
        if (nestedObjectMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new IllegalStateException("[nested] failed to find nested object under path [" + this.path + "]");
        }
        if (!nestedObjectMapper.isNested()) {
            throw new IllegalStateException("[nested] nested object under path [" + this.path + "] is not of nested type");
        }
        NestedObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        BitSetProducer parentFilter = objectMapper == null ? context.bitsetFilter(Queries.newNonNestedFilter()) : context.bitsetFilter(objectMapper.nestedTypeFilter());
        BitSetProducer previousParentFilter = context.getParentFilter();
        try {
            context.setParentFilter(parentFilter);
            context.nestedScope().nextLevel((NestedObjectMapper)nestedObjectMapper);
            innerQuery = this.query.toQuery((QueryRewriteContext)context);
        }
        finally {
            context.setParentFilter(previousParentFilter);
            context.nestedScope().previousLevel();
        }
        NestedHelper nestedHelper = new NestedHelper(arg_0 -> ((QueryShardContext)context).getObjectMapper(arg_0), arg_0 -> ((QueryShardContext)context).isFieldMapped(arg_0));
        if (nestedHelper.mightMatchNonNestedDocs(innerQuery, this.path)) {
            innerQuery = Queries.filtered((Query)innerQuery, (Query)((NestedObjectMapper)nestedObjectMapper).nestedTypeFilter());
        }
        return new LuceniaToParentBlockJoinQuery(innerQuery, parentFilter, this.scoreMode, objectMapper == null ? null : objectMapper.fullPath());
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryRewriteContext);
        if (rewrittenQuery != this.query) {
            NestedQueryBuilder nestedQuery = new NestedQueryBuilder(this.path, rewrittenQuery, this.scoreMode, this.innerHitBuilder);
            nestedQuery.ignoreUnmapped(this.ignoreUnmapped);
            return nestedQuery;
        }
        return this;
    }

    public void extractInnerHitBuilders(AbstractQueryBuilder.InnerHitCollector<?> collector, AbstractQueryBuilder.InnerHitExtractor extractor) {
        if (this.innerHitBuilder != null) {
            InnerHitContextBuilder.MapBackedInnerHitCollector mapCollector;
            String name;
            String string = name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.path;
            if (collector instanceof InnerHitContextBuilder.MapBackedInnerHitCollector && (mapCollector = (InnerHitContextBuilder.MapBackedInnerHitCollector)collector).containsKey(name)) {
                throw new IllegalArgumentException("[inner_hits] already contains an entry for key [" + name + "]");
            }
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.MapBackedInnerHitCollector childCollector = new InnerHitContextBuilder.MapBackedInnerHitCollector(children);
            extractor.extract(this.query, (AbstractQueryBuilder.InnerHitCollector)childCollector);
            NestedInnerHitContextBuilder innerHitContextBuilder = new NestedInnerHitContextBuilder(this.path, this.query, this.innerHitBuilder, children);
            AbstractQueryBuilder.InnerHitCollector<?> typedCollector = collector;
            typedCollector.add(name, (Object)innerHitContextBuilder);
        }
    }

    static class NestedInnerHitContextBuilder
    extends InnerHitContextBuilder {
        private final String path;

        NestedInnerHitContextBuilder(String path, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
            super(query, innerHitBuilder, children);
            this.path = path;
        }

        @Override
        protected void doBuild(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
            QueryShardContext queryShardContext = parentSearchContext.getQueryShardContext();
            ObjectMapper objectMapper = queryShardContext.getObjectMapper(this.path);
            if (objectMapper == null || !objectMapper.isNested()) {
                if (!this.innerHitBuilder.isIgnoreUnmapped()) {
                    throw new IllegalStateException("[" + this.query.getName() + "] no mapping found for type [" + this.path + "]");
                }
                return;
            }
            NestedObjectMapper nestedObjectMapper = (NestedObjectMapper)objectMapper;
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : nestedObjectMapper.fullPath();
            NestedObjectMapper parentObjectMapper = queryShardContext.nestedScope().nextLevel(nestedObjectMapper);
            NestedInnerHitSubContext nestedInnerHits = new NestedInnerHitSubContext(name, parentSearchContext, parentObjectMapper, nestedObjectMapper);
            this.setupInnerHitsContext(queryShardContext, nestedInnerHits);
            queryShardContext.nestedScope().previousLevel();
            innerHitsContext.addInnerHitDefinition(nestedInnerHits);
        }
    }

    static final class NestedInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final NestedObjectMapper parentObjectMapper;
        private final NestedObjectMapper childObjectMapper;

        NestedInnerHitSubContext(String name, SearchContext context, NestedObjectMapper parentObjectMapper, NestedObjectMapper childObjectMapper) {
            super(name, context);
            this.parentObjectMapper = parentObjectMapper;
            this.childObjectMapper = childObjectMapper;
        }

        @Override
        public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
            assert (!this.seqNoAndPrimaryTerm());
            if (seqNoAndPrimaryTerm) {
                throw new UnsupportedOperationException("nested documents are not assigned sequence numbers");
            }
        }

        @Override
        public TopDocsAndMaxScore topDocs(SearchHit hit) throws IOException {
            TopScoreDocCollector topDocsCollector;
            Weight innerHitQueryWeight = this.getInnerHitQueryWeight();
            Query rawParentFilter = this.parentObjectMapper == null ? Queries.newNonNestedFilter() : this.parentObjectMapper.nestedTypeFilter();
            int parentDocId = hit.docId();
            int readerIndex = ReaderUtil.subIndex((int)parentDocId, (List)this.searcher().getIndexReader().leaves());
            LeafReaderContext ctx = (LeafReaderContext)this.searcher().getIndexReader().leaves().get(readerIndex);
            Query childFilter = this.childObjectMapper.nestedTypeFilter();
            BitSetProducer parentFilter = this.context.bitsetFilterCache().getBitSetProducer(rawParentFilter);
            ParentChildrenBlockJoinQuery q = new ParentChildrenBlockJoinQuery(parentFilter, childFilter, parentDocId);
            Weight weight = this.context.searcher().createWeight(this.context.searcher().rewrite((Query)q), org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            if (this.size() == 0) {
                TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                InnerHitsContext.intersect(weight, innerHitQueryWeight, (Collector)totalHitCountCollector, ctx);
                return new TopDocsAndMaxScore(new TopDocs(new TotalHits((long)totalHitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN);
            }
            int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
            MaxScoreCollector maxScoreCollector = null;
            if (this.sort() != null) {
                topDocsCollector = new TopFieldCollectorManager(this.sort().sort, topN, Integer.MAX_VALUE).newCollector();
                if (this.trackScores()) {
                    maxScoreCollector = new MaxScoreCollector();
                }
            } else {
                topDocsCollector = new TopScoreDocCollectorManager(topN, Integer.MAX_VALUE).newCollector();
                maxScoreCollector = new MaxScoreCollector();
            }
            InnerHitsContext.intersect(weight, innerHitQueryWeight, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, maxScoreCollector}), ctx);
            TopDocs td = topDocsCollector.topDocs(this.from(), this.size());
            float maxScore = Float.NaN;
            if (maxScoreCollector != null) {
                maxScore = maxScoreCollector.getMaxScore();
            }
            return new TopDocsAndMaxScore(td, maxScore);
        }
    }
}

