/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.core.geo.GeoPolygonDecomposer;
import io.skylite.core.geo.GeoShapeUtils;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import java.util.ArrayList;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.index.mapper.GeoPointFieldMapper;

public class VectorGeoPointShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsGeoPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), String.valueOf(relation) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsGeoPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "Expected geo_point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(this, context, fieldName, relation);
        return (Query)queryShape.visit((GeometryVisitor)shapeVisitor);
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(VectorGeoPointShapeQueryProcessor vectorGeoPointShapeQueryProcessor, QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.getFieldType(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        public Query visit(Circle circle) {
            Query query = LatLonPoint.newDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(Ellipse ellipse) {
            throw new IllegalArgumentException("query on ellipse types not yet supported");
        }

        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add((Query)shape.visit((GeometryVisitor)this), occur);
            }
        }

        public Query visit(Line line) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.LINESTRING) + " queries", new Object[0]);
        }

        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.fieldName + "] does not support " + String.valueOf(ShapeType.LINEARRING) + " queries", new Object[0]);
        }

        public Query visit(MultiLine multiLine) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.MULTILINESTRING) + " queries", new Object[0]);
        }

        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.MULTIPOINT) + " queries", new Object[0]);
        }

        private Query visit(ArrayList<Polygon> collector) {
            org.apache.lucene.geo.Polygon[] lucenePolygons = new org.apache.lucene.geo.Polygon[collector.size()];
            for (int i = 0; i < collector.size(); ++i) {
                lucenePolygons[i] = GeoShapeUtils.toLucenePolygon((Polygon)collector.get(i));
            }
            Query query = LatLonPoint.newPolygonQuery((String)this.fieldName, (org.apache.lucene.geo.Polygon[])lucenePolygons);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowPolygonQuery((String)this.fieldName, (org.apache.lucene.geo.Polygon[])lucenePolygons);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(MultiPolygon multiPolygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposeMultiPolygon((MultiPolygon)multiPolygon, (boolean)true, collector);
            return this.visit(collector);
        }

        public Query visit(Point point) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.POINT) + " queries", new Object[0]);
        }

        public Query visit(Polygon polygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposePolygon((Polygon)polygon, (boolean)true, collector);
            return this.visit(collector);
        }

        public Query visit(Rectangle r) {
            Query query = LatLonPoint.newBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
    }
}

