/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.LegacyESVersion;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.geo.GeoLineDecomposer;
import io.skylite.core.geo.GeoPolygonDecomposer;
import io.skylite.core.geo.GeoShapeUtils;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public class VectorGeoShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(LegacyESVersion.fromId((int)7050099))) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), String.valueOf(ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit((GeometryVisitor)visitor);
        List<LatLonGeometry> geometries = visitor.geometries();
        if (geometries.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return LatLonShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])geometries.toArray(new LatLonGeometry[0]));
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<LatLonGeometry> geometries = new ArrayList<LatLonGeometry>();
        private final String name;
        private final QueryShardContext context;

        private LuceneGeometryCollector(String name, QueryShardContext context) {
            this.name = name;
            this.context = context;
        }

        List<LatLonGeometry> geometries() {
            return this.geometries;
        }

        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneCircle((Circle)circle));
            }
            return null;
        }

        public Void visit(Ellipse ellipse) {
            throw new IllegalArgumentException("query on ellipse types not yet supported");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            if (!line.isEmpty()) {
                ArrayList<Line> collector = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine((Line)line, collector);
                this.collectLines(collector);
            }
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new QueryShardException(this.context.getFullyQualifiedIndex(), "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        public Void visit(MultiLine multiLine) {
            ArrayList<Line> collector = new ArrayList<Line>();
            GeoLineDecomposer.decomposeMultiLine((MultiLine)multiLine, collector);
            this.collectLines(collector);
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            if (!multiPolygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon((MultiPolygon)multiPolygon, (boolean)true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        public Void visit(Point point) {
            if (!point.isEmpty()) {
                double quantizedLat = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)point.getLat()));
                double quantizedLon = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)point.getLon()));
                this.geometries.add((LatLonGeometry)new org.apache.lucene.geo.Point(quantizedLat, quantizedLon));
            }
            return null;
        }

        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon((Polygon)polygon, (boolean)true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneRectangle((Rectangle)r));
            }
            return null;
        }

        private void collectLines(List<Line> geometryLines) {
            for (Line line : geometryLines) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneLine((Line)line));
            }
        }

        private void collectPolygons(List<Polygon> geometryPolygons) {
            for (Polygon polygon : geometryPolygons) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLucenePolygon((Polygon)polygon));
            }
        }
    }
}

