/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class WrapperQueryBuilder
extends AbstractQueryBuilder<WrapperQueryBuilder> {
    public static final String NAME = "wrapper";
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private final byte[] source;

    public WrapperQueryBuilder(byte[] source) {
        if (source == null || source.length == 0) {
            throw new IllegalArgumentException("query source text cannot be null or empty");
        }
        this.source = source;
    }

    public WrapperQueryBuilder(String source) {
        if (Strings.isEmpty((CharSequence)source)) {
            throw new IllegalArgumentException("query source string cannot be null or empty");
        }
        this.source = source.getBytes(StandardCharsets.UTF_8);
    }

    public WrapperQueryBuilder(BytesReference source) {
        if (source == null || source.length() == 0) {
            throw new IllegalArgumentException("query source text cannot be null or empty");
        }
        this.source = BytesRef.deepCopyOf((BytesRef)source.toBytesRef()).bytes;
    }

    public WrapperQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.source = in.readByteArray();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.source);
    }

    public byte[] source() {
        return this.source;
    }

    public String getName() {
        return NAME;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.source);
        builder.endObject();
    }

    public static WrapperQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[wrapper] query malformed", new Object[0]);
        }
        String fieldName = parser.currentName();
        if (!QUERY_FIELD.match(fieldName, parser.getDeprecationHandler())) {
            throw new ParsingException(parser.getTokenLocation(), "[wrapper] query malformed, expected `query` but was " + fieldName, new Object[0]);
        }
        parser.nextToken();
        byte[] source = parser.binaryValue();
        parser.nextToken();
        if (source == null) {
            throw new ParsingException(parser.getTokenLocation(), "wrapper query has no [query] specified", new Object[0]);
        }
        return new WrapperQueryBuilder(source);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("this query must be rewritten first");
    }

    protected int doHashCode() {
        return Arrays.hashCode(this.source);
    }

    protected boolean doEquals(WrapperQueryBuilder other) {
        return Arrays.equals(this.source, other.source);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext context) throws IOException {
        try (XContentParser qSourceParser = MediaTypeRegistry.xContent((byte[])this.source).xContent().createParser(context.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.source);){
            QueryBuilder queryBuilder = QueryBuilder.parseInnerQueryBuilder((XContentParser)qSourceParser).rewrite(context);
            if (this.boost() != 1.0f || this.queryName() != null) {
                BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                boolQueryBuilder.must(queryBuilder);
                BoolQueryBuilder boolQueryBuilder2 = boolQueryBuilder;
                return boolQueryBuilder2;
            }
            QueryBuilder queryBuilder2 = queryBuilder;
            return queryBuilder2;
        }
    }
}

