/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.script.Script;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.function.ScriptScoreQuery;
import org.opensearch.script.ScoreScript;

public class ScriptScoreQueryBuilder
extends AbstractQueryBuilder<ScriptScoreQueryBuilder> {
    public static final String NAME = "script_score";
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    private static final ConstructingObjectParser<ScriptScoreQueryBuilder, Void> PARSER = new ConstructingObjectParser("script_score", false, args -> {
        ScriptScoreQueryBuilder ssQueryBuilder = new ScriptScoreQueryBuilder((QueryBuilder)args[0], (Script)args[1]);
        if (args[2] != null) {
            ssQueryBuilder.setMinScore(((Float)args[2]).floatValue());
        }
        if (args[3] != null) {
            ssQueryBuilder.boost(((Float)args[3]).floatValue());
        }
        if (args[4] != null) {
            ssQueryBuilder.queryName((String)args[4]);
        }
        return ssQueryBuilder;
    });
    private final QueryBuilder query;
    private Float minScore = null;
    private final Script script;

    public static ScriptScoreQueryBuilder fromXContent(XContentParser parser) {
        return (ScriptScoreQueryBuilder)((Object)PARSER.apply(parser, null));
    }

    public ScriptScoreQueryBuilder(QueryBuilder query, Script script) {
        if (query == null) {
            throw new IllegalArgumentException("script_score: query must not be null");
        }
        if (script == null) {
            throw new IllegalArgumentException("script_score: script must not be null");
        }
        this.query = query;
        this.script = script;
    }

    public ScriptScoreQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.script = new Script(in);
        this.minScore = in.readOptionalFloat();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.query);
        this.script.writeTo(out);
        out.writeOptionalFloat(this.minScore);
    }

    public QueryBuilder query() {
        return this.query;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public ScriptScoreQueryBuilder setMinScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean doEquals(ScriptScoreQueryBuilder other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.script, other.script) && Objects.equals(this.minScore, other.minScore);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.script, this.minScore);
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (!context.allowExpensiveQueries()) {
            throw new SkyliteException("[script score] queries cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        ScoreScript.Factory factory = (ScoreScript.Factory)context.compile(this.script, ScoreScript.CONTEXT);
        ScoreScript.LeafFactory scoreScriptFactory = factory.newFactory(this.script.getParams(), context.lookup(), context.searcher());
        QueryBuilder queryBuilder = this.query;
        Query query = queryBuilder.toQuery((QueryRewriteContext)context);
        return new ScriptScoreQuery(query, queryBuilder.queryName(), this.script, scoreScriptFactory, this.minScore, context.index().getName(), context.getShardId(), context.indexVersionCreated());
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder newQuery = this.query.rewrite(queryRewriteContext);
        if (newQuery instanceof MatchNoneQueryBuilder) {
            return newQuery;
        }
        if (newQuery != this.query) {
            ScriptScoreQueryBuilder newQueryBuilder = new ScriptScoreQueryBuilder(newQuery, this.script);
            if (this.minScore != null) {
                newQueryBuilder.setMinScore(this.minScore.floatValue());
            }
            return newQueryBuilder;
        }
        return this;
    }

    public void extractInnerHitBuilders(AbstractQueryBuilder.InnerHitCollector<?> collector, AbstractQueryBuilder.InnerHitExtractor extractor) {
        extractor.extract(this.query(), collector);
    }

    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept((QueryBuilder)this);
        if (this.query != null) {
            QueryBuilderVisitor subVisitor = visitor.getChildVisitor(BooleanClause.Occur.MUST);
            subVisitor.accept(this.query);
        }
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryBuilder.parseInnerQueryBuilder((XContentParser)p), QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse((XContentParser)p), SCRIPT_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), MIN_SCORE_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), AbstractQueryBuilder.BOOST_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ParseField.CommonMetaFields.NAME_FIELD);
    }
}

