/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import io.skylite.core.lucene.BytesRefs;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.valuesource.SumTotalTermFreqValueSource;
import org.apache.lucene.queries.function.valuesource.TermFreqValueSource;
import org.apache.lucene.queries.function.valuesource.TotalTermFreqValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.query.functionscore.TermFrequencyFunction;

public class TermFrequencyFunctionFactory {
    public static TermFrequencyFunction createFunction(TermFrequencyFunctionName functionName, String field, String term, LeafReaderContext readerContext, IndexSearcher indexSearcher) throws IOException {
        switch (functionName.ordinal()) {
            case 0: {
                TermFreqValueSource termFreqValueSource = new TermFreqValueSource(field, term, field, BytesRefs.toBytesRef((Object)term));
                FunctionValues functionValues = termFreqValueSource.getValues(null, readerContext);
                return docId -> functionValues.intVal(docId);
            }
            case 1: {
                TotalTermFreqValueSource totalTermFreqValueSource = new TotalTermFreqValueSource(field, term, field, BytesRefs.toBytesRef((Object)term));
                HashMap ttfContext = new HashMap();
                totalTermFreqValueSource.createWeight(ttfContext, indexSearcher);
                FunctionValues functionValues = totalTermFreqValueSource.getValues(ttfContext, readerContext);
                return docId -> functionValues.longVal(docId);
            }
            case 2: {
                SumTotalTermFreqValueSource sumTotalTermFreqValueSource = new SumTotalTermFreqValueSource(field);
                HashMap sttfContext = new HashMap();
                sumTotalTermFreqValueSource.createWeight(sttfContext, indexSearcher);
                FunctionValues functionValues = sumTotalTermFreqValueSource.getValues(sttfContext, readerContext);
                return docId -> functionValues.longVal(docId);
            }
        }
        throw new IllegalArgumentException("Unsupported function: " + String.valueOf((Object)functionName));
    }

    public static enum TermFrequencyFunctionName {
        TERM_FREQ("termFreq"),
        TOTAL_TERM_FREQ("totalTermFreq"),
        SUM_TOTAL_TERM_FREQ("sumTotalTermFreq");

        private final String termFrequencyFunctionName;

        private TermFrequencyFunctionName(String termFrequencyFunctionName) {
            this.termFrequencyFunctionName = termFrequencyFunctionName;
        }

        public String getTermFrequencyFunctionName() {
            return this.termFrequencyFunctionName;
        }
    }
}

