/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import org.opensearch.index.reindex.AbstractBulkByScrollRequest;

public class DeleteByQueryRequest
extends AbstractBulkByScrollRequest<DeleteByQueryRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    public DeleteByQueryRequest() {
        this(new SearchRequest());
    }

    public DeleteByQueryRequest(String ... indices) {
        this(new SearchRequest(indices));
    }

    DeleteByQueryRequest(SearchRequest search) {
        this(search, true);
    }

    public DeleteByQueryRequest(StreamInput in) throws IOException {
        super(in);
    }

    private DeleteByQueryRequest(SearchRequest search, boolean setDefaults) {
        super(search, setDefaults);
        if (setDefaults) {
            search.source().fetchSource(false);
        }
    }

    public DeleteByQueryRequest setQuery(QueryBuilder query) {
        if (query != null) {
            this.getSearchRequest().source().query(query);
        }
        return this;
    }

    public DeleteByQueryRequest setRouting(String routing) {
        if (routing != null) {
            this.getSearchRequest().routing(routing);
        }
        return this;
    }

    public DeleteByQueryRequest setBatchSize(int size) {
        this.getSearchRequest().source().size(size);
        return this;
    }

    public DeleteByQueryRequest setIndicesOptions(IndicesOptions indicesOptions) {
        this.getSearchRequest().indicesOptions(indicesOptions);
        return this;
    }

    public int getBatchSize() {
        return this.getSearchRequest().source().size();
    }

    public String getRouting() {
        return this.getSearchRequest().routing();
    }

    @Override
    protected DeleteByQueryRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError((String)"use _all if you really want to delete from all existing indexes", (ActionRequestValidationException)e);
        }
        if (this.getSearchRequest() == null || this.getSearchRequest().source() == null) {
            e = ValidateActions.addValidationError((String)"source is missing", (ActionRequestValidationException)e);
        } else if (this.getSearchRequest().source().query() == null) {
            e = ValidateActions.addValidationError((String)"query is missing", (ActionRequestValidationException)e);
        }
        return e;
    }

    @Override
    public DeleteByQueryRequest forSlice(TaskId slicingTask, SearchRequest slice, int totalSlices) {
        return this.doForSlice(new DeleteByQueryRequest(slice, false), slicingTask, totalSlices);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("delete-by-query ");
        this.searchToString(b);
        return b.toString();
    }

    public IndicesRequest indices(String ... indices) {
        assert (this.getSearchRequest() != null);
        this.getSearchRequest().indices(indices);
        return this;
    }

    public String[] indices() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indices();
    }

    public IndicesOptions indicesOptions() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indicesOptions();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.getSearchRequest().source().innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }
}

