/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.LatchedActionListener;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.gateway.remote.IndexMetadataUploadListener;
import io.skylite.core.index.Index;
import io.skylite.core.index.remote.RemoteIndexPath;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStoreUtils;
import io.skylite.core.node.NodeSettings;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.repositories.blobstore.ConfigBlobStoreFormat;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.gateway.remote.RemoteClusterStateService;

public class RemoteIndexPathUploader
extends IndexMetadataUploadListener {
    public static final String DELIMITER = "#";
    public static final ConfigBlobStoreFormat<RemoteIndexPath> REMOTE_INDEX_PATH_FORMAT = new ConfigBlobStoreFormat("remote_path_%s");
    private static final String TIMEOUT_EXCEPTION_MSG = "Timed out waiting while uploading remote index path file for indexes=%s";
    private static final String UPLOAD_EXCEPTION_MSG = "Exception occurred while uploading remote index paths for indexes=%s";
    static final String TRANSLOG_REPO_NAME_KEY = NodeSettings.NODE_ATTRIBUTES.getKey() + "remote_store.translog.repository";
    static final String SEGMENT_REPO_NAME_KEY = NodeSettings.NODE_ATTRIBUTES.getKey() + "remote_store.segment.repository";
    private static final Logger logger = LogManager.getLogger(RemoteIndexPathUploader.class);
    private final Settings settings;
    private final boolean isRemoteDataAttributePresent;
    private final boolean isTranslogSegmentRepoSame;
    private final Supplier<RepositoriesService> repositoriesService;
    private volatile TimeValue indexMetadataUploadTimeout;
    private BlobStoreRepository translogRepository;
    private BlobStoreRepository segmentRepository;

    public RemoteIndexPathUploader(ThreadPool threadPool, Settings settings, Supplier<RepositoriesService> repositoriesService, ClusterSettings clusterSettings) {
        super(threadPool, "generic");
        this.settings = Objects.requireNonNull(settings);
        this.repositoriesService = Objects.requireNonNull(repositoriesService);
        this.isRemoteDataAttributePresent = RemoteStoreNodeAttribute.isRemoteDataAttributePresent((Settings)settings);
        this.isTranslogSegmentRepoSame = this.isTranslogSegmentRepoSame();
        Objects.requireNonNull(clusterSettings);
        this.indexMetadataUploadTimeout = (TimeValue)clusterSettings.get(RemoteClusterStateService.INDEX_METADATA_UPLOAD_TIMEOUT_SETTING);
        clusterSettings.addSettingsUpdateConsumer(RemoteClusterStateService.INDEX_METADATA_UPLOAD_TIMEOUT_SETTING, this::setIndexMetadataUploadTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOnUpload(List<IndexMetadata> indexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, ActionListener<Void> actionListener) {
        RemoteClusterStateService.RemoteStateTransferException ex;
        if (!this.isRemoteDataAttributePresent) {
            logger.trace("Skipping beforeNewIndexUpload as there are no remote indexes");
            actionListener.onResponse(null);
            return;
        }
        long startTime = System.nanoTime();
        boolean success = false;
        List eligibleList = indexMetadataList.stream().filter(idxMd -> this.requiresPathUpload((IndexMetadata)idxMd, (IndexMetadata)prevIndexMetadataByName.get(idxMd.getIndex().getName()))).collect(Collectors.toList());
        String indexNames = eligibleList.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(","));
        int latchCount = eligibleList.size() * (this.isTranslogSegmentRepoSame ? 1 : 2);
        CountDownLatch latch = new CountDownLatch(latchCount);
        List<Exception> exceptionList = Collections.synchronizedList(new ArrayList(latchCount));
        try {
            RemoteClusterStateService.RemoteStateTransferException ex2;
            for (IndexMetadata indexMetadata : eligibleList) {
                this.writeIndexPathAsync(indexMetadata, latch, exceptionList);
            }
            logger.trace((Message)new ParameterizedMessage("Remote index path upload started for {}", (Object)indexNames));
            try {
                if (!latch.await(this.indexMetadataUploadTimeout.millis(), TimeUnit.MILLISECONDS)) {
                    ex2 = new RemoteClusterStateService.RemoteStateTransferException(String.format(Locale.ROOT, TIMEOUT_EXCEPTION_MSG, indexNames));
                    exceptionList.forEach(ex2::addSuppressed);
                    actionListener.onFailure((Exception)ex2);
                    return;
                }
            }
            catch (InterruptedException exception) {
                exceptionList.forEach(exception::addSuppressed);
                ex = new RemoteClusterStateService.RemoteStateTransferException(String.format(Locale.ROOT, TIMEOUT_EXCEPTION_MSG, indexNames), exception);
                actionListener.onFailure((Exception)ex);
                return;
            }
            if (exceptionList.size() > 0) {
                ex2 = new RemoteClusterStateService.RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, indexNames));
                exceptionList.forEach(ex2::addSuppressed);
                actionListener.onFailure((Exception)ex2);
                return;
            }
            success = true;
            actionListener.onResponse(null);
        }
        catch (Exception exception) {
            ex = new RemoteClusterStateService.RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, indexNames), exception);
            exceptionList.forEach(ex::addSuppressed);
            actionListener.onFailure((Exception)ex);
        }
        finally {
            long tookTimeNs = System.nanoTime() - startTime;
            logger.trace((Message)new ParameterizedMessage("executed beforeNewIndexUpload status={} tookTimeNs={}", (Object)success, (Object)tookTimeNs));
        }
    }

    private void writeIndexPathAsync(IndexMetadata idxMD, CountDownLatch latch, List<Exception> exceptionList) {
        if (this.isTranslogSegmentRepoSame) {
            this.writePathToRemoteStore(idxMD, this.translogRepository, latch, exceptionList, RemoteIndexPath.COMBINED_PATH);
        } else {
            this.writePathToRemoteStore(idxMD, this.translogRepository, latch, exceptionList, RemoteIndexPath.TRANSLOG_PATH);
            this.writePathToRemoteStore(idxMD, this.segmentRepository, latch, exceptionList, RemoteIndexPath.SEGMENT_PATH);
        }
    }

    private void writePathToRemoteStore(IndexMetadata idxMD, BlobStoreRepository repository, CountDownLatch latch, List<Exception> exceptionList, Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap) {
        Map remoteCustomData = idxMD.getCustomData("remote_store");
        RemoteStoreEnums.PathType pathType = RemoteStoreEnums.PathType.valueOf((String)((String)remoteCustomData.get("path_type")));
        RemoteStoreEnums.PathHashAlgorithm hashAlgorithm = RemoteStoreEnums.PathHashAlgorithm.valueOf((String)((String)remoteCustomData.get("path_hash_algorithm")));
        String indexUUID = idxMD.getIndexUUID();
        int shardCount = idxMD.getNumberOfShards();
        BlobPath basePath = repository.basePath();
        BlobContainer blobContainer = repository.blobStore().blobContainer(basePath.add("remote-index-path"));
        LatchedActionListener<Void> actionListener = this.getUploadPathLatchedActionListener(idxMD, latch, exceptionList, pathCreationMap);
        try {
            RemoteIndexPath remoteIndexPath = new RemoteIndexPath(indexUUID, shardCount, (Iterable)basePath, pathType, hashAlgorithm, pathCreationMap);
            String fileName = this.generateFileName(indexUUID, idxMD.getVersion(), remoteIndexPath.getVersion());
            REMOTE_INDEX_PATH_FORMAT.writeAsyncWithUrgentPriority((ToXContent)remoteIndexPath, blobContainer, fileName, actionListener);
        }
        catch (IOException ioException) {
            RemoteClusterStateService.RemoteStateTransferException ex = new RemoteClusterStateService.RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, List.of(idxMD.getIndex().getName())), ioException);
            actionListener.onFailure((Exception)ex);
        }
    }

    private Repository validateAndGetRepository(String repoSetting) {
        String repo = this.settings.get(repoSetting);
        assert (repo != null) : "Remote " + repoSetting + " repository is not configured";
        Repository repository = this.repositoriesService.get().repository(repo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        return repository;
    }

    public void start() {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled((Settings)this.settings)) : "Remote cluster state is not enabled";
        if (!this.isRemoteDataAttributePresent) {
            return;
        }
        this.translogRepository = (BlobStoreRepository)this.validateAndGetRepository(TRANSLOG_REPO_NAME_KEY);
        this.segmentRepository = (BlobStoreRepository)this.validateAndGetRepository(SEGMENT_REPO_NAME_KEY);
    }

    private boolean isTranslogSegmentRepoSame() {
        String translogRepoName = this.settings.get(TRANSLOG_REPO_NAME_KEY);
        String segmentRepoName = this.settings.get(SEGMENT_REPO_NAME_KEY);
        return Objects.equals(translogRepoName, segmentRepoName);
    }

    private LatchedActionListener<Void> getUploadPathLatchedActionListener(IndexMetadata indexMetadata, CountDownLatch latch, List<Exception> exceptionList, Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap) {
        return new LatchedActionListener(ActionListenerHelper.wrap(resp -> logger.trace((Message)new ParameterizedMessage("Index path uploaded for {} indexMetadata={}", (Object)pathCreationMap, (Object)indexMetadata)), ex -> {
            logger.error((Message)new ParameterizedMessage("Exception during Index path upload for {} indexMetadata={}", (Object)pathCreationMap, (Object)indexMetadata), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
    }

    private boolean requiresPathUpload(IndexMetadata indexMetadata, IndexMetadata prevIndexMetadata) {
        RemoteStoreEnums.PathType pathType = RemoteStoreUtils.determineRemoteStorePathStrategy((IndexMetadata)indexMetadata).getType();
        RemoteStoreEnums.PathType prevPathType = Objects.nonNull(prevIndexMetadata) ? RemoteStoreUtils.determineRemoteStorePathStrategy((IndexMetadata)prevIndexMetadata).getType() : null;
        return pathType == RemoteStoreEnums.PathType.HASHED_PREFIX && (Objects.isNull(prevPathType) || prevPathType != RemoteStoreEnums.PathType.HASHED_PREFIX);
    }

    private void setIndexMetadataUploadTimeout(TimeValue newIndexMetadataUploadTimeout) {
        this.indexMetadataUploadTimeout = newIndexMetadataUploadTimeout;
    }

    private String generateFileName(String indexUUID, long indexMetadataVersion, String fileVersion) {
        return String.join((CharSequence)DELIMITER, indexUUID, Long.toString(indexMetadataVersion), fileVersion, UUIDs.randomBase64UUID());
    }
}

