/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search;

import io.skylite.core.index.query.LuceniaToParentBlockJoinQuery;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;

public final class NestedHelper {
    private final Function<String, ObjectMapper> objectMapperLookup;
    private final Function<String, Boolean> isMappedFieldFunction;

    public NestedHelper(Function<String, ObjectMapper> objectMapperLookup, Function<String, Boolean> isMappedFieldFunction) {
        this.objectMapperLookup = objectMapperLookup;
        this.isMappedFieldFunction = isMappedFieldFunction;
    }

    public boolean mightMatchNestedDocs(Query query) {
        if (query instanceof ConstantScoreQuery) {
            return this.mightMatchNestedDocs(((ConstantScoreQuery)query).getQuery());
        }
        if (query instanceof BoostQuery) {
            return this.mightMatchNestedDocs(((BoostQuery)query).getQuery());
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return this.mightMatchNestedDocs(((TermQuery)query).getTerm().field());
        }
        if (query instanceof TermInSetQuery) {
            TermInSetQuery tis = (TermInSetQuery)query;
            if (tis.getTermsCount() > 0L) {
                return this.mightMatchNestedDocs(tis.getField());
            }
            return false;
        }
        if (query instanceof PointRangeQuery) {
            return this.mightMatchNestedDocs(((PointRangeQuery)query).getField());
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return this.mightMatchNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery());
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(this::mightMatchNestedDocs);
            }
            return bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(this::mightMatchNestedDocs);
        }
        if (query instanceof LuceniaToParentBlockJoinQuery) {
            return ((LuceniaToParentBlockJoinQuery)query).getPath() != null;
        }
        return true;
    }

    boolean mightMatchNestedDocs(String field) {
        if (field.startsWith("_")) {
            return true;
        }
        if (!this.isMappedFieldFunction.apply(field).booleanValue()) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.objectMapperLookup.apply(parent);
            if (mapper != null && mapper.isNested()) {
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return false;
    }

    public boolean mightMatchNonNestedDocs(Query query, String nestedPath) {
        if (query instanceof ConstantScoreQuery) {
            return this.mightMatchNonNestedDocs(((ConstantScoreQuery)query).getQuery(), nestedPath);
        }
        if (query instanceof BoostQuery) {
            return this.mightMatchNonNestedDocs(((BoostQuery)query).getQuery(), nestedPath);
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return this.mightMatchNonNestedDocs(((TermQuery)query).getTerm().field(), nestedPath);
        }
        if (query instanceof TermInSetQuery) {
            TermInSetQuery tis = (TermInSetQuery)query;
            if (tis.getTermsCount() > 0L) {
                return this.mightMatchNonNestedDocs(tis.getField(), nestedPath);
            }
            return false;
        }
        if (query instanceof PointRangeQuery) {
            return this.mightMatchNonNestedDocs(((PointRangeQuery)query).getField(), nestedPath);
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return this.mightMatchNonNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery(), nestedPath);
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
            }
            return bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
        }
        return true;
    }

    boolean mightMatchNonNestedDocs(String field, String nestedPath) {
        if (field.startsWith("_")) {
            return true;
        }
        if (!this.isMappedFieldFunction.apply(field).booleanValue()) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.objectMapperLookup.apply(parent);
            if (mapper != null && mapper.isNested()) {
                NestedObjectMapper nestedMapper = (NestedObjectMapper)mapper;
                if (mapper.fullPath().equals(nestedPath)) {
                    return nestedMapper.isIncludeInParent() || nestedMapper.isIncludeInRoot();
                }
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return true;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

