/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.seqno;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.lease.Releasable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.index.IndexService;
import org.opensearch.indices.IndicesService;

public class RetentionLeaseActions {
    public static final long RETAIN_ALL = -1L;

    public static class Response
    extends ActionResponse {
        public Response() {
        }

        Response(StreamInput in) throws IOException {
            super(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class RemoveRequest
    extends Request<RemoveRequest> {
        RemoveRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RemoveRequest(ShardId shardId, String id) {
            super(shardId, id);
        }
    }

    public static class RenewRequest
    extends AddOrRenewRequest<RenewRequest> {
        RenewRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    public static class AddRequest
    extends AddOrRenewRequest<AddRequest> {
        AddRequest(StreamInput in) throws IOException {
            super(in);
        }

        public AddRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    private static abstract class AddOrRenewRequest<T extends SingleShardRequest<T>>
    extends Request<T> {
        private final long retainingSequenceNumber;
        private final String source;

        public long getRetainingSequenceNumber() {
            return this.retainingSequenceNumber;
        }

        public String getSource() {
            return this.source;
        }

        AddOrRenewRequest(StreamInput in) throws IOException {
            super(in);
            this.retainingSequenceNumber = in.readZLong();
            this.source = in.readString();
        }

        AddOrRenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id);
            if (retainingSequenceNumber < 0L && retainingSequenceNumber != -1L) {
                throw new IllegalArgumentException("retaining sequence number [" + retainingSequenceNumber + "] out of range");
            }
            this.retainingSequenceNumber = retainingSequenceNumber;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.retainingSequenceNumber);
            out.writeString(this.source);
        }
    }

    private static abstract class Request<T extends SingleShardRequest<T>>
    extends SingleShardRequest<T> {
        private final ShardId shardId;
        private final String id;

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getId() {
            return this.id;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.id = in.readString();
        }

        Request(ShardId shardId, String id) {
            super(Objects.requireNonNull(shardId).getIndexName());
            this.shardId = shardId;
            this.id = Objects.requireNonNull(id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.id);
        }
    }

    public static class Remove
    extends ActionType<Response> {
        public static final Remove INSTANCE = new Remove();
        public static final String ACTION_NAME = "indices:admin/seq_no/remove_retention_lease";

        private Remove() {
            super(ACTION_NAME, Response::new);
        }

        public static final class ActionProviderImpl
        implements ActionProvider {
            public ActionType<? extends ActionResponse> getInstance() {
                return INSTANCE;
            }

            public Class<? extends io.skylite.core.action.support.TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
                return TransportAction.class;
            }
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RemoveRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Remove.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RemoveRequest::new);
            }

            @Override
            void doRetentionLeaseAction(BaseIndexShard indexShard, RemoveRequest request, ActionListener<Response> listener) {
                indexShard.removeRetentionLease(request.getId(), ActionListenerHelper.map(listener, r -> new Response()));
            }
        }
    }

    public static class Renew
    extends ActionType<Response> {
        public static final Renew INSTANCE = new Renew();
        public static final String ACTION_NAME = "indices:admin/seq_no/renew_retention_lease";

        private Renew() {
            super(ACTION_NAME, Response::new);
        }

        public static final class ActionProviderImpl
        implements ActionProvider {
            public ActionType<? extends ActionResponse> getInstance() {
                return INSTANCE;
            }

            public Class<? extends io.skylite.core.action.support.TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
                return TransportAction.class;
            }
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Renew.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(BaseIndexShard indexShard, RenewRequest request, ActionListener<Response> listener) {
                indexShard.renewRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource());
                listener.onResponse((Object)new Response());
            }
        }
    }

    public static class Add
    extends ActionType<Response> {
        public static final Add INSTANCE = new Add();
        public static final String ACTION_NAME = "indices:admin/seq_no/add_retention_lease";

        private Add() {
            super(ACTION_NAME, Response::new);
        }

        public static final class ActionProviderImpl
        implements ActionProvider {
            public ActionType<? extends ActionResponse> getInstance() {
                return INSTANCE;
            }

            public Class<? extends io.skylite.core.action.support.TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
                return TransportAction.class;
            }
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Add.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, AddRequest::new);
            }

            @Override
            void doRetentionLeaseAction(BaseIndexShard indexShard, AddRequest request, ActionListener<Response> listener) {
                indexShard.addRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource(), ActionListenerHelper.map(listener, r -> new Response()));
            }

            @Override
            protected Writeable.Reader<Response> getResponseReader() {
                return Response::new;
            }
        }
    }

    static abstract class TransportRetentionLeaseAction<T extends Request<T>>
    extends TransportSingleShardAction<T, Response> {
        private final IndicesService indicesService;

        @Inject
        TransportRetentionLeaseAction(String name, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, Writeable.Reader<T> requestSupplier) {
            super(name, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, requestSupplier, "management");
            this.indicesService = Objects.requireNonNull(indicesService);
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShardId().id()).primaryShardIt();
        }

        protected void asyncShardOperation(T request, ShardId shardId, ActionListener<Response> listener) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            BaseIndexShard indexShard = indexService.getShard(shardId.id());
            indexShard.acquirePrimaryOperationPermit(ActionListenerHelper.delegateFailure(listener, (delegatedListener, releasable) -> {
                try (Releasable ignore = releasable;){
                    this.doRetentionLeaseAction(indexShard, request, (ActionListener<Response>)delegatedListener);
                }
            }), "same", request);
        }

        protected Response shardOperation(T request, ShardId shardId) {
            throw new UnsupportedOperationException();
        }

        abstract void doRetentionLeaseAction(BaseIndexShard var1, T var2, ActionListener<Response> var3);

        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        protected boolean resolveIndex(T request) {
            return false;
        }
    }
}

