/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Assertions;
import io.skylite.common.Booleans;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedFunction;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.Nullable;
import io.skylite.common.SetOnce;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.collect.Tuple;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.RunOnce;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.flush.FlushRequest;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeRequest;
import io.skylite.core.action.admin.indices.refresh.RefreshStats;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeRequest;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.PendingReplicationActions;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.AsyncIOProcessor;
import io.skylite.core.common.concurrent.BufferedAsyncIOProcessor;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.ReplicationStats;
import io.skylite.core.index.SegmentReplicationShardStats;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.cache.IndexCache;
import io.skylite.core.index.cache.request.ShardRequestCache;
import io.skylite.core.index.codec.CodecService;
import io.skylite.core.index.engine.BaseEngine;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.NRTReplicationEngine;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.fielddata.FieldDataStats;
import io.skylite.core.index.flush.FlushStats;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.recovery.RecoveryStats;
import io.skylite.core.index.remote.RemoteSegmentStats;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.seqno.ReplicationTracker;
import io.skylite.core.index.seqno.RetentionLease;
import io.skylite.core.index.seqno.RetentionLeaseStats;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.seqno.SequenceNumbers;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.BaseStoreRecovery;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.shard.IllegalIndexShardStateException;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.IndexShardNotRecoveringException;
import io.skylite.core.index.shard.IndexShardNotStartedException;
import io.skylite.core.index.shard.IndexShardRecoveringException;
import io.skylite.core.index.shard.IndexShardRecoveryException;
import io.skylite.core.index.shard.IndexShardRelocatedException;
import io.skylite.core.index.shard.IndexShardStartedException;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.shard.LocalShardSnapshot;
import io.skylite.core.index.shard.PrimaryReplicaSyncer;
import io.skylite.core.index.shard.ReplicationGroup;
import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotInPrimaryModeException;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.shard.ShardStateMetadata;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.store.remote.metadata.RemoteSegmentMetadata;
import io.skylite.core.index.translog.RemoteTranslogStats;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogFactory;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogRecoveryRunner;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.index.translog.TranslogStats;
import io.skylite.core.index.warmer.ShardIndexWarmerService;
import io.skylite.core.index.warmer.WarmerStats;
import io.skylite.core.indices.IndicesMemorySettings;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.recovery.BasePeerRecoveryTargetService;
import io.skylite.core.indices.recovery.RecoveryListener;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.indices.replication.common.ReplicationFailedException;
import io.skylite.core.indices.replication.common.ReplicationState;
import io.skylite.core.lucene.XLucene;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.MappedParsedDocument;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.ParsedDocument;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.mapper.Uid;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.suggest.completion.CompletionStats;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Version;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.ReadOnlyEngine;
import org.opensearch.index.get.ShardGetService;
import org.opensearch.index.shard.CheckpointRefreshListener;
import org.opensearch.index.shard.IndexShardOperationPermits;
import org.opensearch.index.shard.InternalIndexingStats;
import org.opensearch.index.shard.ReleasableRetryableRefreshListener;
import org.opensearch.index.shard.RemoteStoreRefreshListener;
import org.opensearch.index.shard.StoreRecovery;
import org.opensearch.index.store.RemoteStoreFileDownloader;
import org.opensearch.index.translog.RemoteBlobStoreInternalTranslogFactory;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public class IndexShard
extends BaseIndexShard {
    private final IndexCache indexCache;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final BaseEngine.Warmer warmer;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final QueryCachingPolicy cachingPolicy;
    final CircuitBreakerService circuitBreakerService;
    private final SegmentReplicationCheckpointPublisher checkpointPublisher;
    private final Object engineMutex = new Object();
    final EngineFactory engineFactory;
    final EngineConfigFactory engineConfigFactory;
    private final IndexingOperationListener indexingOperationListeners;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final CounterMetric periodicFlushMetric = new CounterMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final IndexShardOperationPermits indexShardOperationPermits;
    private static final EnumSet<IndexShardState> writeAllowedStates = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RefreshPendingLocationListener refreshPendingLocationListener;
    private volatile boolean useRetentionLeasesInPeerRecovery;
    private final BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier;
    private final boolean isTimeSeriesIndex;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;
    private final List<ReferenceManager.RefreshListener> internalRefreshListener = new ArrayList<ReferenceManager.RefreshListener>();
    private final RemoteStoreFileDownloader fileDownloader;
    private final AtomicBoolean primaryReplicaResyncInProgress = new AtomicBoolean();
    private final AsyncIOProcessor<TranslogLocation> translogSyncProcessor;
    private final AtomicBoolean flushOrRollRunning = new AtomicBoolean();

    Runnable getGlobalCheckpointSyncer() {
        return this.globalCheckpointSyncer;
    }

    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, IndexEventListener indexEventListener, CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, ThreadPool threadPool, BigArrays bigArrays, BaseEngine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, CircuitBreakerService circuitBreakerService, BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier, @Nullable SegmentReplicationCheckpointPublisher checkpointPublisher, @Nullable Store remoteStore, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, String nodeId, RecoverySettings recoverySettings, RemoteStoreSettings remoteStoreSettings, boolean seedRemote, DiscoveryNodes discoveryNodes) throws IOException {
        super(shardRouting, indexSettings, path, store, indexSortSupplier, mapperService, indexEventListener, threadPool, searchOperationListener, globalCheckpointSyncer, retentionLeaseSyncer, remoteStore, remoteStoreSettings, recoverySettings, seedRemote, discoveryNodes);
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, indexSettings, this.logger);
        this.warmer = warmer;
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.engineConfigFactory = Objects.requireNonNull(engineConfigFactory);
        this.translogSyncProcessor = IndexShard.createTranslogSyncProcessor(this.logger, threadPool, () -> ((IndexShard)this).getEngine(), indexSettings.isAssignedOnRemoteNode(), () -> this.getRemoteTranslogUploadBufferInterval(() -> ((RemoteStoreSettings)remoteStoreSettings).getClusterRemoteTranslogBufferInterval()));
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats();
        ArrayList<IndexingOperationListener> listenersList = new ArrayList<IndexingOperationListener>(listeners);
        listenersList.add(this.internalIndexingStats);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(listenersList, this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.circuitBreakerService = circuitBreakerService;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = (String)indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays, nodeId, seedRemote);
        this.cachingPolicy = (Boolean)IndexModuleSettings.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings) != false ? new QueryCachingPolicy(this){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return true;
            }
        } : new UsageTrackingQueryCachingPolicy();
        this.indexShardOperationPermits = new IndexShardOperationPermits(this.shardId, threadPool);
        this.readerWrapper = indexReaderWrapper;
        this.lastSearcherAccess.set(threadPool.relativeTimeInMillis());
        IndexShard.persistMetadata(path, indexSettings, shardRouting, null, this.logger);
        this.useRetentionLeasesInPeerRecovery = this.replicationTracker.hasAllPeerRecoveryRetentionLeases();
        this.refreshPendingLocationListener = new RefreshPendingLocationListener();
        this.checkpointPublisher = checkpointPublisher;
        this.translogFactorySupplier = translogFactorySupplier;
        this.isTimeSeriesIndex = mapperService == null || mapperService.documentMapper() == null ? false : mapperService.documentMapper().mappers().containsTimeStampField();
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
        this.fileDownloader = new RemoteStoreFileDownloader(shardRouting.shardId(), threadPool, recoverySettings);
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public String getDefaultCodecName() {
        return this.codecService.codec("default").getName();
    }

    public long getOperationPrimaryTerm() {
        return this.replicationTracker.getOperationPrimaryTerm();
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.cachingPolicy;
    }

    protected RemoteStoreStatsTrackerFactory getRemoteStoreStatsTrackerFactory() {
        return this.remoteStoreStatsTrackerFactory;
    }

    public String getNodeId() {
        return this.translogConfig.getNodeId();
    }

    public RemoteStoreFileDownloader getFileDownloader() {
        return this.fileDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShardState(ShardRouting newRouting, long newPrimaryTerm, BiConsumer<BaseIndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable, DiscoveryNodes discoveryNodes) throws IOException {
        ShardRouting currentRouting;
        this.discoveryNodes = discoveryNodes;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            assert (currentRouting != null);
            if (!newRouting.shardId().equals((Object)this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + String.valueOf(newRouting.shardId()) + " on a shard with shardId " + String.valueOf(this.shardId()));
            }
            if (!newRouting.isSameAllocation(currentRouting)) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (newRouting.primary()) {
                this.replicationTracker.updateFromClusterManager(applyingClusterStateVersion, inSyncAllocationIds, routingTable);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + String.valueOf(currentRouting);
                assert (!currentRouting.isRelocationTarget() || !currentRouting.primary() || this.replicationTracker.isPrimaryMode()) : "a primary relocation is completed by the cluster-managerr, but primary mode is not active " + String.valueOf(currentRouting);
                this.changeState(IndexShardState.STARTED, "global state is [" + String.valueOf(newRouting.state()) + "]");
                if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                    this.flush(new FlushRequest(new String[0]).waitIfOngoing(true).force(true));
                }
            } else if (currentRouting.primary() && currentRouting.relocating() && this.replicationTracker.isRelocated() && (!newRouting.relocating() || !newRouting.equalsIgnoringMetadata(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + String.valueOf(newRouting.state()));
            }
            assert (!newRouting.active() || this.state == IndexShardState.STARTED || this.state == IndexShardState.CLOSED) : "routing is active, but local shard state isn't. routing: " + String.valueOf(newRouting) + ", local state: " + String.valueOf(this.state);
            IndexShard.persistMetadata(this.path, this.indexSettings, newRouting, currentRouting, this.logger);
            CountDownLatch shardStateUpdated = new CountDownLatch(1);
            if (newRouting.primary()) {
                if (newPrimaryTerm == this.pendingPrimaryTerm) {
                    if (currentRouting.initializing() && !currentRouting.isRelocationTarget() && newRouting.active()) {
                        this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                        this.postActivatePrimaryMode();
                    }
                } else {
                    assert (!currentRouting.primary()) : "term is only increased as part of primary promotion";
                    assert (!newRouting.initializing()) : "a started primary shard should never update its term; shard " + String.valueOf(newRouting) + ", current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    assert (newPrimaryTerm > this.pendingPrimaryTerm) : "primary terms can only go up; current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    boolean resyncStarted = this.primaryReplicaResyncInProgress.compareAndSet(false, true);
                    if (!resyncStarted) {
                        throw new IllegalStateException("cannot start resync while it's already in progress");
                    }
                    this.bumpPrimaryTerm(newPrimaryTerm, () -> {
                        shardStateUpdated.await();
                        assert (this.pendingPrimaryTerm == newPrimaryTerm) : "shard term changed on primary. expected [" + newPrimaryTerm + "] but was [" + this.pendingPrimaryTerm + "], current routing: " + String.valueOf(currentRouting) + ", new routing: " + String.valueOf(newRouting);
                        assert (this.getOperationPrimaryTerm() == newPrimaryTerm);
                        try {
                            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                                assert (newRouting.primary() && !currentRouting.primary());
                                this.resetEngineToGlobalCheckpoint();
                                this.updateReplicationCheckpoint();
                            }
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                                this.checkpointPublisher.publish(this, this.getLatestReplicationCheckpoint());
                            }
                            this.postActivatePrimaryMode();
                            Engine engine = this.getEngine();
                            engine.translogManager().restoreLocalHistoryFromTranslog(engine.getProcessedLocalCheckpoint(), snapshot -> this.runTranslogRecovery(engine, snapshot, EngineOperation.Origin.LOCAL_RESET, () -> {}));
                            engine.translogManager().rollTranslogGeneration();
                            engine.fillSeqNoGaps(newPrimaryTerm);
                            this.replicationTracker.updateLocalCheckpoint(currentRouting.allocationId().getId(), this.getLocalCheckpoint());
                            primaryReplicaSyncer.accept(this, new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                                public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                                    IndexShard.this.logger.info("primary-replica resync completed with {} operations", (Object)resyncTask.getResyncedOperations());
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                }

                                public void onFailure(Exception e) {
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                                        IndexShard.this.failShard("exception during primary-replica resync", e);
                                    }
                                }
                            });
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            // empty catch block
                        }
                    }, null);
                }
            }
            this.shardRouting = newRouting;
            assert (!this.shardRouting.primary() || !this.shardRouting.started() || this.indexShardOperationPermits.isBlocked() || this.replicationTracker.isPrimaryMode()) : "a started primary with non-pending operation term must be in primary mode " + String.valueOf(this.shardRouting);
            shardStateUpdated.countDown();
        }
        if (!currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted((BaseIndexShard)this);
        }
        if (!newRouting.equals((Object)currentRouting)) {
            this.indexEventListener.shardRoutingChanged((BaseIndexShard)this, currentRouting, newRouting);
        }
        if (this.indexSettings.isSoftDeleteEnabled() && !this.useRetentionLeasesInPeerRecovery && this.state() == IndexShardState.STARTED) {
            RetentionLeases retentionLeases = this.replicationTracker.getRetentionLeases();
            HashSet shardRoutings = new HashSet(routingTable.getShards());
            shardRoutings.addAll(routingTable.assignedShards());
            if (shardRoutings.stream().allMatch(shr -> shr.assignedToNode() && retentionLeases.contains(ReplicationTracker.getPeerRecoveryRetentionLeaseId((ShardRouting)shr)))) {
                this.useRetentionLeasesInPeerRecovery = true;
                this.turnOffTranslogRetention();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(String targetAllocationId, Consumer<ReplicationTracker.PrimaryContext> consumer, Runnable performSegRep) throws IllegalIndexShardStateException, IllegalStateException, InterruptedException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + String.valueOf(this.shardRouting);
        ArrayList releasablesOnHandoffFailures = new ArrayList(2);
        try (Releasable forceRefreshes = this.refreshListeners.forceRefreshes();){
            this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> {
                boolean syncTranslog;
                forceRefreshes.close();
                boolean bl = syncTranslog = (this.isRemoteTranslogEnabled() || this.isMigratingToRemote()) && TranslogSettings.Durability.ASYNC == this.indexSettings.getTranslogDurability();
                if (syncTranslog) {
                    this.maybeSync();
                }
                for (Object refreshListener : this.internalRefreshListener) {
                    if (!(refreshListener instanceof ReleasableRetryableRefreshListener)) continue;
                    releasablesOnHandoffFailures.add(((ReleasableRetryableRefreshListener)refreshListener).drainRefreshes());
                }
                releasablesOnHandoffFailures.add(this.getEngine().translogManager().drainSync());
                assert (this.indexShardOperationPermits.getActiveOperationsCount() == -1) : "in-flight operations in progress while moving shard state to relocated";
                performSegRep.run();
                this.verifyRelocatingState();
                ReplicationTracker.PrimaryContext primaryContext = this.replicationTracker.startRelocationHandoff(targetAllocationId);
                try {
                    Object refreshListener;
                    consumer.accept(primaryContext);
                    refreshListener = this.mutex;
                    synchronized (refreshListener) {
                        this.verifyRelocatingState();
                        this.replicationTracker.completeRelocationHandoff();
                    }
                }
                catch (Exception e) {
                    try {
                        this.replicationTracker.abortRelocationHandoff();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    throw e;
                }
            });
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out waiting for relocation hand-off to complete");
            this.failShard("timed out waiting for relocation hand-off to complete", null);
            throw new IndexShardClosedException(this.shardId(), "timed out waiting for relocation hand-off to complete");
        }
        catch (Exception ex) {
            assert (this.replicationTracker.isPrimaryMode());
            Releasables.close(releasablesOnHandoffFailures);
            throw ex;
        }
    }

    private void maybeSync() {
        try {
            if (this.isSyncNeeded()) {
                this.sync();
            }
        }
        catch (IOException e) {
            this.logger.warn("failed to sync translog", (Throwable)e);
        }
    }

    private void verifyRelocatingState() {
        if (this.state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, this.state);
        }
        if (!this.shardRouting.relocating()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + String.valueOf(this.shardRouting), new Object[0]);
        }
        if (this.primaryReplicaResyncInProgress.get()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": primary relocation is forbidden while primary-replica resync is in progress " + String.valueOf(this.shardRouting), new Object[0]);
        }
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        assert (Thread.holdsLock(this.mutex));
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged((BaseIndexShard)this, previousState, newState, reason);
        return previousState;
    }

    public EngineResult.IndexResult applyIndexOperationOnPrimary(long version, VersionType versionType, SourceToParse sourceToParse, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimestamp, boolean isRetry) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyIndexOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, versionType, ifSeqNo, ifPrimaryTerm, autoGeneratedTimestamp, isRetry, EngineOperation.Origin.PRIMARY, sourceToParse, null);
    }

    public EngineResult.IndexResult applyIndexOperationOnReplica(String id, long seqNo, long opPrimaryTerm, long version, long autoGeneratedTimeStamp, boolean isRetry, SourceToParse sourceToParse) throws IOException {
        return this.applyIndexOperation(this.getEngine(), seqNo, opPrimaryTerm, version, null, -2L, 0L, autoGeneratedTimeStamp, isRetry, EngineOperation.Origin.REPLICA, sourceToParse, id);
    }

    private EngineResult.IndexResult applyIndexOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimeStamp, boolean isRetry, EngineOperation.Origin origin, SourceToParse sourceToParse, String id) throws IOException {
        EngineOperation.Index operation;
        if (this.indexSettings.isSegRepEnabledOrRemoteNode() && !this.routingEntry().primary()) {
            EngineOperation.Index index = new EngineOperation.Index(new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)id)), new ParsedDocument(null, null, id, null, null, sourceToParse.source(), sourceToParse.getMediaType()), seqNo, opPrimaryTerm, version, null, EngineOperation.Origin.REPLICA, System.nanoTime(), autoGeneratedTimeStamp, isRetry, -2L, 0L);
            return this.getEngine().index(index);
        }
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            operation = IndexShard.prepareIndex(this.mapperService, sourceToParse, seqNo, opPrimaryTerm, version, versionType, origin, autoGeneratedTimeStamp, isRetry, ifSeqNo, ifPrimaryTerm);
            Mapping update = ((MappedParsedDocument)operation.parsedDoc()).dynamicMappingsUpdate();
            if (update != null) {
                return new EngineResult.IndexResult(update.toString());
            }
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            return new EngineResult.IndexResult(e, version, opPrimaryTerm, seqNo);
        }
        return this.index(engine, operation);
    }

    public static EngineOperation.Index prepareIndex(MapperService mapperService, SourceToParse source, long seqNo, long primaryTerm, long version, VersionType versionType, EngineOperation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        DocumentMapper documentMapper = mapperService.documentMapper();
        Mapping mapping = null;
        if (documentMapper == null) {
            documentMapper = DocumentMapper.createEmpty((MapperService)mapperService);
            mapping = documentMapper.mapping();
        }
        MappedParsedDocument doc = documentMapper.parse(source);
        if (mapping != null) {
            doc.addDynamicMappingsUpdate(mapping);
        }
        Term uid = new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)doc.id()));
        return new EngineOperation.Index(uid, (ParsedDocument)doc, seqNo, primaryTerm, version, versionType, origin, startTime, autoGeneratedIdTimestamp, isRetry, ifSeqNo, ifPrimaryTerm);
    }

    private EngineResult.IndexResult index(Engine engine, EngineOperation.Index index) throws IOException {
        EngineResult.IndexResult result;
        this.active.set(true);
        index = this.indexingOperationListeners.preIndex(this.shardId, index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin());
            }
            result = engine.index(index);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index-done [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}] result-seq# [{}] result-term [{}] failure [{}]", (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin(), (Object)result.getSeqNo(), (Object)result.getTerm(), (Object)result.getFailure());
            }
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("index-fail [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", new Object[]{index.id(), index.seqNo(), this.routingEntry().allocationId(), index.primaryTerm(), this.getOperationPrimaryTerm(), index.origin()}), (Throwable)e);
            }
            this.indexingOperationListeners.postIndex(this.shardId, index, e);
            throw e;
        }
        this.indexingOperationListeners.postIndex(this.shardId, index, result);
        return result;
    }

    public EngineResult.NoOpResult markSeqNoAsNoop(long seqNo, long opPrimaryTerm, String reason) throws IOException {
        return this.markSeqNoAsNoop(this.getEngine(), seqNo, opPrimaryTerm, reason, EngineOperation.Origin.REPLICA);
    }

    private EngineResult.NoOpResult markSeqNoAsNoop(Engine engine, long seqNo, long opPrimaryTerm, String reason, EngineOperation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        long startTime = System.nanoTime();
        this.ensureWriteAllowed(origin);
        EngineOperation.NoOp noOp = new EngineOperation.NoOp(seqNo, opPrimaryTerm, origin, startTime, reason);
        return this.noOp(engine, noOp);
    }

    private EngineResult.NoOpResult noOp(Engine engine, EngineOperation.NoOp noOp) throws IOException {
        this.active.set(true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("noop (seq# [{}])", (Object)noOp.seqNo());
        }
        return engine.noOp(noOp);
    }

    public EngineResult.IndexResult getFailedIndexResult(Exception e, long version) {
        return new EngineResult.IndexResult(e, version);
    }

    public EngineResult.DeleteResult getFailedDeleteResult(Exception e, long version) {
        return new EngineResult.DeleteResult(e, version, this.getOperationPrimaryTerm());
    }

    public EngineResult.DeleteResult applyDeleteOperationOnPrimary(long version, String id, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyDeleteOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, id, versionType, ifSeqNo, ifPrimaryTerm, EngineOperation.Origin.PRIMARY);
    }

    public EngineResult.DeleteResult applyDeleteOperationOnReplica(long seqNo, long opPrimaryTerm, long version, String id) throws IOException {
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            EngineOperation.Delete delete = new EngineOperation.Delete(id, new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)id)), seqNo, opPrimaryTerm, version, null, EngineOperation.Origin.REPLICA, System.nanoTime(), -2L, 0L);
            return this.getEngine().delete(delete);
        }
        return this.applyDeleteOperation(this.getEngine(), seqNo, opPrimaryTerm, version, id, null, -2L, 0L, EngineOperation.Origin.REPLICA);
    }

    private EngineResult.DeleteResult applyDeleteOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, String id, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, EngineOperation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        EngineOperation.Delete delete = IndexShard.prepareDelete(id, seqNo, opPrimaryTerm, version, versionType, origin, ifSeqNo, ifPrimaryTerm);
        return this.delete(engine, delete);
    }

    public static EngineOperation.Delete prepareDelete(String id, long seqNo, long primaryTerm, long version, VersionType versionType, EngineOperation.Origin origin, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        Term uid = new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)id));
        return new EngineOperation.Delete(id, uid, seqNo, primaryTerm, version, versionType, origin, startTime, ifSeqNo, ifPrimaryTerm);
    }

    private EngineResult.DeleteResult delete(Engine engine, EngineOperation.Delete delete) throws IOException {
        EngineResult.DeleteResult result;
        this.active.set(true);
        delete = this.indexingOperationListeners.preDelete(this.shardId, delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}] (seq no [{}])", (Object)delete.uid().text(), (Object)delete.seqNo());
            }
            result = engine.delete(delete);
        }
        catch (Exception e) {
            this.indexingOperationListeners.postDelete(this.shardId, delete, e);
            throw e;
        }
        this.indexingOperationListeners.postDelete(this.shardId, delete, result);
        return result;
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        DocumentMapper mapper = this.mapperService.documentMapper();
        if (mapper == null) {
            return Engine.GetResult.NOT_EXISTS;
        }
        return this.getEngine().get(get, this.mapperService.mappingLookup(), this.mapperService().documentParser(), this::wrapSearcher);
    }

    public RefreshStats refreshStats() {
        int listeners = this.refreshListeners.pendingCount();
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()), this.externalRefreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.externalRefreshMetric.sum()), listeners);
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), this.periodicFlushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        this.readAllowed();
        return this.getEngine().docStats();
    }

    public CommitStats commitStats() {
        return this.getEngine().commitStats();
    }

    public IndexingStats indexingStats() {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            RecoveryState recoveryState = this.recoveryState;
            long bytesStillToRecover = recoveryState == null ? -1L : recoveryState.getIndex().bytesStillToRecover();
            return this.store.stats(bytesStillToRecover == -1L ? -1L : bytesStillToRecover);
        }
        catch (IOException e) {
            this.failShard("Failing shard because of exception during storeStats", e);
            throw new SkyliteException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        MergeStats mergeStats = engine.getMergeStats();
        mergeStats.addUnreferencedFileCleanUpStats(engine.unreferencedFileCleanUpsPerformed());
        return mergeStats;
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            segmentsStats.addRemoteSegmentStats(new RemoteSegmentStats(this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(this.shardId).stats()));
        }
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            segmentsStats.addReplicationStats(this.getReplicationStats());
        }
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        TranslogStats translogStats = this.getEngine().translogManager().getTranslogStats();
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            translogStats.addRemoteTranslogStats(new RemoteTranslogStats(this.remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(this.shardId).stats()));
        }
        return translogStats;
    }

    public CompletionStats completionStats(String ... fields) {
        this.readAllowed();
        return this.getEngine().completionStats(fields);
    }

    public void flush(FlushRequest request) {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        this.logger.trace("flush with {}", (Object)request);
        this.verifyNotClosed();
        long time = System.nanoTime();
        this.getEngine().flush(force, waitIfOngoing);
        this.flushMetric.inc(System.nanoTime() - time);
    }

    public void trimTranslog() {
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            return;
        }
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        engine.translogManager().trimUnreferencedTranslogFiles();
    }

    public void rollTranslogGeneration() throws IOException {
        Engine engine = this.getEngine();
        engine.translogManager().rollTranslogGeneration();
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", (Object)forceMerge);
        }
        Engine engine = this.getEngine();
        engine.forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false, forceMerge.forceMergeUUID());
    }

    public Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", (Object)upgrade);
        }
        Version previousVersion = this.minimumCompatibleVersion();
        Engine engine = this.getEngine();
        engine.forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments(), null);
        Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", (Object)this.shardId, (Object)previousVersion, (Object)version);
        }
        return version;
    }

    public Version minimumCompatibleVersion() {
        Version luceneVersion = null;
        for (Segment segment : this.getEngine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? this.indexSettings.getIndexVersionCreated().luceneVersion : luceneVersion;
    }

    public GatedCloseable<IndexCommit> acquireLastIndexCommitAndRefresh(boolean flushFirst) throws EngineException {
        GatedCloseable indexCommit = this.acquireLastIndexCommit(flushFirst);
        this.getEngine().refresh("Snapshot for Remote Store based Shard");
        return indexCommit;
    }

    public void acquireLockOnCommitData(String snapshotId, long primaryTerm, long generation) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this.getRemoteDirectory();
        remoteSegmentStoreDirectory.acquireLock(primaryTerm, generation, snapshotId);
    }

    public void releaseLockOnCommitData(String snapshotId, long primaryTerm, long generation) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this.getRemoteDirectory();
        remoteSegmentStoreDirectory.releaseLock(primaryTerm, generation, snapshotId);
    }

    public void finalizeReplication(SegmentInfos infos) throws IOException {
        if (this.getReplicationEngine().isPresent()) {
            ((NRTReplicationEngine)this.getReplicationEngine().get()).updateSegments(infos);
        }
    }

    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireSafeIndexCommit();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public ReplicationCheckpoint getLatestReplicationCheckpoint() {
        return this.replicationTracker.getLatestReplicationCheckpoint();
    }

    public Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> getLatestSegmentInfosAndCheckpoint() {
        assert (this.indexSettings.isSegRepEnabledOrRemoteNode());
        GatedCloseable<SegmentInfos> snapshot = null;
        try {
            snapshot = this.getSegmentInfosSnapshot();
            SegmentInfos segmentInfos = (SegmentInfos)snapshot.get();
            return new Tuple(snapshot, (Object)this.computeReplicationCheckpoint(segmentInfos));
        }
        catch (IOException | AlreadyClosedException e) {
            this.logger.error("Error Fetching SegmentInfos and latest checkpoint", e);
            if (snapshot != null) {
                try {
                    snapshot.close();
                }
                catch (IOException ex) {
                    throw new SkyliteException("Error Closing SegmentInfos Snapshot", e, new Object[0]);
                }
            }
            return new Tuple((Object)new GatedCloseable(null, () -> {}), (Object)this.getLatestReplicationCheckpoint());
        }
    }

    ReplicationCheckpoint computeReplicationCheckpoint(SegmentInfos segmentInfos) throws IOException {
        if (segmentInfos == null) {
            return ReplicationCheckpoint.empty((ShardId)this.shardId);
        }
        ReplicationCheckpoint latestReplicationCheckpoint = this.getLatestReplicationCheckpoint();
        if (latestReplicationCheckpoint.getSegmentInfosVersion() == segmentInfos.getVersion() && latestReplicationCheckpoint.getSegmentsGen() == segmentInfos.getGeneration()) {
            return latestReplicationCheckpoint;
        }
        Map metadataMap = this.store.getSegmentMetadataMap(segmentInfos);
        ReplicationCheckpoint checkpoint = new ReplicationCheckpoint(this.shardId, this.getOperationPrimaryTerm(), segmentInfos.getGeneration(), segmentInfos.getVersion(), metadataMap.values().stream().mapToLong(StoreFileMetadata::length).sum(), this.getEngine().config().getCodec().getName(), metadataMap);
        this.logger.trace("Recomputed ReplicationCheckpoint for shard {}", (Object)checkpoint);
        return checkpoint;
    }

    public final boolean shouldProcessCheckpoint(ReplicationCheckpoint requestCheckpoint) {
        if (!this.isSegmentReplicationAllowed()) {
            return false;
        }
        ReplicationCheckpoint localCheckpoint = this.getLatestReplicationCheckpoint();
        if (!requestCheckpoint.isAheadOf(localCheckpoint)) {
            this.logger.trace(() -> new ParameterizedMessage("Ignoring new replication checkpoint - Shard is already on checkpoint {} that is ahead of {}", (Object)localCheckpoint, (Object)requestCheckpoint));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        Object object;
        GatedCloseable wrappedIndexCommit;
        block8: {
            Store.MetadataSnapshot metadataSnapshot;
            assert (!Thread.holdsLock(this.mutex)) : "snapshotting store metadata under mutex";
            wrappedIndexCommit = null;
            this.store.incRef();
            try {
                object = this.engineMutex;
                // MONITORENTER : object
                Engine engine = this.getEngineOrNull();
                if (engine != null) {
                    wrappedIndexCommit = engine.acquireLastIndexCommit(false);
                }
                if (wrappedIndexCommit != null) break block8;
                metadataSnapshot = this.store.getMetadata(null, true);
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                this.store.decRef();
                IOUtils.close(wrappedIndexCommit);
                throw throwable;
            }
            this.store.decRef();
            IOUtils.close((Closeable)wrappedIndexCommit);
            return metadataSnapshot;
        }
        // MONITOREXIT : object
        object = this.store.getMetadata((IndexCommit)wrappedIndexCommit.get());
        this.store.decRef();
        IOUtils.close((Closeable)wrappedIndexCommit);
        return object;
    }

    public Map<String, StoreFileMetadata> getSegmentMetadataMap() throws IOException {
        try (GatedCloseable<SegmentInfos> snapshot = this.getSegmentInfosSnapshot();){
            Map map = this.store.getSegmentMetadataMap((SegmentInfos)snapshot.get());
            return map;
        }
    }

    public Engine.SearcherSupplier acquireSearcherSupplier() {
        return this.acquireSearcherSupplier(Engine.SearcherScope.EXTERNAL);
    }

    public Engine.SearcherSupplier acquireSearcherSupplier(Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcherSupplier(this::wrapSearcher, scope);
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, Engine.SearcherScope.EXTERNAL);
    }

    private Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcher(source, scope, this::wrapSearcher);
    }

    private Engine.Searcher wrapSearcher(Engine.Searcher searcher) {
        Engine.Searcher searcher2;
        block7: {
            assert (SkyliteDirectoryReader.unwrap((DirectoryReader)searcher.getDirectoryReader()) != null) : "DirectoryReader must be an instance or OpenSearchDirectoryReader";
            boolean success = false;
            try {
                Engine.Searcher newSearcher;
                Engine.Searcher searcher3 = newSearcher = this.readerWrapper == null ? searcher : IndexShard.wrapSearcher(searcher, this.readerWrapper);
                assert (newSearcher != null);
                success = true;
                searcher2 = newSearcher;
                if (success) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new SkyliteException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((boolean)success, (Releasable[])new Releasable[]{searcher});
                    }
                    throw throwable;
                }
            }
            Releasables.close((boolean)success, (Releasable[])new Releasable[]{searcher});
        }
        return searcher2;
    }

    static Engine.Searcher wrapSearcher(Engine.Searcher engineSearcher, CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        assert (readerWrapper != null);
        SkyliteDirectoryReader skyliteDirectoryReader = SkyliteDirectoryReader.getOpenSearchDirectoryReader((DirectoryReader)engineSearcher.getDirectoryReader());
        if (skyliteDirectoryReader == null) {
            throw new IllegalStateException("Can't wrap non opensearch directory reader");
        }
        NonClosingReaderWrapper nonClosingReaderWrapper = new NonClosingReaderWrapper(engineSearcher.getDirectoryReader());
        DirectoryReader reader = (DirectoryReader)readerWrapper.apply((Object)nonClosingReaderWrapper);
        if (reader != nonClosingReaderWrapper) {
            if (reader.getReaderCacheHelper() != skyliteDirectoryReader.getReaderCacheHelper()) {
                throw new IllegalStateException("wrapped directory reader doesn't delegate IndexReader#getCoreCacheKey, wrappers must override this method and delegate to the original readers core cache key. Wrapped readers can't be used as cache keys since their are used only per request which would lead to subtle bugs");
            }
            if (SkyliteDirectoryReader.getOpenSearchDirectoryReader((DirectoryReader)reader) != skyliteDirectoryReader) {
                throw new IllegalStateException("wrapped directory reader hides actual OpenSearchDirectoryReader but shouldn't");
            }
        }
        if (reader == nonClosingReaderWrapper) {
            return engineSearcher;
        }
        return new Engine.Searcher(engineSearcher.source(), (IndexReader)reader, engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), () -> IOUtils.close((Closeable[])new Closeable[]{reader, engineSearcher}));
    }

    public void resetToWriteableEngine() throws IOException, InterruptedException, TimeoutException {
        this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> this.resetEngineToGlobalCheckpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFromLocalShards(Consumer<MappingMetadata> mappingUpdateConsumer, List<BaseIndexShard> localShards, ActionListener<Boolean> listener) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        ActionListener recoveryListener = ActionListenerHelper.runBefore(listener, () -> IOUtils.close((Iterable)snapshots));
        boolean success = false;
        try {
            for (BaseIndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots, recoveryListener);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close(snapshots);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine, boolean deleted) throws IOException {
        Object object = this.engineMutex;
        synchronized (object) {
            Engine engine;
            block16: {
                try {
                    Object object2 = this.mutex;
                    synchronized (object2) {
                        this.changeState(IndexShardState.CLOSED, reason);
                    }
                }
                catch (Throwable throwable) {
                    Engine engine2;
                    block17: {
                        engine2 = this.currentEngineReference.getAndSet(null);
                        try {
                            if (engine2 == null || !flushEngine) break block17;
                            engine2.flushAndClose();
                        }
                        catch (Throwable throwable2) {
                            IOUtils.close((Closeable[])new Closeable[]{engine2, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions});
                            if (deleted && engine2 != null && this.isPrimaryMode()) {
                                engine2.translogManager().onDelete();
                            }
                            this.indexShardOperationPermits.close();
                            throw throwable2;
                        }
                    }
                    IOUtils.close((Closeable[])new Closeable[]{engine2, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions});
                    if (deleted && engine2 != null && this.isPrimaryMode()) {
                        engine2.translogManager().onDelete();
                    }
                    this.indexShardOperationPermits.close();
                    throw throwable;
                }
                engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine == null || !flushEngine) break block16;
                    engine.flushAndClose();
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions});
                    if (deleted && engine != null && this.isPrimaryMode()) {
                        engine.translogManager().onDelete();
                    }
                    this.indexShardOperationPermits.close();
                    throw throwable;
                }
            }
            IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions});
            if (deleted && engine != null && this.isPrimaryMode()) {
                engine.translogManager().onDelete();
            }
            this.indexShardOperationPermits.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.postRecoveryMutex;
        synchronized (object) {
            this.getEngine().refresh("post_recovery");
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.state == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(this.shardId);
                }
                if (this.state == IndexShardState.STARTED) {
                    throw new IndexShardStartedException(this.shardId);
                }
                this.recoveryState.setStage(RecoveryState.Stage.DONE);
                this.changeState(IndexShardState.POST_RECOVERY, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long recoverLocallyUpToGlobalCheckpoint() {
        Optional safeCommit;
        long globalCheckpoint;
        this.validateLocalRecoveryState();
        try {
            String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
            globalCheckpoint = TranslogStatelessHelper.readGlobalCheckpoint((Path)this.translogConfig.getTranslogPath(), (String)translogUUID);
            safeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
        }
        catch (org.apache.lucene.index.IndexNotFoundException e) {
            this.logger.trace("skip local recovery as no index commit found");
            return -2L;
        }
        catch (Exception e) {
            this.logger.debug("skip local recovery as failed to find the safe commit", (Throwable)e);
            return -2L;
        }
        try {
            Object translogRecoveryRunner;
            this.maybeCheckIndex();
            this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            if (!safeCommit.isPresent()) {
                this.logger.trace("skip local recovery as no safe commit found");
                return -2L;
            }
            assert (((SequenceNumbers.CommitInfo)safeCommit.get()).localCheckpoint <= globalCheckpoint) : ((SequenceNumbers.CommitInfo)safeCommit.get()).localCheckpoint + " > " + globalCheckpoint;
            if (((SequenceNumbers.CommitInfo)safeCommit.get()).localCheckpoint == globalCheckpoint) {
                this.logger.trace("skip local recovery as the safe commit is up to date; safe commit {} global checkpoint {}", safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return globalCheckpoint + 1L;
            }
            if (this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE || ((Boolean)IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(this.indexSettings.getSettings())).booleanValue()) {
                this.logger.trace("skip local recovery as the index was closed or not allowed to write; safe commit {} global checkpoint {}", safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return ((SequenceNumbers.CommitInfo)safeCommit.get()).localCheckpoint + 1L;
            }
            try {
                translogRecoveryRunner = snapshot -> {
                    this.recoveryState.getTranslog().totalLocal(snapshot.totalOperations());
                    int recoveredOps = this.runTranslogRecovery(this.getEngine(), snapshot, EngineOperation.Origin.LOCAL_TRANSLOG_RECOVERY, () -> ((RecoveryState.Translog)this.recoveryState.getTranslog()).incrementRecoveredOperations());
                    this.recoveryState.getTranslog().totalLocal(recoveredOps);
                    return recoveredOps;
                };
                this.innerOpenEngineAndTranslog(() -> globalCheckpoint);
                this.getEngine().translogManager().recoverFromTranslog(translogRecoveryRunner, this.getEngine().getProcessedLocalCheckpoint(), globalCheckpoint);
                this.logger.trace("shard locally recovered up to {}", (Object)this.getEngine().getSeqNoStats(globalCheckpoint));
            }
            finally {
                translogRecoveryRunner = this.engineMutex;
                synchronized (translogRecoveryRunner) {
                    IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
                }
            }
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to recover shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
        try {
            Optional newSafeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
            assert (newSafeCommit.isPresent()) : "no safe commit found after local recovery";
            return ((SequenceNumbers.CommitInfo)newSafeCommit.get()).localCheckpoint + 1L;
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to find the safe commit after recovering shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
    }

    public long recoverLocallyAndFetchStartSeqNo(boolean localTranslog) {
        if (localTranslog) {
            return this.recoverLocallyUpToGlobalCheckpoint();
        }
        return this.recoverLocallyUptoLastCommit();
    }

    private long recoverLocallyUptoLastCommit() {
        long seqNo;
        assert (this.indexSettings.isAssignedOnRemoteNode()) : "Remote translog store is not enabled";
        this.validateLocalRecoveryState();
        try {
            seqNo = Long.parseLong((String)this.store.readLastCommittedSegmentsInfo().getUserData().get("max_seq_no"));
        }
        catch (org.apache.lucene.index.IndexNotFoundException e) {
            this.logger.error("skip local recovery as no index commit found");
            return -2L;
        }
        catch (Exception e) {
            this.logger.error("skip local recovery as failed to find the safe commit", (Throwable)e);
            return -2L;
        }
        try {
            this.maybeCheckIndex();
            this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            this.recoveryState.getTranslog().totalLocal(0);
        }
        catch (Exception e) {
            this.logger.error("check index failed during fetch seqNo", (Throwable)e);
            return -2L;
        }
        return seqNo;
    }

    private void validateLocalRecoveryState() {
        assert (!Thread.holdsLock(this.mutex)) : "recover locally under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
    }

    public void trimOperationOfPreviousPrimaryTerms(long aboveSeqNo) {
        this.getEngine().translogManager().trimOperationsFromTranslog(this.getOperationPrimaryTerm(), aboveSeqNo);
    }

    public void updateMaxUnsafeAutoIdTimestamp(long maxSeenAutoIdTimestampFromPrimary) {
        this.getEngine().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampFromPrimary);
    }

    public EngineResult applyTranslogOperation(TranslogOperation operation, EngineOperation.Origin origin) throws IOException {
        return this.applyTranslogOperation(this.getEngine(), operation, origin);
    }

    private EngineResult applyTranslogOperation(Engine engine, TranslogOperation operation, EngineOperation.Origin origin) throws IOException {
        VersionType versionType = origin == EngineOperation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        return switch (operation.opType()) {
            case TranslogOperation.Type.INDEX -> {
                TranslogOperation.Index index = (TranslogOperation.Index)operation;
                yield this.applyIndexOperation(engine, index.seqNo(), index.primaryTerm(), index.version(), versionType, -2L, 0L, index.getAutoGeneratedIdTimestamp(), true, origin, new SourceToParse(this.shardId.getIndexName(), index.id(), index.source(), MediaTypeRegistry.xContentType((BytesReference)index.source()), index.routing()), index.id());
            }
            case TranslogOperation.Type.DELETE -> {
                TranslogOperation.Delete delete = (TranslogOperation.Delete)operation;
                yield this.applyDeleteOperation(engine, delete.seqNo(), delete.primaryTerm(), delete.version(), delete.id(), versionType, -2L, 0L, origin);
            }
            case TranslogOperation.Type.NO_OP -> {
                TranslogOperation.NoOp noOp = (TranslogOperation.NoOp)operation;
                yield this.markSeqNoAsNoop(engine, noOp.seqNo(), noOp.primaryTerm(), noOp.reason(), origin);
            }
            default -> throw new IllegalStateException("No operation defined for [" + String.valueOf(operation) + "]");
        };
    }

    int runTranslogRecovery(Engine engine, TranslogSnapshotIterator snapshot, EngineOperation.Origin origin, Runnable onOperationRecovered) throws IOException {
        TranslogOperation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.logger.trace("[translog] recover op {}", (Object)operation);
                EngineResult result = this.applyTranslogOperation(engine, operation, origin);
                switch (result.getResultType()) {
                    case FAILURE: {
                        throw result.getFailure();
                    }
                    case MAPPING_UPDATE_REQUIRED: {
                        throw new IllegalArgumentException("unexpected mapping update: " + result.getRequiredMappingUpdate());
                    }
                    case SUCCESS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown result type [" + String.valueOf(result.getResultType()) + "]"));
                    }
                }
                ++opsRecovered;
                onOperationRecovered.run();
            }
            catch (Exception e) {
                if (origin == EngineOperation.Origin.LOCAL_TRANSLOG_RECOVERY && SkyliteExceptionsHelper.status((Throwable)e) == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw SkyliteExceptionsHelper.convertToRuntime((Exception)e);
            }
        }
        return opsRecovered;
    }

    private void loadGlobalCheckpointToReplicationTracker() throws IOException {
        String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        long globalCheckpoint = TranslogStatelessHelper.readGlobalCheckpoint((Path)this.translogConfig.getTranslogPath(), (String)translogUUID);
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, "read from translog checkpoint");
    }

    public void openEngineAndRecoverFromTranslog() throws IOException {
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        this.maybeCheckIndex();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        RecoveryState.Translog translogRecoveryStats = this.recoveryState.getTranslog();
        TranslogRecoveryRunner translogRecoveryRunner = snapshot -> {
            translogRecoveryStats.totalOperations(snapshot.totalOperations());
            translogRecoveryStats.totalOperationsOnStart(snapshot.totalOperations());
            return this.runTranslogRecovery(this.getEngine(), snapshot, EngineOperation.Origin.LOCAL_TRANSLOG_RECOVERY, () -> ((RecoveryState.Translog)translogRecoveryStats).incrementRecoveredOperations());
        };
        if (!this.indexSettings.isRemoteSnapshot() && !this.indexSettings.isRemoteTranslogStoreEnabled()) {
            this.loadGlobalCheckpointToReplicationTracker();
        }
        this.innerOpenEngineAndTranslog((LongSupplier)this.replicationTracker);
        this.getEngine().translogManager().recoverFromTranslog(translogRecoveryRunner, this.getEngine().getProcessedLocalCheckpoint(), Long.MAX_VALUE);
    }

    public void openEngineAndSkipTranslogRecovery() throws IOException {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog((LongSupplier)this.replicationTracker);
        this.getEngine().translogManager().skipTranslogRecovery();
    }

    public void openEngineAndSkipTranslogRecoveryFromSnapshot() throws IOException {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "not a snapshot recovery [" + String.valueOf(this.routingEntry()) + "]";
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        this.maybeCheckIndex();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog((LongSupplier)this.replicationTracker, false);
        this.getEngine().translogManager().skipTranslogRecovery();
    }

    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier) throws IOException {
        this.innerOpenEngineAndTranslog(globalCheckpointSupplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier, boolean syncFromRemote) throws IOException {
        boolean bl = syncFromRemote = syncFromRemote && !this.indexSettings.isRemoteSnapshot();
        assert (!Thread.holdsLock(this.mutex)) : "opening engine under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        EngineConfig config = this.newEngineConfig(globalCheckpointSupplier);
        config.setEnableGcDeletes(false);
        this.updateRetentionLeasesOnReplica(this.loadRetentionLeases());
        assert (!this.recoveryState.getRecoverySource().expectEmptyRetentionLeases() || this.getRetentionLeases().leases().isEmpty()) : "expected empty set of retention leases with recovery source [" + String.valueOf(this.recoveryState.getRecoverySource()) + "] but got " + String.valueOf(this.getRetentionLeases());
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.currentEngineReference.get() == null) : "engine is running";
            this.verifyNotClosed();
            if (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded()) {
                if (syncFromRemote) {
                    this.syncSegmentsFromRemoteSegmentStore(false);
                }
                if (this.shardRouting.primary()) {
                    if (syncFromRemote) {
                        this.syncRemoteTranslogAndUpdateGlobalCheckpoint();
                    } else {
                        this.deleteTranslogFilesFromRemoteTranslog();
                    }
                } else if (syncFromRemote) {
                    SegmentInfos lastCommittedSegmentInfos = this.store().readLastCommittedSegmentsInfo();
                    String translogUUID = (String)lastCommittedSegmentInfos.userData.get("translog_uuid");
                    long checkpoint = Long.parseLong((String)lastCommittedSegmentInfos.userData.get("local_checkpoint"));
                    Translog.createEmptyTranslog((Path)this.shardPath().resolveTranslog(), (ShardId)this.shardId(), (long)checkpoint, (long)this.getPendingPrimaryTerm(), (String)translogUUID, FileChannel::open);
                }
            }
            Engine newEngine = this.engineFactory.newReadWriteEngine(config);
            this.onNewEngine(newEngine);
            this.currentEngineReference.set(newEngine);
            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                this.updateReplicationCheckpoint();
            }
            this.active.set(true);
        }
        this.onSettingsChanged();
        assert (this.assertSequenceNumbersInCommit());
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
    }

    private boolean assertSequenceNumbersInCommit() throws IOException {
        Map<String, String> userData = this.fetchUserData();
        assert (userData.containsKey("local_checkpoint")) : "commit point doesn't contains a local checkpoint";
        assert (userData.containsKey("max_seq_no")) : "commit point doesn't contains a maximum sequence number";
        assert (userData.containsKey("history_uuid")) : "commit point doesn't contains a history uuid";
        assert (userData.get("history_uuid").equals(this.getHistoryUUID())) : "commit point history uuid [" + userData.get("history_uuid") + "] is different than engine [" + this.getHistoryUUID() + "]";
        assert (userData.containsKey("max_unsafe_auto_id_timestamp")) : "opening index which was created post 5.5.0 but max_unsafe_auto_id_timestamp is not found in commit";
        return true;
    }

    private Map<String, String> fetchUserData() throws IOException {
        if (this.indexSettings.isRemoteSnapshot() && this.indexSettings.getExtendedCompatibilitySnapshotVersion() != null) {
            return XLucene.readSegmentInfos((Directory)this.store.directory(), (io.skylite.Version)this.indexSettings.getExtendedCompatibilitySnapshotVersion()).getUserData();
        }
        return SegmentInfos.readLatestCommit((Directory)this.store.directory()).getUserData();
    }

    private void onNewEngine(Engine newEngine) {
        assert (Thread.holdsLock(this.engineMutex));
        this.refreshListeners.setCurrentRefreshLocationSupplier(() -> ((TranslogManager)newEngine.translogManager()).getTranslogLastWriteLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "restart recovery under mutex";
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.refreshListeners.pendingCount() == 0) : "we can't restart with pending listeners";
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
            this.resetRecoveryStage();
        }
    }

    public void resetRecoveryStage() {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        assert (this.currentEngineReference.get() == null);
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState().setStage(RecoveryState.Stage.INIT);
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains(state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    private void ensureWriteAllowed(EngineOperation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + String.valueOf(origin) + "]", new Object[0]);
            }
        } else {
            if (origin == EngineOperation.Origin.PRIMARY) {
                assert (this.assertPrimaryMode());
            } else if (origin == EngineOperation.Origin.REPLICA) {
                assert (this.assertReplicationTarget());
            } else {
                assert (origin == EngineOperation.Origin.LOCAL_RESET);
                assert (this.getActiveOperationsCount() == -1) : "locally resetting without blocking operations, active operations are [" + String.valueOf(this.getActiveOperations()) + "]";
            }
            if (!writeAllowedStates.contains(state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + String.valueOf(writeAllowedStates) + ", origin [" + String.valueOf(origin) + "]", new Object[0]);
            }
        }
    }

    public boolean isPrimaryMode() {
        return this.shardRouting.primary() && this.replicationTracker.isPrimaryMode();
    }

    private boolean assertReplicationTarget() {
        assert (!this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " in primary mode cannot be a replication target";
        return true;
    }

    protected final void verifyActive() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard is active", new Object[0]);
        }
    }

    public void addShardFailureCallback(Consumer<BaseIndexShard.ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void flushOnIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("flushing shard on inactive");
            this.threadPool.executor("flush").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                        IndexShard.this.logger.warn("failed to flush shard on inactive", (Throwable)e);
                    }
                }

                public void doRun() {
                    IndexShard.this.flush(new FlushRequest(new String[0]).waitIfOngoing(false).force(false));
                    IndexShard.this.periodicFlushMetric.inc();
                }
            });
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void recoverFromStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromStore(this, listener);
    }

    public void restoreFromRemoteStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromRemoteStore(this, listener);
    }

    public void restoreFromSnapshotAndRemoteStore(Repository repository, RepositoriesService repositoriesService, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromSnapshotAndRemoteStore(this, repository, repositoriesService, listener, this.threadPool);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void restoreFromRepository(Repository repository, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromRepository(this, repository, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public boolean shouldPeriodicallyFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldPeriodicallyFlush();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean shouldRollTranslogGeneration() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.translogManager().shouldRollTranslogGeneration();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            boolean disableTranslogRetention = this.indexSettings.isSoftDeleteEnabled() && this.useRetentionLeasesInPeerRecovery;
            engineOrNull.onSettingsChanged(disableTranslogRetention ? TimeValue.MINUS_ONE : this.indexSettings.getTranslogRetentionAge(), disableTranslogRetention ? new ByteSizeValue(-1L) : this.indexSettings.getTranslogRetentionSize(), this.indexSettings.getSoftDeleteRetentionOperations());
        }
    }

    private void turnOffTranslogRetention() {
        this.logger.debug("turn off the translog retention for the replication group {} as it starts using retention leases exclusively in peer recoveries", (Object)this.shardId);
        this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (IndexShard.this.state != IndexShardState.CLOSED) {
                    IndexShard.this.logger.warn("failed to turn off translog retention", (Throwable)e);
                }
            }

            public void doRun() {
                IndexShard.this.onSettingsChanged();
                IndexShard.this.trimTranslog();
            }
        });
    }

    public Closeable acquireHistoryRetentionLock() {
        return this.getEngine().acquireHistoryRetentionLock();
    }

    public boolean hasCompleteHistoryOperations(String reason, long startingSeqNo) {
        return this.getEngine().hasCompleteOperationHistory(reason, startingSeqNo);
    }

    public long getMinRetainedSeqNo() {
        return this.getEngine().getMinRetainedSeqNo();
    }

    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNo) throws IOException {
        return this.getEngine().countNumberOfHistoryOperations(source, fromSeqNo, toSeqNo);
    }

    public List<Segment> segments(boolean verbose) {
        return this.getEngine().segments(verbose);
    }

    public String getHistoryUUID() {
        return this.getEngine().getHistoryUUID();
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public void updateVisibleCheckpointForShard(String allocationId, ReplicationCheckpoint visibleCheckpoint) {
        if (this.isPrimaryMode()) {
            this.verifyNotClosed();
            this.replicationTracker.updateVisibleCheckpointForShard(allocationId, visibleCheckpoint);
        }
    }

    public Set<SegmentReplicationShardStats> getReplicationStatsForTrackedReplicas() {
        return this.replicationTracker.getSegmentReplicationStats();
    }

    public ReplicationStats getReplicationStats() {
        if (this.indexSettings.isSegRepEnabledOrRemoteNode() && this.routingEntry().primary()) {
            Set<SegmentReplicationShardStats> stats = this.getReplicationStatsForTrackedReplicas();
            long maxBytesBehind = stats.stream().mapToLong(SegmentReplicationShardStats::getBytesBehindCount).max().orElse(0L);
            long totalBytesBehind = stats.stream().mapToLong(SegmentReplicationShardStats::getBytesBehindCount).sum();
            long maxReplicationLag = stats.stream().mapToLong(SegmentReplicationShardStats::getCurrentReplicationLagMillis).max().orElse(0L);
            return new ReplicationStats(maxBytesBehind, totalBytesBehind, maxReplicationLag);
        }
        return new ReplicationStats();
    }

    private void ensureSoftDeletesEnabled(String feature) {
        if (!this.indexSettings.isSoftDeleteEnabled()) {
            String message = feature + " requires soft deletes but " + String.valueOf(this.indexSettings.getIndex()) + " does not have soft deletes enabled";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    public RetentionLeaseStats getRetentionLeaseStats() {
        this.verifyNotClosed();
        return new RetentionLeaseStats(this.getRetentionLeases());
    }

    public RetentionLease addRetentionLease(String id, long retainingSequenceNumber, String source, ActionListener<ReplicationResponse> listener) {
        RetentionLease retentionLease;
        block9: {
            Objects.requireNonNull(listener);
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.addRetentionLease(id, actualRetainingSequenceNumber, source, listener);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public RetentionLease renewRetentionLease(String id, long retainingSequenceNumber, String source) {
        RetentionLease retentionLease;
        block9: {
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.renewRetentionLease(id, actualRetainingSequenceNumber, source);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public void removeRetentionLease(String id, ActionListener<ReplicationResponse> listener) {
        Objects.requireNonNull(listener);
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.ensureSoftDeletesEnabled("retention leases");
        this.replicationTracker.removeRetentionLease(id, listener);
    }

    public void updateRetentionLeasesOnReplica(RetentionLeases retentionLeases) {
        assert (this.assertReplicationTarget());
        this.verifyNotClosed();
        this.replicationTracker.updateRetentionLeasesOnReplica(retentionLeases);
    }

    public boolean assertRetentionLeasesPersisted() throws IOException {
        return this.replicationTracker.assertRetentionLeasesPersisted(this.path.getShardStatePath());
    }

    public void syncRetentionLeases() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.renewPeerRecoveryRetentionLeases();
        Tuple retentionLeases = this.getRetentionLeases(true);
        if (((Boolean)retentionLeases.v1()).booleanValue()) {
            this.logger.trace("syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.sync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2(), ActionListenerHelper.wrap(r -> {}, e -> this.logger.warn((Message)new ParameterizedMessage("failed to sync retention leases [{}] after expiration check", (Object)retentionLeases), (Throwable)e)));
        } else {
            this.logger.trace("background syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.backgroundSync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2());
        }
    }

    public void initiateTracking(String allocationId) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.assertPrimaryMode());
        this.replicationTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.getEngine().getPersistedLocalCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.getEngine().getProcessedLocalCheckpoint();
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        ReplicationGroup replicationGroup = this.replicationTracker.getReplicationGroup();
        this.pendingReplicationActions.accept(replicationGroup);
        return replicationGroup;
    }

    public PendingReplicationActions getPendingReplicationActions() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.pendingReplicationActions;
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.assertReplicationTarget());
        long localCheckpoint = this.getLocalCheckpoint();
        if (globalCheckpoint > localCheckpoint) {
            assert (this.state() != IndexShardState.POST_RECOVERY && this.state() != IndexShardState.STARTED) : "supposedly in-sync shard copy received a global checkpoint [" + globalCheckpoint + "] that is higher than its local checkpoint [" + localCheckpoint + "]";
            return;
        }
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateWithPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        assert (this.shardRouting.primary() && this.shardRouting.isRelocationTarget()) : "only primary relocation target can update allocation IDs from primary context: " + String.valueOf(this.shardRouting);
        assert (primaryContext.getCheckpointStates().containsKey(this.routingEntry().allocationId().getId())) : "primary context [" + String.valueOf(primaryContext) + "] does not contain relocation target [" + String.valueOf(this.routingEntry()) + "]";
        String allocationId = this.routingEntry().allocationId().getId();
        if (this.isRemoteStoreEnabled() || this.isMigratingToRemote()) {
            allocationId = primaryContext.getRoutingTable().primaryShard().allocationId().getId();
        }
        assert (this.getLocalCheckpoint() == ((ReplicationTracker.CheckpointState)primaryContext.getCheckpointStates().get(allocationId)).getLocalCheckpoint() || this.indexSettings().getTranslogDurability() == TranslogSettings.Durability.ASYNC) : "local checkpoint [" + this.getLocalCheckpoint() + "] does not match checkpoint from primary context [" + String.valueOf(primaryContext) + "]";
        Object object = this.mutex;
        synchronized (object) {
            this.replicationTracker.activateWithPrimaryContext(primaryContext);
        }
        this.postActivatePrimaryMode();
    }

    private void postActivatePrimaryMode() {
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            try {
                this.getEngine().translogManager().syncTranslog();
            }
            catch (IOException e) {
                this.logger.error("Failed to sync translog to remote from new primary", (Throwable)e);
            }
        }
        this.ensurePeerRecoveryRetentionLeasesExist();
    }

    private void ensurePeerRecoveryRetentionLeasesExist() {
        this.threadPool.generic().execute(() -> this.replicationTracker.createMissingPeerRecoveryRetentionLeases(ActionListenerHelper.wrap(r -> this.logger.trace("created missing peer recovery retention leases"), e -> this.logger.debug("failed creating missing peer recovery retention leases", (Throwable)e))));
    }

    public boolean pendingInSync() {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.pendingInSync();
    }

    public void noopUpdate() {
        this.internalIndexingStats.noopUpdate();
    }

    public void maybeCheckIndex() {
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.isTrue((String)this.checkIndexOnStartup) || "checksum".equals(this.checkIndexOnStartup)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
    }

    void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            catch (IOException e) {
                this.store.markStoreCorrupted(e);
                throw e;
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        long timeNS = System.nanoTime();
        if (!XLucene.indexExists((Directory)this.store.directory())) {
            return;
        }
        try (BytesStreamOutput os = new BytesStreamOutput();
             PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());){
            if ("checksum".equals(this.checkIndexOnStartup)) {
                IOException corrupt = null;
                Store.MetadataSnapshot metadata = this.snapshotStoreMetadata();
                for (Map.Entry entry : metadata.asMap().entrySet()) {
                    try {
                        Store.checkIntegrity((StoreFileMetadata)((StoreFileMetadata)entry.getValue()), (Directory)this.store.directory());
                        out.println("checksum passed: " + (String)entry.getKey());
                    }
                    catch (IOException exc) {
                        out.println("checksum failed: " + (String)entry.getKey());
                        exc.printStackTrace(out);
                        corrupt = exc;
                    }
                }
                out.flush();
                if (corrupt != null) {
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    throw corrupt;
                }
            } else {
                CheckIndex.Status status = this.store.checkIndex(out);
                out.flush();
                if (!status.clean) {
                    if (this.state == IndexShardState.CLOSED) {
                        return;
                    }
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    throw new IOException("index check failure");
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
            }
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS))));
    }

    public void startRecovery(RecoveryState recoveryState, BasePeerRecoveryTargetService recoveryTargetService, RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<MappingMetadata> mappingUpdateConsumer, IndicesService indicesService) {
        this.logger.debug("startRecovery type={}", (Object)recoveryState.getRecoverySource().getType());
        assert (recoveryState.getRecoverySource().equals((Object)this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.executeRecovery("from store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)this::recoverFromStore));
                break;
            }
            case REMOTE_STORE: {
                this.executeRecovery("from remote store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromRemoteStore((ActionListener<Boolean>)l)));
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + String.valueOf(recoveryState.getSourceNode()), recoveryState);
                    recoveryTargetService.startRecovery((BaseIndexShard)this, recoveryState.getSourceNode(), recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onFailure((ReplicationState)recoveryState, (ReplicationFailedException)new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource();
                if (recoverySource.isSearchableSnapshot()) {
                    this.executeRecovery("from snapshot (remote)", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)this::recoverFromStore));
                    break;
                }
                if (recoverySource.remoteStoreIndexShallowCopy()) {
                    String repo = recoverySource.snapshot().getRepository();
                    this.executeRecovery("from snapshot and remote store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromSnapshotAndRemoteStore(repositoriesService.repository(repo), repositoriesService, (ActionListener<Boolean>)l)));
                    break;
                }
                String repo = recoverySource.snapshot().getRepository();
                this.executeRecovery("from snapshot", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromRepository(repositoriesService.repository(repo), (ActionListener<Boolean>)l)));
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                Set requiredShards;
                IndexMetadata indexMetadata = this.indexSettings().getIndexMetadata();
                Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
                ArrayList<BaseIndexShard> startedShards = new ArrayList<BaseIndexShard>();
                IndexService sourceIndexService = indicesService.indexService(resizeSourceIndex);
                if (sourceIndexService != null) {
                    requiredShards = IndexMetadata.selectRecoverFromShards((int)this.shardId().id(), (IndexMetadata)sourceIndexService.getMetadata(), (int)indexMetadata.getNumberOfShards());
                    Iterator<BaseIndexShard> iterator = sourceIndexService.iterator();
                    while (iterator.hasNext()) {
                        BaseIndexShard shard = iterator.next();
                        if (shard.state() != IndexShardState.STARTED || !requiredShards.contains(shard.shardId())) continue;
                        startedShards.add(shard);
                    }
                    numShards = requiredShards.size();
                } else {
                    numShards = -1;
                    requiredShards = Collections.emptySet();
                }
                if (numShards == startedShards.size()) {
                    assert (!requiredShards.isEmpty());
                    this.executeRecovery("from local shards", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> requiredShards.contains(s.shardId())).collect(Collectors.toList()), (ActionListener<Boolean>)l)));
                    break;
                }
                Throwable e = numShards == -1 ? new IndexNotFoundException(resizeSourceIndex) : new IllegalStateException("not all required shards of index " + String.valueOf(resizeSourceIndex) + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + String.valueOf(this.shardId()));
                throw e;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + String.valueOf(recoveryState.getRecoverySource()));
            }
        }
    }

    private void executeRecovery(String reason, RecoveryState recoveryState, RecoveryListener recoveryListener, CheckedConsumer<ActionListener<Boolean>, Exception> action) {
        this.markAsRecovering(reason, recoveryState);
        this.threadPool.generic().execute((Runnable)ActionRunnable.wrap((ActionListener)ActionListenerHelper.wrap(r -> {
            if (r.booleanValue()) {
                recoveryListener.onDone((ReplicationState)recoveryState);
            }
        }, e -> recoveryListener.onFailure((ReplicationState)recoveryState, (ReplicationFailedException)new RecoveryFailedException(recoveryState, null, (Throwable)e), true)), action));
    }

    public boolean isRelocatedPrimary() {
        assert (this.shardRouting.primary()) : "only call isRelocatedPrimary on primary shard";
        return this.replicationTracker.isRelocated();
    }

    public RetentionLease addPeerRecoveryRetentionLease(String nodeId, long globalCheckpoint, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        assert (!this.indexSettings.isSoftDeleteEnabled());
        return this.replicationTracker.addPeerRecoveryRetentionLease(nodeId, globalCheckpoint, listener);
    }

    public RetentionLease cloneLocalPeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.cloneLocalPeerRecoveryRetentionLease(nodeId, listener);
    }

    public void removePeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.removePeerRecoveryRetentionLease(nodeId, listener);
    }

    public List<RetentionLease> getPeerRecoveryRetentionLeases() {
        return this.replicationTracker.getPeerRecoveryRetentionLeases();
    }

    public boolean useRetentionLeasesInPeerRecovery() {
        return this.useRetentionLeasesInPeerRecovery;
    }

    private static void persistMetadata(ShardPath shardPath, IndexSettings indexSettings, ShardRouting newRouting, @Nullable ShardRouting currentRouting, Logger logger) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        ShardId shardId = newRouting.shardId();
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals((Object)newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            String writeReason = currentRouting == null ? "initial state with allocation id [" + String.valueOf(newRouting.allocationId()) + "]" : "routing changed from " + String.valueOf(currentRouting) + " to " + String.valueOf(newRouting);
            logger.trace("{} writing shard state, reason [{}]", (Object)shardId, (Object)writeReason);
            ShardStateMetadata.IndexDataLocation indexDataLocation = IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.exists(indexSettings.getSettings()) ? ShardStateMetadata.IndexDataLocation.REMOTE : ShardStateMetadata.IndexDataLocation.LOCAL;
            ShardStateMetadata newShardStateMetadata = new ShardStateMetadata(newRouting.primary(), indexSettings.getUUID(), newRouting.allocationId(), indexDataLocation);
            ShardStateMetadata.FORMAT.writeAndCleanup((Object)newShardStateMetadata, new Path[]{shardPath.getShardStatePath()});
        } else {
            logger.trace("{} skip writing shard state, has been written before", (Object)shardId);
        }
    }

    public static Analyzer buildIndexAnalyzer(final MapperService mapperService) {
        if (mapperService == null) {
            return null;
        }
        return new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return mapperService.indexAnalyzer(fieldName, f -> {
                    throw new IllegalArgumentException("Field [" + fieldName + "] has no associated analyzer");
                });
            }
        };
    }

    private EngineConfig newEngineConfig(LongSupplier globalCheckpointSupplier) throws IOException {
        boolean isReadOnlyReplica;
        Sort indexSort = (Sort)this.indexSortSupplier.get();
        BaseEngine.Warmer warmer = reader -> {
            assert (!Thread.holdsLock(this.mutex)) : "warming engine under mutex";
            assert (reader != null);
            if (this.warmer != null) {
                this.warmer.warm(reader);
            }
        };
        this.internalRefreshListener.clear();
        this.internalRefreshListener.add(new RefreshMetricUpdater(this.refreshMetric));
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            this.internalRefreshListener.add(new ReplicationCheckpointUpdater());
        }
        if (this.checkpointPublisher != null && this.shardRouting.primary() && this.indexSettings.isSegRepLocalEnabled()) {
            this.internalRefreshListener.add(new CheckpointRefreshListener(this, this.checkpointPublisher));
        }
        if (this.isRemoteStoreEnabled() || this.isMigratingToRemote()) {
            this.internalRefreshListener.add(new RemoteStoreRefreshListener(this, this.checkpointPublisher, this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(this.shardId()), this.remoteStoreSettings));
        }
        boolean bl = isReadOnlyReplica = this.indexSettings.isSegRepEnabledOrRemoteNode() && (!this.shardRouting.primary() || this.shardRouting.isRelocationTarget() && this.recoveryState.getStage() != RecoveryState.Stage.FINALIZE);
        if (this.shouldSeedRemoteStore()) {
            isReadOnlyReplica = false;
        }
        return this.engineConfigFactory.newEngineConfig(this.shardId, this.threadPool, this.indexSettings, warmer, this.store, this.indexSettings.getMergePolicy(this.isTimeSeriesIndex), IndexShard.buildIndexAnalyzer(this.mapperService), this.similarityService.similarity(this.mapperService == null ? null : arg_0 -> ((MapperService)this.mapperService).fieldType(arg_0)), this.engineConfigFactory.newCodecServiceOrDefault(this.indexSettings, this.mapperService, this.logger, this.codecService), this.shardEventListener, (QueryCache)(this.indexCache != null ? this.indexCache.query() : null), this.cachingPolicy, this.translogConfig, (TimeValue)IndicesMemorySettings.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), Arrays.asList(this.refreshListeners, this.refreshPendingLocationListener), this.internalRefreshListener, indexSort, this.circuitBreakerService, globalCheckpointSupplier, () -> ((ReplicationTracker)this.replicationTracker).getRetentionLeases(), this::getOperationPrimaryTerm, isReadOnlyReplica, () -> ((IndexShard)this).enableUploadToRemoteTranslog(), this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting), this.isTimeSeriesDescSortOptimizationEnabled() ? DataStream.TIMESERIES_LEAF_SORTER : null);
    }

    private boolean isRemoteStoreEnabled() {
        return this.remoteStore != null && this.shardRouting.primary();
    }

    public boolean isTimeSeriesDescSortOptimizationEnabled() {
        return this.isTimeSeriesIndex && this.getIndexSort() == null;
    }

    public boolean isRemoteSnapshot() {
        return this.indexSettings != null && this.indexSettings.isRemoteSnapshot();
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.acquirePrimaryOperationPermit(onPermitAcquired, executorOnDelay, debugInfo, false);
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo, boolean forceExecution) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquirePrimaryOperationPermit should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.indexShardOperationPermits.acquire(this.wrapPrimaryOperationPermitListener(onPermitAcquired), executorOnDelay, forceExecution, debugInfo);
    }

    public void acquireAllPrimaryOperationsPermits(ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquireAllPrimaryOperationsPermits should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.asyncBlockOperations(this.wrapPrimaryOperationPermitListener(onPermitAcquired), timeout.duration(), timeout.timeUnit());
    }

    private ActionListener<Releasable> wrapPrimaryOperationPermitListener(ActionListener<Releasable> listener) {
        return ActionListenerHelper.delegateFailure(listener, (l, r) -> {
            if (this.replicationTracker.isPrimaryMode()) {
                l.onResponse(r);
            } else {
                r.close();
                l.onFailure((Exception)new ShardNotInPrimaryModeException(this.shardId, this.state));
            }
        });
    }

    private void asyncBlockOperations(ActionListener<Releasable> onPermitAcquired, long timeout, TimeUnit timeUnit) {
        Releasable forceRefreshes = this.refreshListeners.forceRefreshes();
        ActionListener wrappedListener = ActionListenerHelper.wrap(r -> {
            forceRefreshes.close();
            onPermitAcquired.onResponse(r);
        }, e -> {
            forceRefreshes.close();
            onPermitAcquired.onFailure(e);
        });
        try {
            this.indexShardOperationPermits.asyncBlockOperations((ActionListener<Releasable>)wrappedListener, timeout, timeUnit);
        }
        catch (Exception e2) {
            forceRefreshes.close();
            throw e2;
        }
    }

    public void runUnderPrimaryPermit(Runnable runnable, Consumer<Exception> onFailure, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "runUnderPrimaryPermit should only be called on primary shard but was " + String.valueOf(this.shardRouting);
        ActionListener onPermitAcquired = ActionListenerHelper.wrap(releasable -> {
            try (Releasable ignore = releasable;){
                runnable.run();
            }
        }, onFailure);
        this.acquirePrimaryOperationPermit((ActionListener<Releasable>)onPermitAcquired, executorOnDelay, debugInfo);
    }

    private <E extends Exception> void bumpPrimaryTerm(final long newPrimaryTerm, final CheckedRunnable<E> onBlocked, final @Nullable ActionListener<Releasable> combineWithAction) {
        assert (Thread.holdsLock(this.mutex));
        assert (newPrimaryTerm > this.pendingPrimaryTerm || newPrimaryTerm >= this.pendingPrimaryTerm && combineWithAction != null);
        assert (this.getOperationPrimaryTerm() <= this.pendingPrimaryTerm);
        final CountDownLatch termUpdated = new CountDownLatch(1);
        this.asyncBlockOperations(new ActionListener<Releasable>(){

            public void onFailure(Exception e) {
                try {
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onFailure(e);
                    }
                }
            }

            private void innerFail(Exception e) {
                try {
                    IndexShard.this.failShard("exception during primary term transition", e);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Releasable releasable) {
                RunOnce releaseOnce = new RunOnce(() -> ((Releasable)releasable).close());
                try {
                    assert (IndexShard.this.getOperationPrimaryTerm() <= IndexShard.this.pendingPrimaryTerm);
                    termUpdated.await();
                    if (IndexShard.this.getOperationPrimaryTerm() < newPrimaryTerm) {
                        IndexShard.this.replicationTracker.setOperationPrimaryTerm(newPrimaryTerm);
                        onBlocked.run();
                    }
                }
                catch (Exception e) {
                    if (combineWithAction == null) {
                        releaseOnce.run();
                    }
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onResponse((Object)releasable);
                    } else {
                        releaseOnce.run();
                    }
                }
            }
        }, 30L, TimeUnit.MINUTES);
        this.pendingPrimaryTerm = newPrimaryTerm;
        termUpdated.countDown();
    }

    public void acquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, false, listener -> this.indexShardOperationPermits.acquire((ActionListener<Releasable>)listener, executorOnDelay, true, debugInfo));
    }

    public void acquireAllReplicaOperationsPermits(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, true, listener -> this.asyncBlockOperations((ActionListener<Releasable>)listener, timeout.duration(), timeout.timeUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAcquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, boolean allowCombineOperationWithPrimaryTermUpdate, Consumer<ActionListener<Releasable>> operationExecutor) {
        this.verifyNotClosed();
        ActionListener operationListener = ActionListenerHelper.delegateFailure(onPermitAcquired, (delegatedListener, releasable) -> {
            if (opPrimaryTerm < this.getOperationPrimaryTerm()) {
                releasable.close();
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.shardId, opPrimaryTerm, this.getOperationPrimaryTerm());
                delegatedListener.onFailure((Exception)new IllegalStateException(message));
            } else {
                assert (this.assertReplicationTarget());
                try {
                    this.updateGlobalCheckpointOnReplica(globalCheckpoint, "operation");
                    this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
                }
                catch (Exception e) {
                    releasable.close();
                    delegatedListener.onFailure(e);
                    return;
                }
                delegatedListener.onResponse(releasable);
            }
        });
        if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
                    IndexShardState shardState = this.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, shardState);
                    }
                    this.bumpPrimaryTerm(opPrimaryTerm, () -> {
                        this.updateGlobalCheckpointOnReplica(globalCheckpoint, "primary term transition");
                        long currentGlobalCheckpoint = this.getLastKnownGlobalCheckpoint();
                        long maxSeqNo = this.seqNoStats().getMaxSeqNo();
                        this.logger.info("detected new primary with primary term [{}], global checkpoint [{}], max_seq_no [{}]", (Object)opPrimaryTerm, (Object)currentGlobalCheckpoint, (Object)maxSeqNo);
                        if (currentGlobalCheckpoint < maxSeqNo && !this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                            this.resetEngineToGlobalCheckpoint();
                        } else {
                            this.getEngine().translogManager().rollTranslogGeneration();
                        }
                    }, (ActionListener<Releasable>)(allowCombineOperationWithPrimaryTermUpdate ? operationListener : null));
                    if (allowCombineOperationWithPrimaryTermUpdate) {
                        this.logger.debug("operation execution has been combined with primary term update");
                        return;
                    }
                }
            }
        }
        assert (opPrimaryTerm <= this.pendingPrimaryTerm) : "operation primary term [" + opPrimaryTerm + "] should be at most [" + this.pendingPrimaryTerm + "]";
        operationExecutor.accept((ActionListener<Releasable>)operationListener);
    }

    private boolean requirePrimaryTermUpdate(long opPrimaryTerm, boolean allPermits) {
        return opPrimaryTerm > this.pendingPrimaryTerm || allPermits && opPrimaryTerm > this.getOperationPrimaryTerm();
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationPermits.getActiveOperationsCount();
    }

    public List<String> getActiveOperations() {
        return this.indexShardOperationPermits.getActiveOperations();
    }

    private static AsyncIOProcessor<TranslogLocation> createTranslogSyncProcessor(Logger logger, ThreadPool threadPool, Supplier<Engine> engineSupplier, boolean bufferAsyncIoProcessor, Supplier<TimeValue> bufferIntervalSupplier) {
        assert (!bufferAsyncIoProcessor || Objects.nonNull(bufferIntervalSupplier)) : "If bufferAsyncIoProcessor is true, then the bufferIntervalSupplier needs to be non null";
        ThreadContext threadContext = threadPool.getThreadContext();
        final CheckedConsumer writeConsumer = candidates -> {
            try {
                ((Engine)engineSupplier.get()).translogManager().ensureTranslogSynced(candidates.stream().map(Tuple::v1));
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (IOException ex) {
                logger.debug("failed to sync translog", (Throwable)ex);
                throw ex;
            }
        };
        if (bufferAsyncIoProcessor) {
            return new BufferedAsyncIOProcessor<TranslogLocation>(logger, 102400, threadContext, threadPool, bufferIntervalSupplier){

                protected void write(List<Tuple<TranslogLocation, Consumer<Exception>>> candidates) throws IOException {
                    writeConsumer.accept(candidates);
                }

                protected String getBufferProcessThreadPoolName() {
                    return "translog_sync";
                }
            };
        }
        return new AsyncIOProcessor<TranslogLocation>(logger, 1024, threadContext){

            protected void write(List<Tuple<TranslogLocation, Consumer<Exception>>> candidates) throws IOException {
                writeConsumer.accept(candidates);
            }
        };
    }

    public final void sync(TranslogLocation location, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.translogSyncProcessor.put((Object)location, syncListener);
    }

    public void sync() throws IOException {
        this.verifyNotClosed();
        this.getEngine().translogManager().syncTranslog();
    }

    public boolean isSyncNeeded() {
        return this.getEngine().translogManager().isTranslogSyncNeeded();
    }

    public TranslogSettings.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public void afterWriteOperation() {
        if ((this.shouldPeriodicallyFlush() || this.shouldRollTranslogGeneration()) && this.flushOrRollRunning.compareAndSet(false, true)) {
            if (this.shouldPeriodicallyFlush()) {
                this.logger.debug("submitting async flush request");
                AbstractRunnable flush = new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                        }
                    }

                    public void doRun() throws IOException {
                        IndexShard.this.flush(new FlushRequest(new String[0]));
                        IndexShard.this.periodicFlushMetric.inc();
                    }

                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute((Runnable)flush);
            } else if (this.shouldRollTranslogGeneration()) {
                this.logger.debug("submitting async roll translog generation request");
                AbstractRunnable roll = new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to roll translog generation", (Throwable)e);
                        }
                    }

                    public void doRun() throws Exception {
                        IndexShard.this.rollTranslogGeneration();
                    }

                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute((Runnable)roll);
            } else {
                this.flushOrRollRunning.compareAndSet(true, false);
            }
        }
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    EngineConfigFactory getEngineConfigFactory() {
        return this.engineConfigFactory;
    }

    public boolean scheduledRefresh() {
        this.verifyNotClosed();
        boolean listenerNeedsRefresh = this.refreshListeners.refreshNeeded();
        if (this.isReadAllowed() && (listenerNeedsRefresh || this.getEngine().refreshNeeded())) {
            if (!listenerNeedsRefresh && this.isSearchIdleSupported() && this.isSearchIdle() && !this.indexSettings.isExplicitRefresh() && this.active.get()) {
                Engine engine = this.getEngine();
                engine.maybePruneDeletes();
                this.setRefreshPending(engine);
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("refresh with source [schedule]");
            }
            return this.getEngine().maybeRefresh("schedule");
        }
        Engine engine = this.getEngine();
        engine.maybePruneDeletes();
        return false;
    }

    public final boolean isSearchIdle() {
        return this.threadPool.relativeTimeInMillis() - this.lastSearcherAccess.get() >= this.indexSettings.getSearchIdleAfter().getMillis();
    }

    public final boolean isSearchIdleSupported() {
        if (this.isRemoteTranslogEnabled() || this.indexSettings.isAssignedOnRemoteNode()) {
            return false;
        }
        return !this.indexSettings.isSegRepEnabledOrRemoteNode() || this.indexSettings.getNumberOfReplicas() == 0;
    }

    final long getLastSearcherAccess() {
        return this.lastSearcherAccess.get();
    }

    public final boolean hasRefreshPending() {
        return this.pendingRefreshLocation.get() != null;
    }

    private void setRefreshPending(Engine engine) {
        TranslogLocation lastWriteLocation = engine.translogManager().getTranslogLastWriteLocation();
        this.pendingRefreshLocation.updateAndGet(curr -> {
            if (curr == null || curr.compareTo(lastWriteLocation) <= 0) {
                return lastWriteLocation;
            }
            return curr;
        });
    }

    private void updateReplicationCheckpoint() {
        Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> tuple = this.getLatestSegmentInfosAndCheckpoint();
        try (GatedCloseable ignored = (GatedCloseable)tuple.v1();){
            this.replicationTracker.setLatestReplicationCheckpoint((ReplicationCheckpoint)tuple.v2());
        }
        catch (IOException e) {
            throw new SkyliteException("Error Closing SegmentInfos Snapshot", (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEngineToGlobalCheckpoint() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "resetting engine under mutex";
        assert (this.getActiveOperationsCount() == -1) : "resetting engine without blocking operations; active operations are [" + String.valueOf(this.getActiveOperations()) + "]";
        this.sync();
        SeqNoStats seqNoStats = this.seqNoStats();
        TranslogStats translogStats = this.translogStats();
        this.flush(new FlushRequest(new String[0]).waitIfOngoing(true));
        final SetOnce newEngineReference = new SetOnce();
        long globalCheckpoint = this.getLastKnownGlobalCheckpoint();
        assert (globalCheckpoint == this.getLastSyncedGlobalCheckpoint());
        Object object = this.engineMutex;
        synchronized (object) {
            this.verifyNotClosed();
            ReadOnlyEngine readOnlyEngine = new ReadOnlyEngine(this.newEngineConfig((LongSupplier)this.replicationTracker), seqNoStats, translogStats, false, Function.identity(), true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireLastIndexCommit(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GatedCloseable<IndexCommit> acquireSafeIndexCommit() {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireSafeIndexCommit();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).getSegmentInfosSnapshot();
                    }
                }

                public void close() throws IOException {
                    assert (Thread.holdsLock(IndexShard.this.engineMutex));
                    Engine newEngine = (Engine)newEngineReference.get();
                    if (newEngine == IndexShard.this.currentEngineReference.get()) {
                        newEngine = null;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), newEngine});
                }
            };
            IOUtils.close((Closeable)((Closeable)((Object)this.currentEngineReference.getAndSet(readOnlyEngine))));
            if (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded()) {
                this.syncSegmentsFromRemoteSegmentStore(false);
            }
            if ((this.indexSettings.isRemoteTranslogStoreEnabled() || this.isRemoteSeeded()) && this.shardRouting.primary()) {
                this.syncRemoteTranslogAndUpdateGlobalCheckpoint();
            }
            newEngineReference.set((Object)this.engineFactory.newReadWriteEngine(this.newEngineConfig((LongSupplier)this.replicationTracker)));
            this.onNewEngine((Engine)newEngineReference.get());
        }
        TranslogRecoveryRunner translogRunner = snapshot -> this.runTranslogRecovery((Engine)newEngineReference.get(), snapshot, EngineOperation.Origin.LOCAL_RESET, () -> {});
        long recoverUpto = this.isRemoteTranslogEnabled() || this.indexSettings().isSegRepEnabledOrRemoteNode() ? Long.MAX_VALUE : globalCheckpoint;
        ((Engine)newEngineReference.get()).translogManager().recoverFromTranslog(translogRunner, ((Engine)newEngineReference.get()).getProcessedLocalCheckpoint(), recoverUpto);
        ((Engine)newEngineReference.get()).refresh("reset_engine");
        Object object2 = this.engineMutex;
        synchronized (object2) {
            this.verifyNotClosed();
            IOUtils.close((Closeable)((Closeable)this.currentEngineReference.getAndSet((Engine)newEngineReference.get())));
            this.active.set(true);
        }
        this.onSettingsChanged();
    }

    private void syncRemoteTranslogAndUpdateGlobalCheckpoint() throws IOException {
        this.syncTranslogFilesFromRemoteTranslog();
        this.loadGlobalCheckpointToReplicationTracker();
    }

    public void deleteTranslogFilesFromRemoteTranslog() throws IOException {
        TranslogFactory translogFactory = this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting);
        assert (translogFactory instanceof RemoteBlobStoreInternalTranslogFactory);
        Repository repository = ((RemoteBlobStoreInternalTranslogFactory)translogFactory).getRepository();
        RemoteFsTranslog.cleanup(repository, this.shardId, this.getThreadPool(), this.indexSettings.getRemoteStorePathStrategy(), this.remoteStoreSettings, this.indexSettings().isTranslogMetadataEnabled());
    }

    public void deleteRemoteStoreContents() throws IOException {
        this.deleteTranslogFilesFromRemoteTranslog();
        this.getRemoteDirectory().deleteStaleSegments(0);
    }

    public void syncTranslogFilesFromRemoteTranslog() throws IOException {
        TranslogFactory translogFactory = this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting);
        assert (translogFactory instanceof RemoteBlobStoreInternalTranslogFactory);
        Repository repository = ((RemoteBlobStoreInternalTranslogFactory)translogFactory).getRepository();
        RemoteFsTranslog.download(repository, this.shardId, this.getThreadPool(), this.shardPath().resolveTranslog(), this.indexSettings.getRemoteStorePathStrategy(), this.remoteStoreSettings, this.logger, this.shouldSeedRemoteStore(), this.indexSettings().isTranslogMetadataEnabled());
    }

    public void syncSegmentsFromRemoteSegmentStore(boolean overrideLocal) throws IOException {
        this.syncSegmentsFromRemoteSegmentStore(overrideLocal, () -> {});
    }

    public void syncSegmentsFromRemoteSegmentStore(boolean overrideLocal, Runnable onFileSync) throws IOException {
        boolean syncSegmentSuccess = false;
        long startTimeMs = System.currentTimeMillis();
        assert (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded());
        this.logger.trace("Downloading segments from remote segment store");
        RemoteSegmentStoreDirectory remoteDirectory = this.getRemoteDirectory();
        RemoteSegmentMetadata remoteSegmentMetadata = remoteDirectory.init();
        Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegments = remoteDirectory.getSegmentsUploadedToRemoteStore().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("segments")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.store.incRef();
        this.remoteStore.incRef();
        try {
            Directory storeDirectory;
            if (this.recoveryState.getStage() == RecoveryState.Stage.INDEX) {
                storeDirectory = new BaseStoreRecovery.StatsDirectoryWrapper(this.store.directory(), this.recoveryState.getIndex());
                for (String file : uploadedSegments.keySet()) {
                    long checksum = Long.parseLong(uploadedSegments.get(file).getChecksum());
                    if (overrideLocal || !this.localDirectoryContains(storeDirectory, file, checksum)) {
                        this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), false);
                        continue;
                    }
                    this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), true);
                }
            } else {
                storeDirectory = this.store.directory();
            }
            this.copySegmentFiles(storeDirectory, remoteDirectory, null, uploadedSegments, overrideLocal, onFileSync);
            if (remoteSegmentMetadata != null) {
                SegmentInfos infosSnapshot = this.store.buildSegmentInfos(remoteSegmentMetadata.getSegmentInfosBytes(), remoteSegmentMetadata.getGeneration());
                long processedLocalCheckpoint = Long.parseLong((String)infosSnapshot.getUserData().get("local_checkpoint"));
                for (String file : List.of(this.store.directory().listAll())) {
                    if (!file.startsWith("segments")) continue;
                    this.store.deleteQuiet(new String[]{file});
                }
                assert (Arrays.stream(this.store.directory().listAll()).filter(f -> f.startsWith("segments")).findAny().isEmpty()) : "There should not be any segments file in the dir";
                this.store.commitSegmentInfos(infosSnapshot, processedLocalCheckpoint, processedLocalCheckpoint);
            }
            syncSegmentSuccess = true;
        }
        catch (IOException e) {
            throw new IndexShardRecoveryException(this.shardId, "Exception while copying segment files from remote segment store", (Throwable)e);
        }
        finally {
            this.logger.trace("syncSegmentsFromRemoteSegmentStore success={} elapsedTime={}", (Object)syncSegmentSuccess, (Object)(System.currentTimeMillis() - startTimeMs));
            this.store.decRef();
            this.remoteStore.decRef();
        }
    }

    public void syncSegmentsFromGivenRemoteSegmentStore(boolean overrideLocal, RemoteSegmentStoreDirectory sourceRemoteDirectory, long primaryTerm, long commitGeneration) throws IOException {
        block14: {
            this.logger.trace("Downloading segments from given remote segment store");
            RemoteSegmentStoreDirectory remoteDirectory = null;
            if (this.remoteStore != null) {
                remoteDirectory = this.getRemoteDirectory();
                remoteDirectory.init();
                this.remoteStore.incRef();
            }
            Map uploadedSegments = sourceRemoteDirectory.getSegmentsUploadedToRemoteStore();
            Directory storeDirectory = this.store.directory();
            this.store.incRef();
            try {
                String segmentsNFile = this.copySegmentFiles(storeDirectory, sourceRemoteDirectory, remoteDirectory, uploadedSegments, overrideLocal, () -> {});
                if (segmentsNFile == null) break block14;
                try (BufferedChecksumIndexInput indexInput = new BufferedChecksumIndexInput(storeDirectory.openInput(segmentsNFile, IOContext.READONCE));){
                    SegmentInfos infosSnapshot = SegmentInfos.readCommit((Directory)this.store.directory(), (ChecksumIndexInput)indexInput, (long)commitGeneration);
                    long processedLocalCheckpoint = Long.parseLong((String)infosSnapshot.getUserData().get("local_checkpoint"));
                    if (this.remoteStore != null) {
                        this.store.commitSegmentInfos(infosSnapshot, processedLocalCheckpoint, processedLocalCheckpoint);
                    } else {
                        this.store.directory().sync(infosSnapshot.files(true));
                        this.store.directory().syncMetaData();
                    }
                }
            }
            catch (IOException e) {
                throw new IndexShardRecoveryException(this.shardId, "Exception while copying segment files from remote segment store", (Throwable)e);
            }
            finally {
                this.store.decRef();
                if (this.remoteStore != null) {
                    this.remoteStore.decRef();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copySegmentFiles(Directory storeDirectory, RemoteSegmentStoreDirectory sourceRemoteDirectory, RemoteSegmentStoreDirectory targetRemoteDirectory, Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegments, boolean overrideLocal, Runnable onFileSync) throws IOException {
        String segmentNFile;
        block11: {
            HashSet<String> toDownloadSegments = new HashSet<String>();
            HashSet<String> skippedSegments = new HashSet<String>();
            segmentNFile = null;
            try {
                if (overrideLocal) {
                    for (String file : storeDirectory.listAll()) {
                        storeDirectory.deleteFile(file);
                    }
                }
                for (String file : uploadedSegments.keySet()) {
                    long checksum = Long.parseLong(uploadedSegments.get(file).getChecksum());
                    if (overrideLocal || !this.localDirectoryContains(storeDirectory, file, checksum)) {
                        toDownloadSegments.add(file);
                    } else {
                        skippedSegments.add(file);
                    }
                    if (!file.startsWith("segments")) continue;
                    assert (segmentNFile == null) : "There should be only one SegmentInfosSnapshot file";
                    segmentNFile = file;
                }
                if (toDownloadSegments.isEmpty()) break block11;
                try {
                    this.fileDownloader.download((Directory)sourceRemoteDirectory, storeDirectory, (Directory)targetRemoteDirectory, toDownloadSegments, onFileSync);
                }
                catch (Exception e) {
                    throw new IOException("Error occurred when downloading segments from remote store", e);
                }
            }
            finally {
                this.logger.trace("Downloaded segments here: {}", toDownloadSegments);
                this.logger.trace("Skipped download for segments here: {}", skippedSegments);
            }
        }
        return segmentNFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean localDirectoryContains(Directory localDirectory, String file, long checksum) throws IOException {
        try (IndexInput indexInput = localDirectory.openInput(file, IOContext.READONCE);){
            if (checksum == CodecUtil.retrieveChecksum((IndexInput)indexInput)) {
                boolean bl = true;
                return bl;
            }
            this.logger.warn("Checksum mismatch between local and remote segment file: {}, will override local file", (Object)file);
            if (!this.isReadAllowed()) {
                localDirectory.deleteFile(file);
                return false;
            }
            this.failShard("Local copy of segment " + file + " has a different checksum than the version in remote store", null);
            return false;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.debug("File {} does not exist in local FS, downloading from remote store", (Object)file);
            return false;
        }
        catch (IOException e) {
            this.logger.warn("Exception while reading checksum of file: {}, this can happen if file is corrupted", (Object)file);
            localDirectory.deleteFile(file);
        }
        return false;
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.getEngine().getMaxSeqNoOfUpdatesOrDeletes();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long seqNo) {
        this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    public void verifyShardBeforeIndexClosing() throws IllegalStateException {
        this.getEngine().verifyEngineBeforeIndexClosing();
    }

    RetentionLeaseSyncer getRetentionLeaseSyncer() {
        return this.retentionLeaseSyncer;
    }

    public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        return this.getEngine().getSegmentInfosSnapshot();
    }

    private TimeValue getRemoteTranslogUploadBufferInterval(Supplier<TimeValue> clusterRemoteTranslogBufferIntervalSupplier) {
        assert (Objects.nonNull(clusterRemoteTranslogBufferIntervalSupplier)) : "remote translog buffer interval supplier is null";
        if (this.indexSettings().isRemoteTranslogBufferIntervalExplicit()) {
            return this.indexSettings().getRemoteTranslogUploadBufferInterval();
        }
        return clusterRemoteTranslogBufferIntervalSupplier.get();
    }

    public AsyncIOProcessor<TranslogLocation> getTranslogSyncProcessor() {
        return this.translogSyncProcessor;
    }

    class ShardEventListener
    implements BaseEngine.EventListener {
        private final CopyOnWriteArrayList<Consumer<BaseIndexShard.ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        public void onFailedEngine(String reason, @Nullable Exception failure) {
            BaseIndexShard.ShardFailure shardFailure = new BaseIndexShard.ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Consumer<BaseIndexShard.ShardFailure> listener : this.delegates) {
                try {
                    listener.accept(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }

    private class RefreshPendingLocationListener
    implements ReferenceManager.RefreshListener {
        TranslogLocation lastWriteLocation;

        private RefreshPendingLocationListener() {
        }

        public void beforeRefresh() {
            try {
                this.lastWriteLocation = IndexShard.this.getEngine().translogManager().getTranslogLastWriteLocation();
            }
            catch (AlreadyClosedException exc) {
                this.lastWriteLocation = null;
            }
        }

        public void afterRefresh(boolean didRefresh) {
            if (didRefresh && this.lastWriteLocation != null) {
                IndexShard.this.pendingRefreshLocation.updateAndGet(pendingLocation -> {
                    if (pendingLocation == null || pendingLocation.compareTo(this.lastWriteLocation) <= 0) {
                        return null;
                    }
                    return pendingLocation;
                });
            }
        }
    }

    private static final class NonClosingReaderWrapper
    extends FilterDirectoryReader {
        private NonClosingReaderWrapper(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return reader;
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NonClosingReaderWrapper(in);
        }

        protected void doClose() throws IOException {
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class RefreshMetricUpdater
    implements ReferenceManager.RefreshListener {
        private final MeanMetric refreshMetric;
        private long currentRefreshStartTime;
        private Thread callingThread = null;

        private RefreshMetricUpdater(MeanMetric refreshMetric) {
            this.refreshMetric = refreshMetric;
        }

        public void beforeRefresh() throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread == null) : "beforeRefresh was called by " + this.callingThread.getName() + " without a corresponding call to afterRefresh";
                this.callingThread = Thread.currentThread();
            }
            this.currentRefreshStartTime = System.nanoTime();
        }

        public void afterRefresh(boolean didRefresh) {
            if (Assertions.ENABLED) {
                assert (this.callingThread != null) : "afterRefresh called but not beforeRefresh";
                assert (this.callingThread == Thread.currentThread()) : "beforeRefreshed called by a different thread. current [" + Thread.currentThread().getName() + "], thread that called beforeRefresh [" + this.callingThread.getName() + "]";
                this.callingThread = null;
            }
            this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        }
    }

    private class ReplicationCheckpointUpdater
    implements ReferenceManager.RefreshListener {
        private ReplicationCheckpointUpdater() {
        }

        public void beforeRefresh() throws IOException {
        }

        public void afterRefresh(boolean didRefresh) throws IOException {
            if (didRefresh) {
                IndexShard.this.updateReplicationCheckpoint();
            }
        }
    }
}

