/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import io.skylite.common.util.io.IOUtils;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.indices.cluster.AllocatedIndicesInterface;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class FileCacheCleaner
implements IndexEventListener {
    private static final Logger log = LogManager.getLogger(FileCacheCleaner.class);
    private final NodeEnvironment nodeEnvironment;
    private final FileCache fileCache;

    public FileCacheCleaner(NodeEnvironment nodeEnvironment, FileCache fileCache) {
        this.nodeEnvironment = nodeEnvironment;
        this.fileCache = fileCache;
    }

    public void beforeIndexShardDeleted(ShardId shardId, Settings settings) {
        block9: {
            try {
                if (!FileCacheCleaner.isRemoteSnapshot(settings)) break block9;
                ShardPath shardPath = ShardPath.loadFileCachePath((NodeEnvironment)this.nodeEnvironment, (ShardId)shardId);
                Path localStorePath = shardPath.getDataPath().resolve("RemoteLocalStore");
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(localStorePath);){
                    for (Path subPath : ds) {
                        this.fileCache.remove(subPath.toRealPath(new LinkOption[0]));
                    }
                }
            }
            catch (IOException ioe) {
                log.error(() -> new ParameterizedMessage("Error removing items from cache during shard deletion {}", (Object)shardId), (Throwable)ioe);
            }
        }
    }

    public void afterIndexShardDeleted(ShardId shardId, Settings settings) {
        if (FileCacheCleaner.isRemoteSnapshot(settings)) {
            Path path = ShardPath.loadFileCachePath((NodeEnvironment)this.nodeEnvironment, (ShardId)shardId).getDataPath();
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    IOUtils.rm((Path[])new Path[]{path});
                }
            }
            catch (IOException e) {
                log.error(() -> new ParameterizedMessage("Failed to delete cache path for shard {}", (Object)shardId), (Throwable)e);
            }
        }
    }

    public void afterIndexRemoved(Index index, IndexSettings indexSettings, AllocatedIndicesInterface.IndexRemovalReason reason) {
        Path indexCachePath;
        if (FileCacheCleaner.isRemoteSnapshot(indexSettings.getSettings()) && reason == AllocatedIndicesInterface.IndexRemovalReason.DELETED && Files.exists(indexCachePath = this.nodeEnvironment.fileCacheNodePath().fileCachePath.resolve(index.getUUID()), new LinkOption[0])) {
            try {
                IOUtils.rm((Path[])new Path[]{indexCachePath});
            }
            catch (IOException e) {
                log.error(() -> new ParameterizedMessage("Failed to delete cache path for index {}", (Object)index), (Throwable)e);
            }
        }
    }

    private static boolean isRemoteSnapshot(Settings settings) {
        return IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(settings.get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey()));
    }
}

