/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.common.lease.Releasable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogException;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogRecoveryRunner;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.TranslogStats;
import java.io.IOException;
import java.util.stream.Stream;

public class NoOpTranslogManager
implements TranslogManager {
    private final TranslogSnapshotIterator emptyTranslogSnapshot;
    private final ReleasableLock readLock;
    private final Runnable ensureOpen;
    private final ShardId shardId;
    private final TranslogStats translogStats;

    public NoOpTranslogManager(ShardId shardId, ReleasableLock readLock, Runnable ensureOpen, TranslogStats translogStats, TranslogSnapshotIterator emptyTranslogSnapshot) throws IOException {
        this.emptyTranslogSnapshot = emptyTranslogSnapshot;
        this.readLock = readLock;
        this.shardId = shardId;
        this.ensureOpen = ensureOpen;
        this.translogStats = translogStats;
    }

    public void rollTranslogGeneration() throws TranslogException {
    }

    public int recoverFromTranslog(TranslogRecoveryRunner translogRecoveryRunner, long localCheckpoint, long recoverUpToSeqNo) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen.run();
            try (TranslogSnapshotIterator snapshot = this.emptyTranslogSnapshot;){
                translogRecoveryRunner.run(snapshot);
            }
            catch (Exception e) {
                throw new TranslogException(this.shardId, "failed to recover from empty translog snapshot", (Throwable)e);
            }
        }
        return this.emptyTranslogSnapshot.totalOperations();
    }

    public boolean isTranslogSyncNeeded() {
        return false;
    }

    public boolean ensureTranslogSynced(Stream<TranslogLocation> locations) {
        return false;
    }

    public void syncTranslog() throws IOException {
    }

    public TranslogStats getTranslogStats() {
        return this.translogStats;
    }

    public TranslogLocation getTranslogLastWriteLocation() {
        return new TranslogLocation(0L, 0L, 0);
    }

    public void trimUnreferencedTranslogFiles() throws TranslogException {
    }

    public boolean shouldRollTranslogGeneration() {
        return false;
    }

    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws TranslogException {
    }

    public void ensureCanFlush() {
    }

    public void setMinSeqNoToKeep(long seqNo) {
    }

    public int restoreLocalHistoryFromTranslog(long processedCheckpoint, TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        return 0;
    }

    public void skipTranslogRecovery() {
    }

    public TranslogOperation readOperation(TranslogLocation location) throws IOException {
        return null;
    }

    public TranslogLocation add(TranslogOperation operation) throws IOException {
        return new TranslogLocation(0L, 0L, 0);
    }

    public TranslogSnapshotIterator newChangesSnapshot(long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        throw new UnsupportedOperationException("Translog snapshot unsupported with no-op translogs");
    }

    public void onDelete() {
    }

    public Releasable drainSync() {
        return () -> {};
    }

    public Translog.TranslogGeneration getTranslogGeneration() {
        return null;
    }
}

