/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.SkyliteWrapperException;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;
import java.util.Objects;

public class RecoverFilesRecoveryException
extends SkyliteException
implements SkyliteWrapperException {
    private final int numberOfFiles;
    private final ByteSizeValue totalFilesSize;

    public RecoverFilesRecoveryException(ShardId shardId, int numberOfFiles, ByteSizeValue totalFilesSize, Throwable cause) {
        super("Failed to transfer [{}] files with total size of [{}]", cause, new Object[]{numberOfFiles, totalFilesSize});
        Objects.requireNonNull(totalFilesSize, "totalFilesSize must not be null");
        this.setShard(shardId);
        this.numberOfFiles = numberOfFiles;
        this.totalFilesSize = totalFilesSize;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public ByteSizeValue totalFilesSize() {
        return this.totalFilesSize;
    }

    public RecoverFilesRecoveryException(StreamInput in) throws IOException {
        super(in);
        this.numberOfFiles = in.readInt();
        this.totalFilesSize = new ByteSizeValue(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.numberOfFiles);
        this.totalFilesSize.writeTo(out);
    }

    public static class Registration
    implements SkyliteExceptionProvider<RecoverFilesRecoveryException> {
        public Class<RecoverFilesRecoveryException> getExceptionClass() {
            return RecoverFilesRecoveryException.class;
        }

        public CheckedFunction<StreamInput, RecoverFilesRecoveryException, IOException> getConstructor() {
            return RecoverFilesRecoveryException::new;
        }

        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        public int getLegacyId() {
            return 42;
        }
    }
}

