/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;

public class ReestablishRecoveryRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final String targetAllocationId;

    public ReestablishRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.targetAllocationId = in.readString();
    }

    public ReestablishRecoveryRequest(long recoveryId, ShardId shardId, String targetAllocationId) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.targetAllocationId);
    }
}

