/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.seqno.ReplicationTracker;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.transport.EmptyTransportResponseHandler;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.indices.recovery.ForceSyncRequest;
import org.opensearch.indices.recovery.RecoveryCleanFilesRequest;
import org.opensearch.indices.recovery.RecoveryFilesInfoRequest;
import org.opensearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.opensearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.opensearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.opensearch.indices.recovery.RetryableTransportClient;
import org.opensearch.indices.replication.RemoteSegmentFileChunkWriter;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private static final Logger logger = LogManager.getLogger(RemoteRecoveryTargetHandler.class);
    private final TransportService transportService;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final TransportRequestOptions translogOpsRequestOptions;
    private final AtomicLong requestSeqNoGenerator = new AtomicLong(0L);
    private final RetryableTransportClient retryableTransportClient;
    private final RemoteSegmentFileChunkWriter fileChunkWriter;
    private final boolean remoteStoreEnabled;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle, boolean remoteStoreEnabled) {
        this.transportService = transportService;
        this.retryableTransportClient = new RetryableTransportClient(transportService, targetNode, recoverySettings.internalActionRetryTimeout(), logger);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkWriter = new RemoteSegmentFileChunkWriter(recoveryId, recoverySettings, this.retryableTransportClient, shardId, "internal:index/shard/recovery/file_chunk", this.requestSeqNoGenerator, onSourceThrottle);
        this.remoteStoreEnabled = remoteStoreEnabled;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/prepare_translog";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryPrepareForTranslogOperationsRequest request = new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, totalTranslogOps);
        Writeable.Reader reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> null);
        if (this.remoteStoreEnabled) {
            this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, this.translogOpsRequestOptions, responseListener, reader);
        } else {
            this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, responseListener, reader);
        }
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/finalize";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFinalizeRecoveryRequest request = new RecoveryFinalizeRecoveryRequest(this.recoveryId, requestSeqNo, this.shardId, globalCheckpoint, trimAboveSeqNo);
        Writeable.Reader reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/finalize", request, responseListener, reader);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", (TransportRequest)new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void indexTranslogOperations(List<TranslogOperation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        String action = "internal:index/shard/recovery/translog_ops";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        Writeable.Reader reader = RecoveryTranslogOperationsResponse::new;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> r.localCheckpoint);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, responseListener, reader);
    }

    @Override
    public void forceSegmentFileSync() {
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/replication/segments_sync", (TransportRequest)new ForceSyncRequest(requestSeqNo, this.recoveryId, this.shardId), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/filesInfo";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFilesInfoRequest request = new RecoveryFilesInfoRequest(this.recoveryId, requestSeqNo, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        Writeable.Reader reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/filesInfo", request, responseListener, reader);
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/clean_files";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryCleanFilesRequest request = new RecoveryCleanFilesRequest(this.recoveryId, requestSeqNo, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint);
        Writeable.Reader reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/clean_files", request, responseListener, reader);
    }

    @Override
    public void cancel() {
        this.retryableTransportClient.cancel();
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        this.fileChunkWriter.writeFileChunk(fileMetadata, position, content, lastChunk, totalTranslogOps, listener);
    }
}

