/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.common.action.ActionListener;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.StepListener;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.Transports;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexCommit;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.RunUnderPrimaryPermit;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;

public class RemoteStorePeerRecoverySourceHandler
extends RecoverySourceHandler {
    public RemoteStorePeerRecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations) {
        super(shard, recoveryTarget, threadPool, request, fileChunkSizeInBytes, maxConcurrentFileChunks, maxConcurrentOperations);
    }

    @Override
    protected void innerRecoveryToTarget(ActionListener<RecoveryResponse> listener, Consumer<Exception> onFailure) throws IOException {
        GatedCloseable<IndexCommit> wrappedSafeCommit;
        StepListener sendFileStep = new StepListener();
        StepListener prepareEngineStep = new StepListener();
        StepListener sendSnapshotStep = new StepListener();
        try {
            wrappedSafeCommit = this.acquireSafeCommit(this.shard);
            this.resources.add(wrappedSafeCommit);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e);
        }
        long startingSeqNo = Long.parseLong((String)((IndexCommit)wrappedSafeCommit.get()).getUserData().get("local_checkpoint")) + 1L;
        this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
        try {
            Releasable releaseStore = this.acquireStore(this.shard.store());
            this.resources.add(releaseStore);
            this.onSendFileStepComplete((StepListener<RecoverySourceHandler.SendFileResult>)sendFileStep, wrappedSafeCommit, releaseStore);
            assert (Transports.assertNotTransportThread((String)(String.valueOf(this) + "[phase1]")));
            this.phase1((IndexCommit)wrappedSafeCommit.get(), startingSeqNo, () -> 0, (ActionListener<RecoverySourceHandler.SendFileResult>)sendFileStep, true);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e);
        }
        assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
        sendFileStep.whenComplete(r -> {
            this.logger.debug("sendFileStep completed");
            assert (Transports.assertNotTransportThread((String)(String.valueOf(this) + "[prepareTargetForTranslog]")));
            this.prepareTargetForTranslog(0, (ActionListener<TimeValue>)prepareEngineStep);
        }, onFailure);
        prepareEngineStep.whenComplete(prepareEngineTime -> {
            this.logger.debug("prepareEngineStep completed");
            assert (Transports.assertNotTransportThread((String)(String.valueOf(this) + "[phase2]")));
            RunUnderPrimaryPermit.run(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
            long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
            sendSnapshotStep.onResponse((Object)new RecoverySourceHandler.SendSnapshotResult(endingSeqNo, 0, TimeValue.ZERO));
        }, onFailure);
        this.finalizeStepAndCompleteFuture(startingSeqNo, (StepListener<RecoverySourceHandler.SendSnapshotResult>)sendSnapshotStep, (StepListener<RecoverySourceHandler.SendFileResult>)sendFileStep, (StepListener<TimeValue>)prepareEngineStep, onFailure);
    }
}

