/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.RetryableAction;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.breaker.CircuitBreakingException;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.SendRequestTransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public final class RetryableTransportClient {
    private final ThreadPool threadPool;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = ConcurrentCollections.newConcurrentMap();
    private volatile boolean isCancelled = false;
    private final TransportService transportService;
    private final TimeValue retryTimeout;
    private final DiscoveryNode targetNode;
    private final Logger logger;

    public RetryableTransportClient(TransportService transportService, DiscoveryNode targetNode, TimeValue retryTimeout, Logger logger) {
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.retryTimeout = retryTimeout;
        this.targetNode = targetNode;
        this.logger = logger;
    }

    public <T extends TransportResponse> void executeRetryableAction(String action, TransportRequest request, ActionListener<T> actionListener, Writeable.Reader<T> reader) {
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.retryTimeout).build();
        this.executeRetryableAction(action, request, options, actionListener, reader);
    }

    public <T extends TransportResponse> void executeRetryableAction(final String action, final TransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener removeListener = ActionListenerHelper.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis((long)200L);
        RetryableAction retryableAction = new RetryableAction<T>(this.logger, this.threadPool, initialDelay, this.retryTimeout, removeListener){

            public void tryAction(ActionListener<T> listener) {
                RetryableTransportClient.this.transportService.sendRequest(RetryableTransportClient.this.targetNode, action, request, options, (TransportResponseHandler)new ActionListenerResponseHandler(listener, reader, "generic"));
            }

            public boolean shouldRetry(Exception e) {
                return RetryableTransportClient.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel((Exception)((Object)new CancellableThreads.ExecutionCancelledException("retryable action was cancelled")));
        }
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("retryable action was cancelled");
        this.threadPool.generic().execute(() -> this.lambda$cancel$1((RuntimeException)((Object)exception)));
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            return cause instanceof CircuitBreakingException || cause instanceof SkyliteRejectedExecutionException;
        }
        return false;
    }

    private /* synthetic */ void lambda$cancel$1(RuntimeException exception) {
        for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
            action.cancel((Exception)exception);
        }
        this.onGoingRetryableActions.clear();
    }
}

