/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.store.StoreFileMetadata;
import java.io.IOException;
import java.util.List;
import org.opensearch.indices.replication.common.SegmentReplicationTransportRequest;

public class GetSegmentFilesRequest
extends SegmentReplicationTransportRequest {
    private final List<StoreFileMetadata> filesToFetch;
    private final ReplicationCheckpoint checkpoint;

    public GetSegmentFilesRequest(StreamInput in) throws IOException {
        super(in);
        this.filesToFetch = in.readList(StoreFileMetadata::new);
        this.checkpoint = new ReplicationCheckpoint(in);
    }

    public GetSegmentFilesRequest(long replicationId, String targetAllocationId, DiscoveryNode targetNode, List<StoreFileMetadata> filesToFetch, ReplicationCheckpoint checkpoint) {
        super(replicationId, targetAllocationId, targetNode);
        this.filesToFetch = filesToFetch;
        this.checkpoint = checkpoint;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.filesToFetch);
        this.checkpoint.writeTo(out);
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public List<StoreFileMetadata> getFilesToFetch() {
        return this.filesToFetch;
    }
}

