/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.transport.TransportService;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.indices.recovery.RetryableTransportClient;
import org.opensearch.indices.replication.CheckpointInfoRequest;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesRequest;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;

public class PrimaryShardReplicationSource
implements SegmentReplicationSource {
    private static final Logger logger = LogManager.getLogger(PrimaryShardReplicationSource.class);
    private final RetryableTransportClient transportClient;
    private final DiscoveryNode sourceNode;
    private final DiscoveryNode targetNode;
    private final String targetAllocationId;
    private final RecoverySettings recoverySettings;

    public PrimaryShardReplicationSource(DiscoveryNode targetNode, String targetAllocationId, TransportService transportService, RecoverySettings recoverySettings, DiscoveryNode sourceNode) {
        this.targetAllocationId = targetAllocationId;
        this.transportClient = new RetryableTransportClient(transportService, sourceNode, recoverySettings.internalActionRetryTimeout(), logger);
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
    }

    @Override
    public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
        Writeable.Reader reader = CheckpointInfoResponse::new;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> r);
        CheckpointInfoRequest request = new CheckpointInfoRequest(replicationId, this.targetAllocationId, this.targetNode, checkpoint);
        this.transportClient.executeRetryableAction("internal:index/shard/replication/get_checkpoint_info", request, responseListener, reader);
    }

    @Override
    public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, BaseIndexShard indexShard, BiConsumer<String, Long> fileProgressTracker, ActionListener<GetSegmentFilesResponse> listener) {
        Writeable.Reader reader = GetSegmentFilesResponse::new;
        ActionListener responseListener = ActionListenerHelper.map(listener, r -> r);
        GetSegmentFilesRequest request = new GetSegmentFilesRequest(replicationId, this.targetAllocationId, this.targetNode, filesToFetch, checkpoint);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build();
        this.transportClient.executeRetryableAction("internal:index/shard/replication/get_segment_files", request, options, responseListener, reader);
    }

    @Override
    public String getDescription() {
        return this.sourceNode.getName();
    }

    @Override
    public void cancel() {
        this.transportClient.cancel();
    }
}

