/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.lucene.store.RateLimiter;
import org.opensearch.indices.recovery.FileChunkRequest;
import org.opensearch.indices.recovery.FileChunkWriter;
import org.opensearch.indices.recovery.RetryableTransportClient;

public final class RemoteSegmentFileChunkWriter
implements FileChunkWriter {
    private final AtomicLong requestSeqNoGenerator;
    private final RetryableTransportClient retryableTransportClient;
    private final ShardId shardId;
    private final RecoverySettings recoverySettings;
    private final long replicationId;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final TransportRequestOptions fileChunkRequestOptions;
    private final Consumer<Long> onSourceThrottle;
    private final String action;

    public RemoteSegmentFileChunkWriter(long replicationId, RecoverySettings recoverySettings, RetryableTransportClient retryableTransportClient, ShardId shardId, String action, AtomicLong requestSeqNoGenerator, Consumer<Long> onSourceThrottle) {
        this.replicationId = replicationId;
        this.recoverySettings = recoverySettings;
        this.retryableTransportClient = retryableTransportClient;
        this.shardId = shardId;
        this.requestSeqNoGenerator = requestSeqNoGenerator;
        this.onSourceThrottle = onSourceThrottle;
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
        this.action = action;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new SkyliteException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        FileChunkRequest request = new FileChunkRequest(this.replicationId, requestSeqNo, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos);
        Writeable.Reader reader = in -> TransportResponse.Empty.INSTANCE;
        this.retryableTransportClient.executeRetryableAction(this.action, request, this.fileChunkRequestOptions, ActionListenerHelper.map(listener, r -> null), reader);
    }

    @Override
    public void cancel() {
        this.retryableTransportClient.cancel();
    }
}

