/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.lucene.store.InputStreamIndexInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.Transports;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.IntSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.FileChunkWriter;
import org.opensearch.indices.recovery.MultiChunkTransfer;

public final class SegmentFileTransferHandler {
    private final Logger logger;
    private final IndexShard shard;
    private final FileChunkWriter chunkWriter;
    private final ThreadPool threadPool;
    private final int chunkSizeInBytes;
    private final int maxConcurrentFileChunks;
    private final DiscoveryNode targetNode;
    private final CancellableThreads cancellableThreads;

    public SegmentFileTransferHandler(IndexShard shard, DiscoveryNode targetNode, FileChunkWriter chunkWriter, Logger logger, ThreadPool threadPool, CancellableThreads cancellableThreads, int fileChunkSizeInBytes, int maxConcurrentFileChunks) {
        this.shard = shard;
        this.targetNode = targetNode;
        this.chunkWriter = chunkWriter;
        this.logger = logger;
        this.threadPool = threadPool;
        this.cancellableThreads = cancellableThreads;
        this.chunkSizeInBytes = fileChunkSizeInBytes;
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
    }

    public MultiChunkTransfer<StoreFileMetadata, FileChunk> createTransfer(final Store store, StoreFileMetadata[] files, final IntSupplier translogOps, ActionListener<Void> listener) {
        ArrayUtil.timSort((Object[])files, Comparator.comparingLong(StoreFileMetadata::length));
        return new MultiChunkTransfer<StoreFileMetadata, FileChunk>(this.logger, this.threadPool.getThreadContext(), listener, this.maxConcurrentFileChunks, Arrays.asList(files)){
            final Deque<byte[]> buffers;
            volatile InputStreamIndexInput currentInput;
            long offset;
            {
                super(logger, threadContext, (ActionListener<Void>)listener, maxConcurrentChunks, sources);
                this.buffers = new ConcurrentLinkedDeque<byte[]>();
                this.currentInput = null;
                this.offset = 0L;
            }

            @Override
            protected void onNewResource(StoreFileMetadata md) throws IOException {
                this.offset = 0L;
                IOUtils.close((Closeable[])new Closeable[]{this.currentInput, () -> {
                    this.currentInput = null;
                }});
                if (!md.name().startsWith("segments")) {
                    final IndexInput indexInput = store.directory().openInput(md.name(), IOContext.DEFAULT);
                    this.currentInput = new InputStreamIndexInput(this, indexInput, md.length()){

                        public void close() throws IOException {
                            IOUtils.close((Closeable[])new Closeable[]{indexInput, () -> super.close()});
                        }
                    };
                }
            }

            private byte[] acquireBuffer() {
                byte[] buffer = this.buffers.pollFirst();
                if (buffer != null) {
                    return buffer;
                }
                return new byte[SegmentFileTransferHandler.this.chunkSizeInBytes];
            }

            @Override
            protected FileChunk nextChunkRequest(StoreFileMetadata md) throws IOException {
                assert (Transports.assertNotTransportThread((String)"read file chunk"));
                SegmentFileTransferHandler.this.cancellableThreads.checkForCancel();
                byte[] buffer = this.acquireBuffer();
                int bytesRead = this.readBytes(md, buffer);
                if (bytesRead == -1) {
                    throw new CorruptIndexException("file truncated; length=" + md.length() + " offset=" + this.offset, md.name());
                }
                boolean lastChunk = this.offset + (long)bytesRead == md.length();
                FileChunk chunk = new FileChunk(md, (BytesReference)new BytesArray(buffer, 0, bytesRead), this.offset, lastChunk, () -> this.buffers.addFirst(buffer));
                this.offset += (long)bytesRead;
                return chunk;
            }

            private int readBytes(StoreFileMetadata md, byte[] buffer) throws IOException {
                if (this.currentInput == null) {
                    try (IndexInput indexInput = store.directory().openInput(md.name(), IOContext.READONCE);){
                        int n;
                        try (InputStreamIndexInput in = new InputStreamIndexInput(indexInput, md.length());){
                            in.skip(this.offset);
                            n = in.read(buffer);
                        }
                        return n;
                    }
                }
                return this.currentInput.read(buffer);
            }

            @Override
            protected void executeChunkRequest(FileChunk request, ActionListener<Void> listener1) {
                SegmentFileTransferHandler.this.cancellableThreads.checkForCancel();
                SegmentFileTransferHandler.this.chunkWriter.writeFileChunk(request.md, request.position, request.content, request.lastChunk, translogOps.getAsInt(), (ActionListener<Void>)ActionListenerHelper.runBefore(listener1, request::close));
            }

            @Override
            protected void handleError(StoreFileMetadata md, Exception e) throws Exception {
                SegmentFileTransferHandler.this.handleErrorOnSendFiles(store, e, new StoreFileMetadata[]{md});
            }

            @Override
            public void close() throws IOException {
                IOUtils.close((Closeable[])new Closeable[]{this.currentInput, () -> {
                    this.currentInput = null;
                }});
            }
        };
    }

    public void handleErrorOnSendFiles(Store store, Exception e, StoreFileMetadata[] mds) throws Exception {
        IOException corruptIndexException = SkyliteExceptionsHelper.unwrapCorruption((Throwable)e);
        assert (Transports.assertNotTransportThread((String)(String.valueOf(this) + "[handle error on send/clean files]")));
        if (corruptIndexException != null) {
            IOException localException = null;
            for (StoreFileMetadata md : mds) {
                this.cancellableThreads.checkForCancel();
                this.logger.debug("checking integrity for file {} after remove corruption exception", (Object)md);
                if (store.checkIntegrityNoException(md)) continue;
                this.logger.warn("{} Corrupted file detected {} checksum mismatch", (Object)this.shard.shardId(), (Object)md);
                if (localException == null) {
                    localException = corruptIndexException;
                }
                this.shard.failShard("error sending files", corruptIndexException);
            }
            if (localException != null) {
                throw localException;
            }
            RemoteTransportException remoteException = new RemoteTransportException("File corruption occurred on recovery but checksums are ok", null);
            remoteException.addSuppressed((Throwable)e);
            this.logger.warn(() -> new ParameterizedMessage("{} Remote file corruption on node {}, recovering {}. local checksum OK", new Object[]{this.shard.shardId(), this.targetNode, mds}), (Throwable)corruptIndexException);
            throw remoteException;
        }
        throw e;
    }

    public static final class FileChunk
    implements MultiChunkTransfer.ChunkRequest,
    Releasable {
        final StoreFileMetadata md;
        final BytesReference content;
        final long position;
        final boolean lastChunk;
        final Releasable onClose;

        FileChunk(StoreFileMetadata md, BytesReference content, long position, boolean lastChunk, Releasable onClose) {
            this.md = md;
            this.content = content;
            this.position = position;
            this.lastChunk = lastChunk;
            this.onClose = onClose;
        }

        @Override
        public boolean lastChunk() {
            return this.lastChunk;
        }

        public void close() {
            this.onClose.close();
        }
    }
}

