/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.replication.common.ReplicationTimer;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.recovery.RetryableTransportClient;
import org.opensearch.indices.replication.CheckpointInfoRequest;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesRequest;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.OngoingSegmentReplications;
import org.opensearch.indices.replication.RemoteSegmentFileChunkWriter;
import org.opensearch.indices.replication.UpdateVisibleCheckpointRequest;
import org.opensearch.indices.replication.common.CopyState;

public class SegmentReplicationSourceService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SegmentReplicationSourceService.class);
    private final RecoverySettings recoverySettings;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final OngoingSegmentReplications ongoingSegmentReplications;

    protected SegmentReplicationSourceService(IndicesService indicesService, TransportService transportService, RecoverySettings recoverySettings, OngoingSegmentReplications ongoingSegmentReplications) {
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        this.ongoingSegmentReplications = ongoingSegmentReplications;
        transportService.registerRequestHandler("internal:index/shard/replication/get_checkpoint_info", "generic", CheckpointInfoRequest::new, (TransportRequestHandler)new CheckpointInfoRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/replication/get_segment_files", "generic", GetSegmentFilesRequest::new, (TransportRequestHandler)new GetSegmentFilesRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/replication/update_visible_checkpoint", "generic", UpdateVisibleCheckpointRequest::new, (TransportRequestHandler)new UpdateVisibleCheckpointRequestHandler());
    }

    public SegmentReplicationSourceService(IndicesService indicesService, TransportService transportService, RecoverySettings recoverySettings) {
        this(indicesService, transportService, recoverySettings, new OngoingSegmentReplications(indicesService, recoverySettings));
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.ongoingSegmentReplications.cancelReplication(removedNode);
            }
        }
        if (event.routingTableChanged()) {
            Iterator<Object> iterator = this.indicesService.iterator();
            while (iterator.hasNext()) {
                BaseIndexService indexService = (BaseIndexService)iterator.next();
                if (!indexService.getIndexSettings().isSegRepEnabledOrRemoteNode()) continue;
                for (BaseIndexShard baseIndexShard : indexService) {
                    IndexShard indexShard = (IndexShard)baseIndexShard;
                    if (!indexShard.routingEntry().primary()) continue;
                    IndexMetadata indexMetadata = indexService.getIndexSettings().getIndexMetadata();
                    HashSet<String> inSyncAllocationIds = new HashSet<String>(indexMetadata.inSyncAllocationIds(indexShard.shardId().id()));
                    if (indexShard.isPrimaryMode()) {
                        Set shardTrackerInSyncIds = indexShard.getReplicationGroup().getInSyncAllocationIds();
                        inSyncAllocationIds.addAll(shardTrackerInSyncIds);
                    }
                    this.ongoingSegmentReplications.clearOutOfSyncIds(indexShard.shardId(), inSyncAllocationIds);
                }
            }
        }
    }

    protected void doStart() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.isDataNode((Settings)clusterService.getSettings())) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    protected void doStop() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.isDataNode((Settings)clusterService.getSettings())) {
            this.indicesService.clusterService().removeListener((ClusterStateListener)this);
        }
    }

    protected void doClose() throws IOException {
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        if (indexShard != null && indexShard.indexSettings().isSegRepEnabledOrRemoteNode()) {
            this.ongoingSegmentReplications.cancel(indexShard, "shard is closed");
        }
    }

    public void shardRoutingChanged(BaseIndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        if (indexShard != null && indexShard.indexSettings().isSegRepEnabledOrRemoteNode() && !oldRouting.primary() && newRouting.primary()) {
            this.ongoingSegmentReplications.cancel(indexShard.routingEntry().allocationId().getId(), "Relocating primary shard.");
        }
    }

    public static class Actions {
        public static final String GET_CHECKPOINT_INFO = "internal:index/shard/replication/get_checkpoint_info";
        public static final String GET_SEGMENT_FILES = "internal:index/shard/replication/get_segment_files";
        public static final String UPDATE_VISIBLE_CHECKPOINT = "internal:index/shard/replication/update_visible_checkpoint";
    }

    private class CheckpointInfoRequestHandler
    implements TransportRequestHandler<CheckpointInfoRequest> {
        private CheckpointInfoRequestHandler() {
        }

        public void messageReceived(CheckpointInfoRequest request, TransportChannel channel, Task task) throws Exception {
            ReplicationTimer timer = new ReplicationTimer();
            timer.start();
            RemoteSegmentFileChunkWriter segmentSegmentFileChunkWriter = new RemoteSegmentFileChunkWriter(request.getReplicationId(), SegmentReplicationSourceService.this.recoverySettings, new RetryableTransportClient(SegmentReplicationSourceService.this.transportService, request.getTargetNode(), SegmentReplicationSourceService.this.recoverySettings.internalActionRetryTimeout(), logger), request.getCheckpoint().getShardId(), "internal:index/shard/replication/file_chunk", new AtomicLong(0L), throttleTime -> {});
            CopyState copyState = SegmentReplicationSourceService.this.ongoingSegmentReplications.prepareForReplication(request, segmentSegmentFileChunkWriter);
            channel.sendResponse((TransportResponse)new CheckpointInfoResponse(copyState.getCheckpoint(), copyState.getMetadataMap(), copyState.getInfosBytes()));
            timer.stop();
            logger.trace((Message)new ParameterizedMessage("[replication id {}] Source node sent checkpoint info [{}] to target node [{}], timing: {}", new Object[]{request.getReplicationId(), copyState.getCheckpoint(), request.getTargetNode().getId(), timer.time()}));
        }
    }

    private class GetSegmentFilesRequestHandler
    implements TransportRequestHandler<GetSegmentFilesRequest> {
        private GetSegmentFilesRequestHandler() {
        }

        public void messageReceived(GetSegmentFilesRequest request, TransportChannel channel, Task task) throws Exception {
            SegmentReplicationSourceService.this.ongoingSegmentReplications.startSegmentCopy(request, (ActionListener<GetSegmentFilesResponse>)new ChannelActionListener(channel, "internal:index/shard/replication/get_segment_files", (TransportRequest)request));
        }
    }

    private class UpdateVisibleCheckpointRequestHandler
    implements TransportRequestHandler<UpdateVisibleCheckpointRequest> {
        private UpdateVisibleCheckpointRequestHandler() {
        }

        public void messageReceived(UpdateVisibleCheckpointRequest request, TransportChannel channel, Task task) throws Exception {
            try {
                IndexService indexService = SegmentReplicationSourceService.this.indicesService.indexServiceSafe(request.getPrimaryShardId().getIndex());
                IndexShard indexShard = (IndexShard)indexService.getShard(request.getPrimaryShardId().id());
                indexShard.updateVisibleCheckpointForShard(request.getTargetAllocationId(), request.getCheckpoint());
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            }
            catch (Exception e) {
                channel.sendResponse(e);
            }
        }
    }
}

