/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.replication.ReplicationTask;
import io.skylite.core.action.support.replication.ReplicationMode;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.ShardNotInPrimaryModeException;
import io.skylite.core.indices.replication.checkpoint.PublishCheckpointRequest;
import io.skylite.core.indices.replication.common.ReplicationTimer;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskAwareRequest;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;

public class PublishCheckpointAction
extends TransportReplicationAction<PublishCheckpointRequest, PublishCheckpointRequest, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/publishCheckpoint";
    protected static Logger logger = LogManager.getLogger(PublishCheckpointAction.class);
    private final SegmentReplicationTargetService replicationService;

    @Inject
    public PublishCheckpointAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, SegmentReplicationTargetService targetService) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, shardStateAction::remoteShardFailed, actionFilters, PublishCheckpointRequest::new, PublishCheckpointRequest::new, "refresh");
        this.replicationService = targetService;
    }

    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    protected void doExecute(Task task, PublishCheckpointRequest request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use PublishCheckpointAction#publish";
    }

    public ReplicationMode getReplicationMode(BaseIndexShard indexShard) {
        if (indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return super.getReplicationMode(indexShard);
    }

    final void publish(final BaseIndexShard indexShard, final ReplicationCheckpoint checkpoint) {
        String primaryAllocationId = indexShard.routingEntry().allocationId().getId();
        long primaryTerm = indexShard.getPendingPrimaryTerm();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            PublishCheckpointRequest request = new PublishCheckpointRequest(checkpoint);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "segrep_publish_checkpoint", (TaskAwareRequest)request);
            final ReplicationTimer timer = new ReplicationTimer();
            timer.start();
            this.transportService.sendChildRequest(indexShard.recoveryState().getTargetNode(), this.transportPrimaryAction, (TransportRequest)new TransportReplicationAction.ConcreteShardRequest((TransportRequest)request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, (TransportResponseHandler)new TransportResponseHandler<ReplicationResponse>(){

                public ReplicationResponse read(StreamInput in) throws IOException {
                    return PublishCheckpointAction.this.newResponseInstance(in);
                }

                public String executor() {
                    return "same";
                }

                public void handleResponse(ReplicationResponse response) {
                    timer.stop();
                    logger.debug(() -> new ParameterizedMessage("[shardId {}] Completed publishing checkpoint [{}], timing: {}", new Object[]{indexShard.shardId().getId(), checkpoint, timer.time()}));
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister((Task)task);
                }

                public void handleException(TransportException e) {
                    timer.stop();
                    logger.debug("[shardId {}] Failed to publish checkpoint, timing: {}", (Object)indexShard.shardId().getId(), (Object)timer.time());
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister((Task)task);
                    if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{NodeClosedException.class, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class, ShardNotInPrimaryModeException.class}) != null) {
                        return;
                    }
                    logger.warn((Message)new ParameterizedMessage("{} segment replication checkpoint publishing failed", (Object)indexShard.shardId()), (Throwable)e);
                }
            });
            logger.trace(() -> new ParameterizedMessage("[shardId {}] Publishing replication checkpoint [{}]", (Object)checkpoint.getShardId().getId(), (Object)checkpoint));
        }
    }

    protected void shardOperationOnPrimary(PublishCheckpointRequest request, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> new TransportReplicationAction.PrimaryResult((ReplicationRequest)request, new ReplicationResponse()));
    }

    protected void shardOperationOnReplica(PublishCheckpointRequest request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        ActionListenerHelper.completeWith(listener, () -> {
            logger.trace(() -> new ParameterizedMessage("Checkpoint {} received on replica {}", (Object)request, (Object)replica.shardId()));
            if (!replica.indexSettings().isAssignedOnRemoteNode() && !replica.indexSettings().isSegRepLocalEnabled()) {
                logger.trace("Received segrep checkpoint on a docrep shard copy during an ongoing remote migration. NoOp.");
                return new TransportReplicationAction.ReplicaResult();
            }
            if (request.getCheckpoint().getShardId().equals((Object)replica.shardId())) {
                this.replicationService.onNewCheckpoint(request.getCheckpoint(), replica);
            }
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

