/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.common.concurrent.ListenableFuture;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.index.seqno.LocalCheckpointTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReplicationRequestTracker {
    private final Map<Long, ListenableFuture<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(final long requestSeqNo, final ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            ListenableFuture<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.addListener(listener, SkyliteExecutors.newDirectExecutorService());
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        ListenableFuture future = new ListenableFuture();
        this.ongoingRequests.put(requestSeqNo, (ListenableFuture<Void>)future);
        future.addListener((ActionListener)new ActionListener<Void>(){

            public void onResponse(Void v) {
                ReplicationRequestTracker.this.ongoingRequests.remove(requestSeqNo);
                listener.onResponse((Object)v);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, SkyliteExecutors.newDirectExecutorService());
        return future;
    }
}

