/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import io.lucenia.action.bulk.TransportBulkAction;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteParseException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.ingest.DeletePipelineRequest;
import io.skylite.core.action.ingest.PutPipelineRequest;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.metrics.OperationMetrics;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.env.Environment;
import io.skylite.core.index.VersionType;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.ingest.CompoundProcessor;
import io.skylite.core.ingest.ConditionalProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestInfo;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.ingest.IngestStats;
import io.skylite.core.ingest.Pipeline;
import io.skylite.core.ingest.PipelineConfiguration;
import io.skylite.core.ingest.PipelineProcessor;
import io.skylite.core.ingest.ProcessorInfo;
import io.skylite.core.ingest.WrappingProcessor;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.script.ScriptService;
import io.skylite.core.service.ReportingService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ingest.IngestMetadata;

public class IngestService
extends BaseIngestService
implements ClusterStateApplier,
ReportingService<IngestInfo> {
    public static final String INGEST_ORIGIN = "ingest";
    private static final Logger logger = LogManager.getLogger(IngestService.class);
    private final ClusterService clusterService;
    private final Map<String, AbstractProcessor.Factory<?>> processorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Collections.emptyMap();
    private final ThreadPool threadPool;
    private final OperationMetrics totalMetrics = new OperationMetrics();
    private final List<Consumer<ClusterState>> ingestClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private final ClusterManagerTaskThrottler.ThrottlingKey putPipelineTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deletePipelineTaskKey;
    private volatile ClusterState state;

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins, ReleasableSkyliteClient client) {
        super(scriptService);
        this.clusterService = clusterService;
        this.processorFactories = IngestService.processorFactories(ingestPlugins, new IngestProcessor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), () -> ((ThreadPool)threadPool).relativeTimeInMillis(), (delay, command) -> threadPool.schedule(command, TimeValue.timeValueMillis((long)delay), "generic"), (BaseIngestService)this, client, threadPool.generic()::execute));
        this.threadPool = threadPool;
        this.putPipelineTaskKey = clusterService.registerClusterManagerTask("put-pipeline", true);
        this.deletePipelineTaskKey = clusterService.registerClusterManagerTask("delete-pipeline", true);
    }

    private static Map<String, AbstractProcessor.Factory<?>> processorFactories(List<IngestPlugin> ingestPlugins, IngestProcessor.Parameters parameters) {
        HashMap<String, AbstractProcessor.Factory> processorFactories = new HashMap<String, AbstractProcessor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry entry : newProcessors.entrySet()) {
                if (processorFactories.put((String)entry.getKey(), (AbstractProcessor.Factory)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + (String)entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void delete(final DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerDelete(request, currentState);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.deletePipelineTaskKey;
            }
        });
    }

    static ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch((String)request.getId(), (String)string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern((String)request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", new Object[]{request.getId()});
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom(INGEST_ORIGIN, (Metadata.Custom)new IngestMetadata(pipelinesCopy)).build());
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetadata().custom(INGEST_ORIGIN);
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern((String)id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch((String)id, (String)entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        this.clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerPut(request, currentState);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.putPipelineTaskKey;
            }
        });
    }

    public Pipeline getPipeline(String id) {
        PipelineHolder holder = this.pipelines.get(id);
        if (holder != null) {
            return holder.pipeline;
        }
        return null;
    }

    public Map<String, AbstractProcessor.Factory<?>> getProcessorFactories() {
        return this.processorFactories;
    }

    public IngestInfo info() {
        Map<String, AbstractProcessor.Factory<?>> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, AbstractProcessor.Factory<?>> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, PipelineHolder> pipelines() {
        return this.pipelines;
    }

    private static List<Tuple<IngestProcessor, OperationMetrics>> getProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<IngestProcessor, OperationMetrics>> processorMetrics) {
        for (Tuple processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            IngestProcessor processor = (IngestProcessor)processorWithMetric.v1();
            OperationMetrics metric = (OperationMetrics)processorWithMetric.v2();
            if (processor instanceof CompoundProcessor) {
                IngestService.getProcessorMetrics((CompoundProcessor)processor, processorMetrics);
                continue;
            }
            if (processor instanceof ConditionalProcessor) {
                metric = ((ConditionalProcessor)processor).getMetric();
            }
            processorMetrics.add((Tuple<IngestProcessor, OperationMetrics>)new Tuple((Object)processor, (Object)metric));
        }
        return processorMetrics;
    }

    public static ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getMediaType()));
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom(INGEST_ORIGIN, (Metadata.Custom)new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Map pipelineConfig = (Map)XContentHelper.convertToMap((BytesReference)request.getSource(), (boolean)false, (MediaType)request.getMediaType()).v2();
        Pipeline pipeline = Pipeline.create((String)request.getId(), (Map)pipelineConfig, this.processorFactories, (ScriptService)this.scriptService);
        ArrayList<SkyliteException> exceptions = new ArrayList<SkyliteException>();
        for (IngestProcessor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException((String)processor.getType(), (String)processor.getTag(), null, (String)message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void executeBulkRequest(final int numberOfActionRequests, final Iterable<DocWriteRequest<?>> actionRequests, final BiConsumer<Integer, Exception> onFailure, final BiConsumer<Thread, Exception> onCompletion, final IntConsumer onDropped, String executorName) {
        this.threadPool.executor(executorName).execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                onCompletion.accept(null, e);
            }

            public void doRun() {
                Thread originalThread = Thread.currentThread();
                AtomicInteger counter = new AtomicInteger(numberOfActionRequests);
                int i = 0;
                for (DocWriteRequest actionRequest : actionRequests) {
                    List<String> pipelines;
                    IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
                    if (indexRequest == null) {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    String pipelineId = indexRequest.getPipeline();
                    indexRequest.setPipeline("_none");
                    String finalPipelineId = indexRequest.getFinalPipeline();
                    indexRequest.setFinalPipeline("_none");
                    boolean hasFinalPipeline = true;
                    if (!"_none".equals(pipelineId) && !"_none".equals(finalPipelineId)) {
                        pipelines = Arrays.asList(pipelineId, finalPipelineId);
                    } else if (!"_none".equals(pipelineId)) {
                        pipelines = Collections.singletonList(pipelineId);
                        hasFinalPipeline = false;
                    } else if (!"_none".equals(finalPipelineId)) {
                        pipelines = Collections.singletonList(finalPipelineId);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    IngestService.this.executePipelines(i, pipelines.iterator(), hasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    ++i;
                }
            }
        });
    }

    private void executePipelines(int slot, Iterator<String> it, boolean hasFinalPipeline, IndexRequest indexRequest, IntConsumer onDropped, BiConsumer<Integer, Exception> onFailure, AtomicInteger counter, BiConsumer<Thread, Exception> onCompletion, Thread originalThread) {
        while (it.hasNext()) {
            String pipelineId = it.next();
            try {
                PipelineHolder holder = this.pipelines.get(pipelineId);
                if (holder == null) {
                    throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
                }
                Pipeline pipeline = holder.pipeline;
                String originalIndex = indexRequest.indices()[0];
                this.innerExecute(slot, indexRequest, pipeline, onDropped, e -> {
                    if (e != null) {
                        logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e);
                        onFailure.accept(slot, (Exception)e);
                    }
                    Iterator<Object> newIt = it;
                    boolean newHasFinalPipeline = hasFinalPipeline;
                    String newIndex = indexRequest.indices()[0];
                    if (!Objects.equals(originalIndex, newIndex)) {
                        if (hasFinalPipeline && !it.hasNext()) {
                            this.totalMetrics.failed();
                            onFailure.accept(slot, new IllegalStateException("final pipeline [" + pipelineId + "] can't change the target index"));
                        } else {
                            it.forEachRemaining($ -> {});
                            indexRequest.isPipelineResolved(false);
                            IngestService.resolvePipelines(null, (IndexRequest)indexRequest, (Metadata)this.state.metadata());
                            if (!"_none".equals(indexRequest.getFinalPipeline())) {
                                newIt = Collections.singleton(indexRequest.getFinalPipeline()).iterator();
                                newHasFinalPipeline = true;
                            } else {
                                newIt = Collections.emptyIterator();
                            }
                        }
                    }
                    if (newIt.hasNext()) {
                        this.executePipelines(slot, (Iterator<String>)newIt, newHasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                    }
                });
            }
            catch (Exception e2) {
                logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e2);
                onFailure.accept(slot, e2);
                if (counter.decrementAndGet() == 0) {
                    onCompletion.accept(originalThread, null);
                }
                assert (counter.get() >= 0);
                break;
            }
        }
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, holder) -> {
            Pipeline pipeline = holder.pipeline;
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics(id, pipeline.getMetrics());
            ArrayList<Tuple<IngestProcessor, OperationMetrics>> processorMetrics = new ArrayList<Tuple<IngestProcessor, OperationMetrics>>();
            IngestService.getProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                IngestProcessor processor = (IngestProcessor)t.v1();
                OperationMetrics processorMetric = (OperationMetrics)t.v2();
                statsBuilder.addProcessorMetrics(id, IngestService.getProcessorName(processor), processor.getType(), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    public void addIngestClusterStateListener(Consumer<ClusterState> listener) {
        this.ingestClusterStateListeners.add(listener);
    }

    static String getProcessorName(IngestProcessor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            processor = ((ConditionalProcessor)processor).getInnerProcessor();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (processor instanceof PipelineProcessor) {
            String pipelineName = ((PipelineProcessor)processor).getPipelineTemplate().newInstance(Collections.emptyMap()).execute();
            sb.append(":");
            sb.append(pipelineName);
        }
        if ((tag = processor.getTag()) != null && !tag.isEmpty()) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private void innerExecute(int slot, IndexRequest indexRequest, Pipeline pipeline, IntConsumer itemDroppedHandler, Consumer<Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(null);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        this.totalMetrics.before();
        String index = indexRequest.index();
        String id = indexRequest.id();
        String routing = indexRequest.routing();
        Long version = indexRequest.version();
        VersionType versionType = indexRequest.versionType();
        Map sourceAsMap = indexRequest.sourceAsMap();
        IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, sourceAsMap);
        ingestDocument.executePipeline(pipeline, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
            this.totalMetrics.after(ingestTimeInMillis);
            if (e != null) {
                this.totalMetrics.failed();
                handler.accept((Exception)e);
            } else if (result == null) {
                itemDroppedHandler.accept(slot);
                handler.accept(null);
            } else {
                Map metadataMap = ingestDocument.extractMetadata();
                indexRequest.index((String)metadataMap.get(IngestDocument.Metadata.INDEX));
                indexRequest.id((String)metadataMap.get(IngestDocument.Metadata.ID));
                indexRequest.routing((String)metadataMap.get(IngestDocument.Metadata.ROUTING));
                indexRequest.version(((Number)metadataMap.get(IngestDocument.Metadata.VERSION)).longValue());
                if (metadataMap.get(IngestDocument.Metadata.VERSION_TYPE) != null) {
                    indexRequest.versionType(VersionType.fromString((String)((String)metadataMap.get(IngestDocument.Metadata.VERSION_TYPE))));
                }
                if (metadataMap.get(IngestDocument.Metadata.IF_SEQ_NO) != null) {
                    indexRequest.setIfSeqNo(((Number)metadataMap.get(IngestDocument.Metadata.IF_SEQ_NO)).longValue());
                }
                if (metadataMap.get(IngestDocument.Metadata.IF_PRIMARY_TERM) != null) {
                    indexRequest.setIfPrimaryTerm(((Number)metadataMap.get(IngestDocument.Metadata.IF_PRIMARY_TERM)).longValue());
                }
                indexRequest.source(ingestDocument.getSourceAndMetadata(), indexRequest.getContentType());
                handler.accept(null);
            }
        });
    }

    public void applyClusterState(ClusterStateChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.ingestClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        IngestMetadata newIngestMetadata = (IngestMetadata)this.state.getMetadata().custom(INGEST_ORIGIN);
        if (newIngestMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newIngestMetadata);
        }
        catch (SkyliteParseException e) {
            logger.warn("failed to update ingest pipelines", (Throwable)e);
        }
    }

    void innerUpdatePipelines(IngestMetadata newIngestMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<SkyliteParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newIngestMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals((Object)pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                Pipeline newPipeline = Pipeline.create((String)pipelineConfiguration.getId(), (Map)pipelineConfiguration.getConfigAsMap(), this.processorFactories, (ScriptService)this.scriptService);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                Pipeline oldPipeline = previous.pipeline;
                newPipeline.getMetrics().add(oldPipeline.getMetrics());
                ArrayList<Tuple<IngestProcessor, OperationMetrics>> oldPerProcessMetrics = new ArrayList<Tuple<IngestProcessor, OperationMetrics>>();
                ArrayList<Tuple<IngestProcessor, OperationMetrics>> newPerProcessMetrics = new ArrayList<Tuple<IngestProcessor, OperationMetrics>>();
                IngestService.getProcessorMetrics(oldPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                IngestService.getProcessorMetrics(newPipeline.getCompoundProcessor(), newPerProcessMetrics);
                if (newPerProcessMetrics.size() != oldPerProcessMetrics.size()) continue;
                Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                for (Tuple tuple : newPerProcessMetrics) {
                    String type = ((IngestProcessor)tuple.v1()).getType();
                    OperationMetrics metric = (OperationMetrics)tuple.v2();
                    if (!oldMetricsIterator.hasNext()) continue;
                    Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                    String oldType = ((IngestProcessor)oldCompositeMetric.v1()).getType();
                    OperationMetrics oldMetric = (OperationMetrics)oldCompositeMetric.v2();
                    if (!type.equals(oldType)) continue;
                    metric.add(oldMetric);
                }
            }
            catch (SkyliteParseException e) {
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), e);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList<SkyliteParseException>();
                }
                exceptions.add(e);
            }
            catch (Exception e) {
                SkyliteParseException parseException = new SkyliteParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), parseException);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newIngestMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Collections.unmodifiableMap(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public <P extends IngestProcessor> List<P> getProcessorsInPipeline(String pipelineId, Class<P> clazz) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        ArrayList<IngestProcessor> processors = new ArrayList<IngestProcessor>();
        block0: for (IngestProcessor processor : pipeline.flattenAllProcessors()) {
            if (clazz.isAssignableFrom(processor.getClass())) {
                processors.add((IngestProcessor)clazz.cast(processor));
            }
            while (processor instanceof WrappingProcessor) {
                WrappingProcessor wrappingProcessor = (WrappingProcessor)processor;
                if (clazz.isAssignableFrom(wrappingProcessor.getInnerProcessor().getClass())) {
                    processors.add((IngestProcessor)clazz.cast(wrappingProcessor.getInnerProcessor()));
                }
                if (wrappingProcessor != (processor = wrappingProcessor.getInnerProcessor())) continue;
                continue block0;
            }
        }
        return processors;
    }

    private static Pipeline substitutePipeline(String id, SkyliteParseException e) {
        final String tag = e.getHeaderKeys().contains("processor_tag") ? (String)e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? (String)e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        IngestProcessor failureProcessor = new IngestProcessor(){

            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            public String getType() {
                return type;
            }

            public String getTag() {
                return tag;
            }

            public String getDescription() {
                return "this is a placeholder processor";
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, new CompoundProcessor(new IngestProcessor[]{failureProcessor}));
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final Pipeline pipeline;

        PipelineHolder(PipelineConfiguration configuration, Pipeline pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }
}

