/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import io.skylite.common.SingleObjectCache;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.monitor.FsInfo;
import io.skylite.core.monitor.FsProbe;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FsService {
    private static final Logger logger = LogManager.getLogger(FsService.class);
    private final Supplier<FsInfo> fsInfoSupplier;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting((String)"monitor.fs.refresh_interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ALWAYS_REFRESH_SETTING = Setting.boolSetting((String)"monitor.fs.always_refresh", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public FsService(Settings settings, NodeEnvironment nodeEnvironment, FileCache fileCache) {
        FsProbe probe = new FsProbe(nodeEnvironment, fileCache);
        FsInfo initialValue = FsService.stats(probe, null);
        if (((Boolean)ALWAYS_REFRESH_SETTING.get(settings)).booleanValue()) {
            assert (!REFRESH_INTERVAL_SETTING.exists(settings));
            logger.debug("bypassing refresh_interval");
            this.fsInfoSupplier = () -> FsService.stats(probe, initialValue);
        } else {
            TimeValue refreshInterval = (TimeValue)REFRESH_INTERVAL_SETTING.get(settings);
            logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
            this.fsInfoSupplier = () -> ((FsInfoCache)new FsInfoCache(refreshInterval, initialValue, probe)).getOrRefresh();
        }
    }

    public FsInfo stats() {
        return this.fsInfoSupplier.get();
    }

    private static FsInfo stats(FsProbe probe, FsInfo initialValue) {
        try {
            return probe.stats(initialValue);
        }
        catch (IOException e) {
            logger.debug("unexpected exception reading filesystem info", (Throwable)e);
            return null;
        }
    }

    private static class FsInfoCache
    extends SingleObjectCache<FsInfo> {
        private final FsInfo initialValue;
        private final FsProbe probe;

        FsInfoCache(TimeValue interval, FsInfo initialValue, FsProbe probe) {
            super(interval, (Object)initialValue);
            this.initialValue = initialValue;
            this.probe = probe;
        }

        protected FsInfo refresh() {
            return FsService.stats(this.probe, this.initialValue);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(REFRESH_INTERVAL_SETTING);
        }
    }
}

