/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import io.lucenia.plugins.PluginsService;
import io.skylite.Build;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.aggregations.AggregationUsageService;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.WeightedRoutingStats;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.discovery.Discovery;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.pipeline.SearchPipelineService;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.tasks.TaskCancellationMonitoringService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.opensearch.index.SegmentReplicationStatsTracker;
import org.opensearch.indices.IndicesService;
import org.opensearch.ingest.IngestService;
import org.opensearch.monitor.MonitorService;
import org.opensearch.node.ResourceUsageCollectorService;
import org.opensearch.search.backpressure.SearchBackpressureService;

public class NodeService
implements Closeable {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private final ScriptService scriptService;
    private final HttpServerTransport httpServerTransport;
    private final ResponseCollectorService responseCollectorService;
    private final ResourceUsageCollectorService resourceUsageCollectorService;
    private final SearchTransportService searchTransportService;
    private final IndexingPressureService indexingPressureService;
    private final AggregationUsageService aggregationUsageService;
    private final SearchBackpressureService searchBackpressureService;
    private final SearchPipelineService searchPipelineService;
    private final ClusterService clusterService;
    private final Discovery discovery;
    private final FileCache fileCache;
    private final TaskCancellationMonitoringService taskCancellationMonitoringService;
    private final RepositoriesService repositoriesService;
    private final SegmentReplicationStatsTracker segmentReplicationStatsTracker;

    NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServerTransport httpServerTransport, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter, ResponseCollectorService responseCollectorService, SearchTransportService searchTransportService, IndexingPressureService indexingPressureService, AggregationUsageService aggregationUsageService, SearchBackpressureService searchBackpressureService, SearchPipelineService searchPipelineService, FileCache fileCache, TaskCancellationMonitoringService taskCancellationMonitoringService, ResourceUsageCollectorService resourceUsageCollectorService, SegmentReplicationStatsTracker segmentReplicationStatsTracker, RepositoriesService repositoriesService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServerTransport = httpServerTransport;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.searchTransportService = searchTransportService;
        this.indexingPressureService = indexingPressureService;
        this.aggregationUsageService = aggregationUsageService;
        this.searchBackpressureService = searchBackpressureService;
        this.searchPipelineService = searchPipelineService;
        this.clusterService = clusterService;
        this.fileCache = fileCache;
        this.taskCancellationMonitoringService = taskCancellationMonitoringService;
        this.resourceUsageCollectorService = resourceUsageCollectorService;
        this.repositoriesService = repositoriesService;
        clusterService.addStateApplier((ClusterStateApplier)ingestService);
        clusterService.addStateApplier((ClusterStateApplier)searchPipelineService);
        this.segmentReplicationStatsTracker = segmentReplicationStatsTracker;
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean aggs, boolean indices, boolean searchPipeline) {
        NodeInfo.Builder builder = NodeInfo.builder((Version)Version.CURRENT, (Build)Build.CURRENT, (DiscoveryNode)this.transportService.getLocalNode());
        if (settings) {
            builder.setSettings(this.settingsFilter.filter(this.settings));
        }
        if (os) {
            builder.setOs(this.monitorService.osService().info());
        }
        if (process) {
            builder.setProcess(this.monitorService.processService().info());
        }
        if (jvm) {
            builder.setJvm(this.monitorService.jvmService().info());
        }
        if (threadPool) {
            builder.setThreadPool(this.threadPool.info());
        }
        if (transport) {
            builder.setTransport(this.transportService.info());
        }
        if (http && this.httpServerTransport != null) {
            builder.setHttp(this.httpServerTransport.info());
        }
        if (plugin && this.pluginService != null) {
            builder.setPlugins(this.pluginService.info());
        }
        if (ingest && this.ingestService != null) {
            builder.setIngest(this.ingestService.info());
        }
        if (aggs && this.aggregationUsageService != null) {
            builder.setAggsInfo(this.aggregationUsageService.info());
        }
        if (indices) {
            builder.setTotalIndexingBuffer(this.indicesService.getTotalIndexingBufferBytes());
        }
        if (searchPipeline && this.searchPipelineService != null) {
            builder.setSearchPipelineInfo(this.searchPipelineService.info());
        }
        return builder.build();
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest, boolean adaptiveSelection, boolean scriptCache, boolean indexingPressure, boolean shardIndexingPressure, boolean searchBackpressure, boolean clusterManagerThrottling, boolean weightedRoutingStats, boolean fileCacheStats, boolean taskCancellation, boolean searchPipelineStats, boolean resourceUsageStats, boolean segmentReplicationTrackerStats, boolean repositoriesStats) {
        return new NodeStats(this.transportService.getLocalNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.stats() : null, adaptiveSelection ? this.responseCollectorService.getAdaptiveStats(this.searchTransportService.getPendingSearchRequests()) : null, resourceUsageStats ? this.resourceUsageCollectorService.stats() : null, scriptCache ? this.scriptService.cacheStats() : null, indexingPressure ? this.indexingPressureService.nodeStats() : null, shardIndexingPressure ? this.indexingPressureService.shardStats(indices) : null, searchBackpressure ? this.searchBackpressureService.nodeStats() : null, clusterManagerThrottling ? this.clusterService.getClusterManagerService().getThrottlingStats() : null, (WeightedRoutingStats)(weightedRoutingStats ? WeightedRoutingStats.getInstance() : null), fileCacheStats && this.fileCache != null ? this.fileCache.fileCacheStats() : null, taskCancellation ? this.taskCancellationMonitoringService.stats() : null, searchPipelineStats ? this.searchPipelineService.stats() : null, segmentReplicationTrackerStats ? this.segmentReplicationStatsTracker.getTotalRejectionStats() : null, repositoriesStats ? this.repositoriesService.getRepositoriesStats() : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    public MonitorService getMonitorService() {
        return this.monitorService;
    }

    public SearchBackpressureService getSearchBackpressureService() {
        return this.searchBackpressureService;
    }

    public TaskCancellationMonitoringService getTaskCancellationMonitoringService() {
        return this.taskCancellationMonitoringService;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Object)this.indicesService));
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.indicesService.awaitClose(timeout, timeUnit);
    }
}

