/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node.resource.tracker;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;

public class ResourceTrackerSettings {
    public static final Setting<TimeValue> GLOBAL_CPU_USAGE_AC_POLLING_INTERVAL_SETTING = Setting.positiveTimeSetting((String)"node.resource.tracker.global_cpu_usage.polling_interval", (TimeValue)TimeValue.timeValueMillis((long)500L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING = Setting.positiveTimeSetting((String)"node.resource.tracker.global_cpu_usage.window_duration", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> GLOBAL_JVM_USAGE_AC_POLLING_INTERVAL_SETTING = Setting.positiveTimeSetting((String)"node.resource.tracker.global_jvmmp.polling_interval", (TimeValue)TimeValue.timeValueMillis((long)500L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING = Setting.positiveTimeSetting((String)"node.resource.tracker.global_jvmmp.window_duration", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile TimeValue cpuWindowDuration;
    private volatile TimeValue cpuPollingInterval;
    private volatile TimeValue memoryWindowDuration;
    private volatile TimeValue memoryPollingInterval;

    public ResourceTrackerSettings(Settings settings) {
        this.cpuPollingInterval = (TimeValue)GLOBAL_CPU_USAGE_AC_POLLING_INTERVAL_SETTING.get(settings);
        this.cpuWindowDuration = (TimeValue)GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING.get(settings);
        this.memoryPollingInterval = (TimeValue)GLOBAL_JVM_USAGE_AC_POLLING_INTERVAL_SETTING.get(settings);
        this.memoryWindowDuration = (TimeValue)GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING.get(settings);
    }

    public TimeValue getCpuWindowDuration() {
        return this.cpuWindowDuration;
    }

    public TimeValue getCpuPollingInterval() {
        return this.cpuPollingInterval;
    }

    public TimeValue getMemoryPollingInterval() {
        return this.memoryPollingInterval;
    }

    public TimeValue getMemoryWindowDuration() {
        return this.memoryWindowDuration;
    }

    public void setCpuWindowDuration(TimeValue cpuWindowDuration) {
        this.cpuWindowDuration = cpuWindowDuration;
    }

    public void setMemoryWindowDuration(TimeValue memoryWindowDuration) {
        this.memoryWindowDuration = memoryWindowDuration;
    }

    private static class Defaults {
        private static final long POLLING_INTERVAL_IN_MILLIS = 500L;
        private static final long WINDOW_DURATION_IN_SECONDS = 30L;

        private Defaults() {
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING, GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING);
        }
    }
}

