/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.Nullable;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.threadpool.ThreadPool;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksExecutor;

public class NodePersistentTasksExecutor {
    private final ThreadPool threadPool;

    NodePersistentTasksExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void executeTask(final Params params, final @Nullable PersistentTaskState state, final AllocatedPersistentTask task, final PersistentTasksExecutor<Params> executor) {
        this.threadPool.executor(executor.getExecutor()).execute((Runnable)new AbstractRunnable(this){

            public void onFailure(Exception e) {
                task.markAsFailed(e);
            }

            public void doRun() throws Exception {
                try {
                    executor.nodeOperation(task, params, state);
                }
                catch (Exception ex) {
                    task.markAsFailed(ex);
                }
            }
        });
    }
}

