/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskAwareRequest;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.tasks.TaskManager;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.NodePersistentTasksExecutor;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.PersistentTasksService;

public class PersistentTasksNodeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PersistentTasksNodeService.class);
    private final Map<Long, AllocatedPersistentTask> runningTasks = new HashMap<Long, AllocatedPersistentTask>();
    private final PersistentTasksService persistentTasksService;
    private final PersistentTasksExecutorRegistry persistentTasksExecutorRegistry;
    private final TaskManager taskManager;
    private final NodePersistentTasksExecutor nodePersistentTasksExecutor;

    public PersistentTasksNodeService(PersistentTasksService persistentTasksService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, TaskManager taskManager, NodePersistentTasksExecutor nodePersistentTasksExecutor) {
        this.persistentTasksService = persistentTasksService;
        this.persistentTasksExecutorRegistry = persistentTasksExecutorRegistry;
        this.taskManager = taskManager;
        this.nodePersistentTasksExecutor = nodePersistentTasksExecutor;
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        PersistentTasksCustomMetadata previousTasks;
        if (event.state().blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks");
        if (!Objects.equals((Object)tasks, (Object)(previousTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks"))) || event.nodesChanged()) {
            String localNodeId = event.state().getNodes().getLocalNodeId();
            HashSet<Long> notVisitedTasks = new HashSet<Long>(this.runningTasks.keySet());
            if (tasks != null) {
                for (PersistentTasksCustomMetadata.PersistentTask persistentTask : tasks.tasks()) {
                    if (!localNodeId.equals(persistentTask.getExecutorNode())) continue;
                    Long allocationId = persistentTask.getAllocationId();
                    AllocatedPersistentTask persistentTask2 = this.runningTasks.get(allocationId);
                    if (persistentTask2 == null) {
                        try {
                            this.startTask(persistentTask);
                        }
                        catch (Exception e) {
                            logger.error("Unable to start allocated task [" + persistentTask.getTaskName() + "] with id [" + persistentTask.getId() + "] and allocation id [" + persistentTask.getAllocationId() + "]", (Throwable)e);
                        }
                        continue;
                    }
                    notVisitedTasks.remove(allocationId);
                }
            }
            for (Long l : notVisitedTasks) {
                AllocatedPersistentTask task = this.runningTasks.get(l);
                if (task.isCompleted()) {
                    logger.trace("Found completed persistent task [{}] with id [{}] and allocation id [{}] - removing", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                    this.runningTasks.remove(l);
                    continue;
                }
                logger.trace("Found unregistered persistent task [{}] with id [{}] and allocation id [{}] - cancelling", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.cancelTask(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Params extends PersistentTaskParams> void startTask(final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress) {
        AllocatedPersistentTask task;
        final PersistentTasksExecutor executor = this.persistentTasksExecutorRegistry.getPersistentTaskExecutorSafe(taskInProgress.getTaskName());
        TaskAwareRequest request = new TaskAwareRequest(){
            TaskId parentTaskId;
            {
                this.parentTaskId = new TaskId("cluster", taskInProgress.getAllocationId());
            }

            public void setParentTask(TaskId taskId) {
                throw new UnsupportedOperationException("parent task if for persistent tasks shouldn't change");
            }

            public TaskId getParentTask() {
                return this.parentTaskId;
            }

            public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return executor.createTask(id, type, action, parentTaskId, taskInProgress, headers);
            }
        };
        try {
            task = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", request);
        }
        catch (Exception e) {
            logger.error("Fatal error registering persistent task [" + taskInProgress.getTaskName() + "] with id [" + taskInProgress.getId() + "] and allocation id [" + taskInProgress.getAllocationId() + "], removing from persistent tasks", (Throwable)e);
            this.notifyMasterOfFailedTask(taskInProgress, e);
            return;
        }
        boolean processed = false;
        try {
            task.init(this.persistentTasksService, this.taskManager, taskInProgress.getId(), taskInProgress.getAllocationId());
            logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was created", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
            try {
                this.runningTasks.put(taskInProgress.getAllocationId(), task);
                this.nodePersistentTasksExecutor.executeTask(taskInProgress.getParams(), taskInProgress.getState(), task, executor);
            }
            catch (Exception e) {
                task.markAsFailed(e);
            }
            processed = true;
        }
        finally {
            if (!processed) {
                logger.warn("Persistent task [{}] with id [{}] and allocation id [{}] failed to create", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.taskManager.unregister((Task)task);
            }
        }
    }

    private <Params extends PersistentTaskParams> void notifyMasterOfFailedTask(final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, final Exception originalException) {
        this.persistentTasksService.sendCompletionRequest(taskInProgress.getId(), taskInProgress.getAllocationId(), originalException, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                logger.trace("completion notification for failed task [{}] with id [{}] was successful", (Object)taskInProgress.getTaskName(), (Object)taskInProgress.getAllocationId());
            }

            public void onFailure(Exception notificationException) {
                notificationException.addSuppressed(originalException);
                logger.warn((Message)new ParameterizedMessage("notification for task [{}] with id [{}] failed", (Object)taskInProgress.getTaskName(), (Object)taskInProgress.getAllocationId()), (Throwable)notificationException);
            }
        });
    }

    private void cancelTask(Long allocationId) {
        final AllocatedPersistentTask task = this.runningTasks.remove(allocationId);
        if (task.markAsCancelled()) {
            String reason = "task has been removed, cancelling locally";
            this.persistentTasksService.sendCancelRequest(task.getId(), reason, new ActionListener<CancelTasksResponse>(){

                public void onResponse(CancelTasksResponse cancelTasksResponse) {
                    logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was cancelled", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                }

                public void onFailure(Exception e) {
                    logger.warn(() -> new ParameterizedMessage("failed to cancel task [{}] with id [{}] and allocation id [{}]", new Object[]{task.getAction(), task.getPersistentTaskId(), task.getAllocationId()}), (Throwable)e);
                }
            });
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "persistent_executor";
        private final AllocatedPersistentTask.State state;

        public Status(AllocatedPersistentTask.State state) {
            this.state = Objects.requireNonNull(state, "State cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.state = AllocatedPersistentTask.State.valueOf(in.readString());
        }

        public String getWriteableName() {
            return NAME;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.state.toString());
        }

        public String toString() {
            return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
        }

        public boolean isFragment() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.state == status.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state});
        }
    }
}

