/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.persistent.CompletionPersistentTaskAction;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskResponse;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.RemovePersistentTaskAction;
import org.opensearch.persistent.StartPersistentTaskAction;
import org.opensearch.persistent.UpdatePersistentTaskStatusAction;

public class PersistentTasksService {
    private static final Logger logger = LogManager.getLogger(PersistentTasksService.class);
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public PersistentTasksService(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.client = new OriginSettingClient(client, PERSISTENT_TASK_ORIGIN);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void sendStartRequest(String taskId, String taskName, Params taskParams, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        ActionListener wrappedListener = ActionListenerHelper.map(listener, t -> t);
        StartPersistentTaskAction.Request request = new StartPersistentTaskAction.Request(taskId, taskName, taskParams);
        this.execute(request, StartPersistentTaskAction.INSTANCE, wrappedListener);
    }

    public void sendCompletionRequest(String taskId, long taskAllocationId, @Nullable Exception taskFailure, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        CompletionPersistentTaskAction.Request request = new CompletionPersistentTaskAction.Request(taskId, taskAllocationId, taskFailure);
        this.execute(request, CompletionPersistentTaskAction.INSTANCE, listener);
    }

    void sendCancelRequest(long taskId, String reason, ActionListener<CancelTasksResponse> listener) {
        CancelTasksRequest request = new CancelTasksRequest();
        request.setTaskId(new TaskId(this.clusterService.localNode().getId(), taskId));
        request.setReason(reason);
        try {
            this.client.admin().cluster().cancelTasks(request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void sendUpdateStateRequest(String taskId, long taskAllocationID, PersistentTaskState taskState, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        UpdatePersistentTaskStatusAction.Request request = new UpdatePersistentTaskStatusAction.Request(taskId, taskAllocationID, taskState);
        this.execute(request, UpdatePersistentTaskStatusAction.INSTANCE, listener);
    }

    public void sendRemoveRequest(String taskId, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        RemovePersistentTaskAction.Request request = new RemovePersistentTaskAction.Request(taskId);
        this.execute(request, RemovePersistentTaskAction.INSTANCE, listener);
    }

    private <Req extends ActionRequest, Resp extends PersistentTaskResponse> void execute(Req request, ActionType<Resp> action, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        try {
            this.client.execute(action, request, ActionListenerHelper.map(listener, PersistentTaskResponse::getTask));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void waitForPersistentTaskCondition(final String taskId, Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskListener<?> listener) {
        Predicate<ClusterState> clusterStatePredicate = clusterState -> predicate.test(PersistentTasksCustomMetadata.getTaskWithId(clusterState, taskId));
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, timeout, logger, this.threadPool.getThreadContext());
        ClusterState clusterState2 = observer.setAndGetObservedState();
        if (clusterStatePredicate.test(clusterState2)) {
            listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(clusterState2, taskId));
        } else {
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(state, taskId));
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onTimeout(timeout);
                }
            }, clusterStatePredicate);
        }
    }

    public void waitForPersistentTasksCondition(Predicate<PersistentTasksCustomMetadata> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        Predicate<ClusterState> clusterStatePredicate = clusterState -> predicate.test((PersistentTasksCustomMetadata)clusterState.metadata().custom(PERSISTENT_TASK_ORIGIN));
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, timeout, logger, this.threadPool.getThreadContext());
        if (clusterStatePredicate.test(observer.setAndGetObservedState())) {
            listener.onResponse((Object)true);
        } else {
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    listener.onResponse((Object)true);
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)new IllegalStateException("Timed out when waiting for persistent tasks after " + String.valueOf(timeout)));
                }
            }, clusterStatePredicate, timeout);
        }
    }

    public static interface WaitForPersistentTaskListener<P extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetadata.PersistentTask<P>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("Timed out when waiting for persistent task after " + String.valueOf(timeout)));
        }
    }
}

