/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.clustermanager.ClusterManagerNodeOperationRequestBuilder;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.persistent.NodePersistentTasksExecutor;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskResponse;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.PersistentTasksNodeService;
import org.opensearch.persistent.PersistentTasksService;

public class StartPersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final StartPersistentTaskAction INSTANCE = new StartPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/start";

    private StartPersistentTaskAction() {
        super(NAME, PersistentTaskResponse::new);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return INSTANCE;
        }

        public Class<? extends io.skylite.core.action.support.TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAction.class;
        }
    }

    public static class TransportAction
    extends TransportClusterManagerNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, PersistentTasksService persistentTasksService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(StartPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.persistentTasksClusterService = persistentTasksClusterService;
            NodePersistentTasksExecutor executor = new NodePersistentTasksExecutor(threadPool);
            clusterService.addListener((ClusterStateListener)new PersistentTasksNodeService(persistentTasksService, persistentTasksExecutorRegistry, transportService.getTaskManager(), executor));
        }

        protected String executor() {
            return "generic";
        }

        protected PersistentTaskResponse read(StreamInput in) throws IOException {
            return new PersistentTaskResponse(in);
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected final void clusterManagerOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.createPersistentTask(request.taskId, request.taskName, request.params, ActionListenerHelper.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse((Object)new PersistentTaskResponse((PersistentTasksCustomMetadata.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends ClusterManagerNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(SkyliteClient client, StartPersistentTaskAction action) {
            super(client, (ActionType)action, (ClusterManagerNodeRequest)new Request());
        }

        public RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }

        public RequestBuilder setAction(String action) {
            ((Request)this.request).setTaskName(action);
            return this;
        }

        public RequestBuilder setRequest(PersistentTaskParams params) {
            ((Request)this.request).setParams(params);
            return this;
        }
    }

    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private String taskId;
        private String taskName;
        private PersistentTaskParams params;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
            this.taskName = in.readString();
            this.params = (PersistentTaskParams)in.readNamedWriteable(PersistentTaskParams.class);
        }

        public Request(String taskId, String taskName, PersistentTaskParams params) {
            this.taskId = taskId;
            this.taskName = taskName;
            this.params = params;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeString(this.taskName);
            out.writeNamedWriteable((NamedWriteable)this.params);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError((String)"task id must be specified", validationException);
            }
            if (this.taskName == null) {
                validationException = ValidateActions.addValidationError((String)"action must be specified", (ActionRequestValidationException)validationException);
            }
            if (this.params != null && !this.params.getWriteableName().equals(this.taskName)) {
                validationException = ValidateActions.addValidationError((String)("params have to have the same writeable name as task. params: " + this.params.getWriteableName() + " task: " + this.taskName), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request1 = (Request)((Object)o);
            return Objects.equals(this.taskId, request1.taskId) && Objects.equals(this.taskName, request1.taskName) && Objects.equals(this.params, request1.params);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.taskName, this.params);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public PersistentTaskParams getParams() {
            return this.params;
        }

        @Nullable
        public void setParams(PersistentTaskParams params) {
            this.params = params;
        }
    }
}

