/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlSettings;
import org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;
import org.opensearch.ratelimitting.admissioncontrol.controllers.CPUBasedAdmissionController;

public class AdmissionControlService {
    private final ThreadPool threadPool;
    public final AdmissionControlSettings admissionControlSettings;
    private final ConcurrentMap<String, AdmissionController> ADMISSION_CONTROLLERS;
    private static final Logger logger = LogManager.getLogger(AdmissionControlService.class);
    private final ClusterSettings clusterSettings;
    private final Settings settings;

    public AdmissionControlService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.admissionControlSettings = new AdmissionControlSettings(clusterSettings, settings);
        this.ADMISSION_CONTROLLERS = new ConcurrentHashMap<String, AdmissionController>();
        this.clusterSettings = clusterSettings;
        this.settings = settings;
        this.initialise();
    }

    private void initialise() {
        this.registerAdmissionController("global_cpu_usage");
    }

    public void applyTransportAdmissionControl(String action) {
        this.ADMISSION_CONTROLLERS.forEach((name, admissionController) -> admissionController.apply(action));
    }

    public void registerAdmissionController(String admissionControllerName) {
        AdmissionController admissionController = this.controllerFactory(admissionControllerName);
        this.ADMISSION_CONTROLLERS.put(admissionControllerName, admissionController);
    }

    private AdmissionController controllerFactory(String admissionControllerName) {
        switch (admissionControllerName) {
            case "global_cpu_usage": {
                return new CPUBasedAdmissionController(admissionControllerName, this.settings, this.clusterSettings);
            }
        }
        throw new IllegalArgumentException("Not Supported AdmissionController : " + admissionControllerName);
    }

    public List<AdmissionController> getAdmissionControllers() {
        return new ArrayList<AdmissionController>(this.ADMISSION_CONTROLLERS.values());
    }

    public AdmissionController getAdmissionController(String controllerName) {
        return this.ADMISSION_CONTROLLERS.getOrDefault(controllerName, null);
    }
}

