/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.controllers;

import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlMode;

public abstract class AdmissionController {
    private final AtomicLong rejectionCount;
    private final String admissionControllerName;

    public AdmissionController(AtomicLong rejectionCount, String admissionControllerName) {
        this.rejectionCount = rejectionCount;
        this.admissionControllerName = admissionControllerName;
    }

    public boolean isEnabledForTransportLayer(AdmissionControlMode admissionControlMode) {
        return admissionControlMode != AdmissionControlMode.DISABLED;
    }

    public abstract void apply(String var1);

    public String getName() {
        return this.admissionControllerName;
    }

    public void addRejectionCount(long count) {
        this.rejectionCount.addAndGet(count);
    }

    public long getRejectionCount() {
        return this.rejectionCount.get();
    }
}

