/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.controllers;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;
import org.opensearch.ratelimitting.admissioncontrol.settings.CPUBasedAdmissionControllerSettings;

public class CPUBasedAdmissionController
extends AdmissionController {
    private static final Logger LOGGER = LogManager.getLogger(CPUBasedAdmissionController.class);
    public CPUBasedAdmissionControllerSettings settings;

    public CPUBasedAdmissionController(String admissionControllerName, Settings settings, ClusterSettings clusterSettings) {
        super(new AtomicLong(0L), admissionControllerName);
        this.settings = new CPUBasedAdmissionControllerSettings(clusterSettings, settings);
    }

    @Override
    public void apply(String action) {
        if (this.isEnabledForTransportLayer(this.settings.getTransportLayerAdmissionControllerMode())) {
            this.applyForTransportLayer(action);
        }
    }

    private void applyForTransportLayer(String actionName) {
        if (this.getRejectionCount() < 10L) {
            this.addRejectionCount(1L);
        }
    }
}

